/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.FolderLevelEnum;
import com.digiwin.athena.semc.common.enums.FolderTypeEnum;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.common.Folder;
import com.digiwin.athena.semc.entity.common.ImportRecord;
import com.digiwin.athena.semc.entity.portal.FineReport;
import com.digiwin.athena.semc.service.common.IFolderService;
import com.digiwin.athena.semc.service.portal.IFineReportService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelVo;
import com.digiwin.athena.semc.vo.common.FolderLevelVo;
import com.digiwin.athena.semc.vo.common.ImportRecordResp;
import com.digiwin.athena.semc.vo.portal.ExportExcelVo;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.ImportExcelVo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.linpeilie.Converter;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/importReport"})
public class ImportReportController
extends BasicController<IImportRecordService, ImportRecord> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportReportController.class);
    @Resource
    private IImportRecordService importRecordService;
    @Resource
    private IFolderService folderService;
    @Resource
    private IFineReportService fineReportService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private Converter converter;

    @GetMapping(value={"/importExcel"})
    public ResponseEntity<?> importExcel(@RequestParam String fileId, @RequestParam String fileName) {
        ImportExcelResp excelResp = new ImportExcelResp();
        try {
            List excelVoList = this.importRecordService.readExcel(fileId);
            if (CollectionUtils.isEmpty((Collection)excelVoList)) {
                return ResponseEntityWrapper.wrapperOk((Object)excelVoList);
            }
            if (excelVoList.size() > 1000) {
                excelResp.setResultCode("0");
                return ResponseEntityWrapper.wrapperOk((Object)excelResp);
            }
            int successNum = 0;
            int failNum = 0;
            List allFolderList = this.folderService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue())).orderByAsc((Object)"folder_order"));
            Folder maxOrderFolder = allFolderList.stream().filter(x -> FolderLevelEnum.FIRST.getValue().equals(x.getLevel())).max(Comparator.comparing(Folder::getFolderOrder)).get();
            AtomicInteger firstOrder = new AtomicInteger(maxOrderFolder.getFolderOrder());
            HashMap childOrderMap = Maps.newHashMap();
            for (Folder folder : allFolderList) {
                if (FolderLevelEnum.THIRD.getValue().equals(folder.getLevel())) continue;
                Folder tempFolder = allFolderList.stream().filter(x -> !FolderLevelEnum.FIRST.getValue().equals(x.getLevel()) && x.getParentFolderId().equals(folder.getId())).max(Comparator.comparing(Folder::getFolderOrder)).orElse(null);
                childOrderMap.put(folder.getId(), tempFolder == null ? 0 : tempFolder.getFolderOrder());
            }
            ArrayList nameList = Lists.newArrayList();
            ArrayList urlList = Lists.newArrayList();
            List fineReportList = this.fineReportService.list();
            if (CollectionUtils.isNotEmpty((Collection)fineReportList)) {
                nameList.addAll(fineReportList.stream().map(FineReport::getName).collect(Collectors.toList()));
                urlList.addAll(fineReportList.stream().map(FineReport::getUrl).collect(Collectors.toList()));
            }
            ArrayList failList = Lists.newArrayList();
            Map<Long, FineReport> orderMap = fineReportList.stream().peek(x -> {
                if (x.getReportOrder() == null) {
                    x.setReportOrder(Integer.valueOf(0));
                }
            }).collect(Collectors.toMap(FineReport::getFolderId, fineReport -> fineReport, BinaryOperator.maxBy(Comparator.comparing(FineReport::getReportOrder))));
            HashMap reportOrderMap = Maps.newHashMap();
            allFolderList.forEach(x -> reportOrderMap.put(x.getName(), orderMap.get(x.getId()) != null ? ((FineReport)orderMap.get(x.getId())).getReportOrder() : 0));
            for (ImportExcelVo excelVo : excelVoList) {
                List allNameList = allFolderList.stream().map(Folder::getName).collect(Collectors.toList());
                StringBuilder errorSb = this.validate(excelVo, (List)nameList, (List)urlList);
                if (StringUtils.isNotBlank((String)errorSb.toString())) {
                    ++failNum;
                    excelVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                    failList.add(excelVo);
                    continue;
                }
                if (!allNameList.contains(excelVo.getFirstFolderName())) {
                    if (allNameList.contains(excelVo.getSecondFolderName())) {
                        errorSb.append("2\u7ea7\u76ee\u5f55\u5df2\u5b58\u5728:").append(excelVo.getSecondFolderName()).append(",");
                    }
                    if (allNameList.contains(excelVo.getThirdFolderName())) {
                        errorSb.append("3\u7ea7\u76ee\u5f55\u5df2\u5b58\u5728:").append(excelVo.getThirdFolderName()).append(",");
                    }
                    if (StringUtils.isNotBlank((String)errorSb.toString())) {
                        ++failNum;
                        excelVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                        failList.add(excelVo);
                        continue;
                    }
                    this.importNotExistFolderReport(allFolderList, firstOrder, excelVo, (Map)reportOrderMap);
                } else {
                    Map allNameMap = allFolderList.stream().collect(Collectors.toMap(Folder::getName, Function.identity(), (a, b) -> a));
                    Folder folder = (Folder)allNameMap.get(excelVo.getFirstFolderName());
                    if (!FolderLevelEnum.FIRST.getValue().equals(folder.getLevel())) {
                        errorSb.append("1\u7ea7\u76ee\u5f55\u5df2\u5b58\u5728:").append(excelVo.getFirstFolderName()).append(",");
                    }
                    if (!allNameList.contains(excelVo.getSecondFolderName()) && allNameList.contains(excelVo.getThirdFolderName())) {
                        errorSb.append("3\u7ea7\u76ee\u5f55\u5df2\u5b58\u5728:").append(excelVo.getThirdFolderName()).append(",");
                    }
                    if (StringUtils.isNotBlank((String)errorSb.toString())) {
                        ++failNum;
                        excelVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                        failList.add(excelVo);
                        continue;
                    }
                    if (StringUtils.isNotBlank((String)excelVo.getSecondFolderName())) {
                        if (!allNameList.contains(excelVo.getSecondFolderName())) {
                            Folder secondFolder = Folder.builder().name(excelVo.getSecondFolderName()).parentFolderId(Long.valueOf(String.valueOf(folder.getId()))).level(FolderLevelEnum.SECOND.getValue()).folderOrder(Integer.valueOf((Integer)childOrderMap.get(folder.getId()) + 1)).objType(FolderTypeEnum.FINE_REPORT.getValue()).build();
                            this.folderService.getBaseMapper().insert((Object)secondFolder);
                            allFolderList.add(secondFolder);
                            childOrderMap.put(folder.getId(), secondFolder.getFolderOrder());
                            Folder thirdFolder = new Folder();
                            if (StringUtils.isNotBlank((String)excelVo.getThirdFolderName())) {
                                thirdFolder = Folder.builder().name(excelVo.getThirdFolderName()).parentFolderId(Long.valueOf(String.valueOf(secondFolder.getId()))).level(FolderLevelEnum.THIRD.getValue()).folderOrder(Integer.valueOf((Integer)childOrderMap.get(secondFolder.getId()) + 1)).objType(FolderTypeEnum.FINE_REPORT.getValue()).build();
                                this.folderService.getBaseMapper().insert((Object)thirdFolder);
                                allFolderList.add(thirdFolder);
                                childOrderMap.put(secondFolder.getId(), thirdFolder.getFolderOrder());
                            }
                            this.importReport(excelVo, null, secondFolder.getId(), thirdFolder.getId(), (Map)reportOrderMap);
                        } else {
                            Folder oldSecondFolder = (Folder)allNameMap.get(excelVo.getSecondFolderName());
                            if (!folder.getId().equals(oldSecondFolder.getParentFolderId())) {
                                errorSb.append("2\u7ea7\u76ee\u5f55\u5df2\u5b58\u5728:").append(excelVo.getSecondFolderName()).append(",");
                            }
                            if (StringUtils.isNotBlank((String)errorSb.toString())) {
                                ++failNum;
                                excelVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                                failList.add(excelVo);
                                continue;
                            }
                            Long thirdId = null;
                            if (StringUtils.isNotBlank((String)excelVo.getThirdFolderName())) {
                                Folder lastFolder = (Folder)allNameMap.get(excelVo.getThirdFolderName());
                                if (lastFolder != null && !lastFolder.getParentFolderId().equals(oldSecondFolder.getId())) {
                                    errorSb.append("3\u7ea7\u76ee\u5f55\u5df2\u5b58\u5728:").append(excelVo.getSecondFolderName()).append(",");
                                }
                                if (StringUtils.isNotBlank((String)errorSb.toString())) {
                                    ++failNum;
                                    excelVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                                    failList.add(excelVo);
                                    continue;
                                }
                                if (lastFolder == null) {
                                    Folder thirdFolder = Folder.builder().name(excelVo.getThirdFolderName()).parentFolderId(Long.valueOf(String.valueOf(oldSecondFolder.getId()))).level(FolderLevelEnum.THIRD.getValue()).folderOrder(Integer.valueOf((Integer)childOrderMap.get(oldSecondFolder.getId()) + 1)).objType(FolderTypeEnum.FINE_REPORT.getValue()).build();
                                    this.folderService.getBaseMapper().insert((Object)thirdFolder);
                                    thirdId = thirdFolder.getId();
                                    allFolderList.add(thirdFolder);
                                    childOrderMap.put(oldSecondFolder.getId(), thirdFolder.getFolderOrder());
                                } else {
                                    thirdId = lastFolder.getId();
                                }
                            }
                            this.importReport(excelVo, null, oldSecondFolder.getId(), thirdId, (Map)reportOrderMap);
                        }
                    } else {
                        Folder oldFirstFolder = (Folder)allNameMap.get(excelVo.getFirstFolderName());
                        this.importReport(excelVo, oldFirstFolder.getId(), null, null, (Map)reportOrderMap);
                    }
                }
                nameList.add(excelVo.getName());
                urlList.add(excelVo.getUrl());
                ++successNum;
            }
            ImportRecord importRecord = ImportRecord.builder().fileId(fileId).fileName(fileName).successCount(Integer.valueOf(successNum)).failCount(Integer.valueOf(failNum)).objType(FolderTypeEnum.FINE_REPORT.getValue()).tenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId()).createUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName()).build();
            if (failNum > 0) {
                ShareInfo shareInfo = this.importRecordService.uploadExcel(this.write((List)failList));
                excelResp.setFailFileId(shareInfo.getFileId());
                excelResp.setFailFileName(shareInfo.getFileName());
                excelResp.setFailFileUrl(shareInfo.getUrl());
                importRecord.setFailFileId(shareInfo.getFileId());
                importRecord.setFailFileName(shareInfo.getFileName());
                importRecord.setFailFileUrl(shareInfo.getUrl());
            }
            this.importRecordService.insertImportRecord(importRecord);
            String resultCode = successNum > 0 && failNum == 0 ? "2001" : (successNum > 0 && failNum > 0 ? "2002" : (successNum == 0 && failNum > 0 ? "2003" : "2003"));
            excelResp.setResultCode(resultCode);
            excelResp.setFailCount(Integer.valueOf(failNum));
            excelResp.setSuccessCount(Integer.valueOf(successNum));
            return ResponseEntityWrapper.wrapperOk((Object)excelResp);
        }
        catch (Exception e) {
            log.error("FineReporterController import excel exception", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    private void importNotExistFolderReport(List<Folder> allFolderList, AtomicInteger firstOrder, ImportExcelVo excelVo, Map<String, Integer> reportOrderMap) {
        Folder firstFolder = Folder.builder().name(excelVo.getFirstFolderName()).level(FolderLevelEnum.FIRST.getValue()).folderOrder(Integer.valueOf(firstOrder.incrementAndGet())).objType(FolderTypeEnum.FINE_REPORT.getValue()).build();
        this.folderService.getBaseMapper().insert((Object)firstFolder);
        allFolderList.add(firstFolder);
        Folder secondFolder = new Folder();
        if (StringUtils.isNotBlank((String)excelVo.getSecondFolderName())) {
            secondFolder = Folder.builder().name(excelVo.getSecondFolderName()).parentFolderId(Long.valueOf(String.valueOf(firstFolder.getId()))).level(FolderLevelEnum.SECOND.getValue()).folderOrder(Integer.valueOf(firstFolder.getFolderOrder() * 10 + 1)).objType(FolderTypeEnum.FINE_REPORT.getValue()).build();
            this.folderService.getBaseMapper().insert((Object)secondFolder);
            allFolderList.add(secondFolder);
        }
        Folder thirdFolder = new Folder();
        if (StringUtils.isNotBlank((String)excelVo.getThirdFolderName())) {
            thirdFolder = Folder.builder().name(excelVo.getThirdFolderName()).parentFolderId(Long.valueOf(String.valueOf(secondFolder.getId()))).level(FolderLevelEnum.THIRD.getValue()).folderOrder(Integer.valueOf(secondFolder.getFolderOrder() * 10 + 1)).objType(FolderTypeEnum.FINE_REPORT.getValue()).build();
            this.folderService.getBaseMapper().insert((Object)thirdFolder);
            allFolderList.add(thirdFolder);
        }
        this.importReport(excelVo, firstFolder.getId(), secondFolder.getId(), thirdFolder.getId(), reportOrderMap);
    }

    private void importReport(ImportExcelVo excelVo, Long firstId, Long secondId, Long thirdId, Map<String, Integer> reportOrderMap) {
        Long reportFolderId;
        Long l = thirdId != null ? thirdId : (reportFolderId = secondId != null ? secondId : firstId);
        String folderName = StringUtils.isNotBlank((String)excelVo.getThirdFolderName()) ? excelVo.getThirdFolderName() : (StringUtils.isNotBlank((String)excelVo.getSecondFolderName()) ? excelVo.getSecondFolderName() : excelVo.getFirstFolderName());
        Integer reportOrder = reportOrderMap.get(folderName);
        FineReport fineReport = FineReport.builder().name(excelVo.getName()).url(excelVo.getUrl()).comments(excelVo.getComments()).folderId(reportFolderId).reportOrder(Integer.valueOf(reportOrder != null ? reportOrder + 1 : 1)).build();
        this.fineReportService.addOrModFineReport(fineReport, null, null, null);
        reportOrderMap.put(folderName, fineReport.getReportOrder());
    }

    private StringBuilder validate(ImportExcelVo importExcelVo, List<String> nameList, List<String> urlList) {
        long disCount;
        List<String> folderNameList;
        long count;
        StringBuilder errorSb = new StringBuilder();
        if (nameList.contains(importExcelVo.getName())) {
            errorSb.append("\u62a5\u8868\u540d\u79f0\u5df2\u5b58\u5728").append(",");
        }
        if (urlList.contains(importExcelVo.getUrl())) {
            errorSb.append("\u62a5\u8868\u94fe\u63a5\u5df2\u5b58\u5728").append(",");
        }
        if (StringUtils.isBlank((String)importExcelVo.getName())) {
            errorSb.append("\u62a5\u8868\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a").append(",");
        }
        if (StringUtils.isNotBlank((String)importExcelVo.getName()) && importExcelVo.getName().length() > 50) {
            errorSb.append("\u62a5\u8868\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750").append(",");
        }
        if (StringUtils.isNotBlank((String)importExcelVo.getComments()) && importExcelVo.getComments().length() > 500) {
            errorSb.append("\u62a5\u8868\u5907\u6ce8\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7500").append(",");
        }
        if (StringUtils.isBlank((String)importExcelVo.getUrl())) {
            errorSb.append("\u62a5\u8868\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a").append(",");
        }
        if (StringUtils.isNotBlank((String)importExcelVo.getUrl()) && importExcelVo.getUrl().length() > 500) {
            errorSb.append("\u62a5\u8868\u94fe\u63a5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7500").append(",");
        }
        if (StringUtils.isBlank((String)importExcelVo.getFirstFolderName())) {
            errorSb.append("\u62a5\u88681\u7ea7\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a").append(",");
        }
        if ((count = (folderNameList = Arrays.asList(importExcelVo.getFirstFolderName(), importExcelVo.getSecondFolderName(), importExcelVo.getThirdFolderName())).stream().filter(StringUtils::isNotBlank).count()) != (disCount = folderNameList.stream().filter(StringUtils::isNotBlank).distinct().count())) {
            errorSb.append("\u76ee\u5f55\u4e0d\u80fd\u91cd\u590d").append(",");
        }
        if (StringUtils.isNotBlank((String)importExcelVo.getFirstFolderName()) && importExcelVo.getFirstFolderName().length() > 30) {
            errorSb.append("1\u7ea7\u76ee\u5f55\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730").append(",");
        }
        if (StringUtils.isNotBlank((String)importExcelVo.getSecondFolderName()) && importExcelVo.getSecondFolderName().length() > 30) {
            errorSb.append("2\u7ea7\u76ee\u5f55\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730").append(",");
        }
        if (StringUtils.isNotBlank((String)importExcelVo.getThirdFolderName()) && importExcelVo.getThirdFolderName().length() > 30) {
            errorSb.append("3\u7ea7\u76ee\u5f55\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730").append(",");
        }
        if (StringUtils.isNotBlank((String)importExcelVo.getFirstFolderName()) && StringUtils.isNotBlank((String)importExcelVo.getThirdFolderName()) && StringUtils.isBlank((String)importExcelVo.getSecondFolderName())) {
            errorSb.append("\u5b58\u57281\u7ea7\u76ee\u5f55\u548c3\u7ea7\u76ee\u5f55\u65f6\uff0c2\u7ea7\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a").append(",");
        }
        if (StringUtils.isNotBlank((String)importExcelVo.getReportOrder()) && !importExcelVo.getReportOrder().matches("[1-9]*")) {
            errorSb.append("\u6392\u5e8f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570").append(",");
        }
        if (StringUtils.isNotBlank((String)importExcelVo.getReportOrder()) && importExcelVo.getReportOrder().length() > 4) {
            errorSb.append("\u6392\u5e8f\u4e0d\u80fd\u8d85\u8fc74\u4f4d\u6570").append(",");
        }
        return errorSb;
    }

    public File write(List<ImportExcelVo> list) {
        File file = new File("\u5bfc\u5165\u62a5\u8868\u6a21\u677f_\u5931\u8d25\u65e5\u5fd7.xlsx");
        EasyExcel.write((File)file, ImportExcelVo.class).sheet("\u5e06\u8f6f\u62a5\u8868").doWrite(list);
        return file;
    }

    @GetMapping(value={"/queryOperatorList"})
    public ResponseEntity<BaseResultDTO<List<JSONObject>>> queryOperatorList() {
        try {
            List userIdList = this.importRecordService.queryOperatorList();
            if (CollectionUtils.isEmpty((Collection)userIdList)) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)Lists.newArrayList());
            }
            Map idMap = userIdList.stream().collect(Collectors.toMap(BaseEntity::getCreateUserId, Function.identity(), (a, b) -> a));
            List userList = idMap.values().stream().map(x -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("userId", (Object)x.getCreateUserId());
                jsonObject.put("userName", (Object)x.getCreateUserName());
                return jsonObject;
            }).collect(Collectors.toList());
            return ResponseEntityWrapperUtil.wrapperOk(userList);
        }
        catch (Exception e) {
            log.error("FineReporterController save report url param exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/queryImportRecord"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<ImportRecordResp>>> queryImportRecord(@RequestBody @Valid QueryImportRecordReq queryImportRecordReq) {
        try {
            if (StringUtils.isNotBlank((String)queryImportRecordReq.getStartTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss") || StringUtils.isNotBlank((String)queryImportRecordReq.getEndTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
            }
            PageInfoResp pageInfoResp = this.importRecordService.queryImportRecord(queryImportRecordReq, FolderTypeEnum.FINE_REPORT.getValue());
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("FineReporterController save report url param exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/exportReport"})
    public void exportReport(HttpServletResponse response) {
        try {
            ArrayList excelVoList = Lists.newArrayList();
            List folderList = this.folderService.getBaseMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue())).orderByAsc((Object)"folder_order"));
            List reportList = this.fineReportService.getBaseMapper().selectList((Wrapper)Wrappers.emptyWrapper());
            List fineReportVoList = this.fineReportService.buildFineReportVoList(folderList, reportList);
            if (CollectionUtils.isNotEmpty((Collection)fineReportVoList)) {
                Map<Long, String> folderIdMap = folderList.stream().collect(Collectors.toMap(Folder::getId, Folder::getName));
                fineReportVoList.forEach(x -> {
                    ExportExcelVo exportExcelVo = (ExportExcelVo)this.converter.convert(x, ExportExcelVo.class);
                    StringBuilder authRel = new StringBuilder();
                    if (CollectionUtils.isNotEmpty((Collection)x.getOrg())) {
                        List orgNameList = x.getOrg().stream().map(BizObjAuthRelVo::getAuthName).collect(Collectors.toList());
                        authRel.append("\u7ec4\u7ec7:").append(Joiner.on((String)",").join(orgNameList)).append("\n");
                    }
                    if (CollectionUtils.isNotEmpty((Collection)x.getRole())) {
                        List roleNameList = x.getRole().stream().map(BizObjAuthRelVo::getAuthName).collect(Collectors.toList());
                        authRel.append("\u89d2\u8272:").append(Joiner.on((String)",").join(roleNameList)).append("\n");
                    }
                    if (CollectionUtils.isNotEmpty((Collection)x.getUser())) {
                        List userNameList = x.getUser().stream().map(BizObjAuthRelVo::getAuthName).collect(Collectors.toList());
                        authRel.append("\u7528\u6237:").append(Joiner.on((String)",").join(userNameList)).append("\n");
                    }
                    exportExcelVo.setAuthRel(authRel.toString());
                    List folderLevelList = this.folderService.qryCurrentAndParentFolderList(FolderTypeEnum.FINE_REPORT.getValue().intValue(), x.getFolderId().longValue());
                    Map<Integer, Long> levelMap = folderLevelList.stream().filter(y -> y.getFolderId() != null).collect(Collectors.toMap(FolderLevelVo::getLevel, FolderLevelVo::getFolderId));
                    exportExcelVo.setThirdFolderName((String)folderIdMap.get(levelMap.get(FolderLevelEnum.THIRD.getValue())));
                    exportExcelVo.setSecondFolderName((String)folderIdMap.get(levelMap.get(FolderLevelEnum.SECOND.getValue())));
                    exportExcelVo.setFirstFolderName((String)folderIdMap.get(levelMap.get(FolderLevelEnum.FIRST.getValue())));
                    excelVoList.add(exportExcelVo);
                });
            }
            String filename = "\u5e06\u8f6f\u5bfc\u51fa\u62a5\u8868_" + LocalDate.now().toString().replace("-", "") + ".xlsx";
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename=" + new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), ExportExcelVo.class).sheet("\u5bfc\u51fa\u7ed3\u679c").registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).doWrite((Collection)excelVoList);
        }
        catch (Exception e) {
            log.error("FineReporterController export report excel exception", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

