/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.portal.JobSyncReq;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.bench.ThirdJobConfig;
import com.digiwin.athena.semc.service.bench.SyncJobInfoService;
import com.digiwin.athena.semc.service.bench.ThirdJobConfigService;
import com.digiwin.athena.semc.util.AESUtils;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/dataSync/"})
public class JobSyncController {
    private static final Logger logger = LoggerFactory.getLogger(JobSyncController.class);
    @Resource
    private SyncJobInfoService syncJobInfoService;
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    ThirdJobConfigService thirdJobConfigService;

    @Operation(summary="\u4f5c\u4e1a\u540c\u6b65\u63a5\u6536")
    @PostMapping(value={"/jobSync"})
    public ResponseEntity<?> jobSync(@RequestBody JobSyncReq req) {
        logger.info("jobSync param:{}", (Object)JSON.toJSONString((Object)req));
        String bodyJsonStr = req.getBodyJsonStr();
        if (StringUtils.isEmpty((String)bodyJsonStr)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing bodyJsonStr parameter");
        }
        try {
            String aesDecryptResult = AESUtils.aesDecrypt((String)bodyJsonStr, (String)"Wr3t3568aXaH91T30000fMK3ZpOyv4");
            req = (JobSyncReq)JSON.parseObject((String)aesDecryptResult, JobSyncReq.class);
        }
        catch (Exception e) {
            logger.error("jobSync parseObject error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u5165\u53c2\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u662f\u5426\u6b63\u786e");
        }
        try {
            if (null == req) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u5165\u53c2\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u662f\u5426\u6b63\u786e");
            }
            if (StringUtils.isEmpty((String)req.getAppId())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing appid parameter");
            }
            if (CollectionUtils.isEmpty((Collection)req.getJobList())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u4f5c\u4e1a\u4e3a\u7a7a");
            }
            ThirdJobConfig thirdJobConfig = this.thirdJobConfigService.getJobConfigBy("", req.getAppId());
            if (null == thirdJobConfig) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u5f53\u524d\u5e94\u7528\u4e0d\u5728\u914d\u7f6e\u4e2d\uff0c\u65e0\u6743\u63a8\u9001\u4f5c\u4e1a");
            }
            if (Constants.VALID_STATUS_UNUSABLE.equals(thirdJobConfig.getValidStatus())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u5f53\u524d\u5e94\u7528\u672a\u542f\u7528\uff0c\u65e0\u6743\u63a8\u9001\u4f5c\u4e1a");
            }
            boolean accountFlag = req.getJobList().stream().anyMatch(x -> StringUtils.isNotBlank((String)x.getAccountId()));
            if (accountFlag) {
                boolean flag = req.getJobList().stream().anyMatch(x -> StringUtils.isBlank((String)x.getAccountId()));
                if (flag) {
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing accountId parameter");
                }
                ArrayList jobCodeList = Lists.newArrayList();
                for (SyncJobInfo syncJobInfo : req.getJobList()) {
                    String jobCode = syncJobInfo.getAccountId() + "-" + syncJobInfo.getJobCode();
                    if (jobCodeList.contains(jobCode)) {
                        return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"exist repeated accountId and jobCode parameter");
                    }
                    syncJobInfo.setJobCode(jobCode);
                    jobCodeList.add(jobCode);
                }
            }
            this.syncJobInfoService.jobSyncSave(req);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            logger.error("jobSync exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "\u4f5c\u4e1a\u540c\u6b65\u5f02\u5e38");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

