/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.portal.KnowledgeApplicationEnableReq;
import com.digiwin.athena.semc.dto.portal.KnowledgeApplicationListReq;
import com.digiwin.athena.semc.dto.portal.KnowledgeApplicationNewDataReq;
import com.digiwin.athena.semc.dto.portal.KnowledgeApplicationNewDataResp;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.portal.KnowledgeApplicationRef;
import com.digiwin.athena.semc.proxy.ania.service.AniaService;
import com.digiwin.athena.semc.proxy.ania.service.model.KnowledgeAssistantDTO;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.portal.IknowledgeApplicationService;
import com.digiwin.athena.semc.util.DateUtils;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/api/knowledge/application"})
public class KnowledgeApplicationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KnowledgeApplicationController.class);
    private static final Logger logger = LoggerFactory.getLogger(KnowledgeApplicationController.class);
    @Autowired
    private IknowledgeApplicationService knowledgeApplicationService;
    @Autowired
    private AppLinkService appLinkService;
    @Autowired
    private AniaService aniaService;

    @Operation(summary="\u67e5\u8be2\u77e5\u8bc6\u5e93\u5e94\u7528\u5173\u7cfb\u5217\u8868")
    @PostMapping(value={"/list"})
    public ResultPageBean list(@RequestBody @Valid KnowledgeApplicationListReq knowledgeApplicationListReq) throws Exception {
        try {
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            knowledgeApplicationListReq.setTenantId(tenantId);
            return ResultPageBean.success((ResponseBody)this.knowledgeApplicationService.getKnowledgeApplicationList(knowledgeApplicationListReq));
        }
        catch (Exception e) {
            logger.error("query list error. knowledgeApplicationListReq:{}", (Object)knowledgeApplicationListReq, (Object)e);
            throw new Exception("\u67e5\u8be2\u77e5\u8bc6\u5e93\u5e94\u7528\u5173\u7cfb\u5217\u8868");
        }
    }

    @Operation(summary="\u65b0\u589e\u77e5\u8bc6\u5e93\u5e94\u7528\u5173\u7cfb")
    @PostMapping(value={"/batchInsert"})
    public ResultBean batchInsert(@RequestBody List<KnowledgeApplicationNewDataReq> reqList) throws Exception {
        try {
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            if (CollectionUtils.isNotEmpty(reqList) && reqList.size() > 20) {
                throw new Exception("\u6279\u91cf\u6570\u636e\u5927\u4e8e20");
            }
            KnowledgeApplicationNewDataResp resp = new KnowledgeApplicationNewDataResp();
            ArrayList<String> repeatApplicationIdList = new ArrayList<String>();
            ArrayList<String> repeatKnowledgeIdList = new ArrayList<String>();
            resp.setRepeatKnowledgeIdList(repeatKnowledgeIdList);
            resp.setRepeatApplicationIdList(repeatApplicationIdList);
            QueryWrapper param = new QueryWrapper();
            param.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            param.eq((Object)"del_flag", (Object)0);
            List knowledgeApplicationRefs = this.knowledgeApplicationService.getBaseMapper().selectList((Wrapper)param);
            if (CollectionUtils.isNotEmpty((Collection)knowledgeApplicationRefs)) {
                List applicationList = knowledgeApplicationRefs.stream().map(d -> "" + d.getApplicationType() + "@@@" + d.getApplicationId()).collect(Collectors.toList());
                List knowledgeList = knowledgeApplicationRefs.stream().map(KnowledgeApplicationRef::getKnowledgeId).collect(Collectors.toList());
                for (KnowledgeApplicationNewDataReq knowledgeApplicationNewDataReq : reqList) {
                    String appIdType = "" + knowledgeApplicationNewDataReq.getApplicationType() + "@@@" + knowledgeApplicationNewDataReq.getApplicationId();
                    if (applicationList.contains(appIdType)) {
                        repeatApplicationIdList.add(appIdType);
                    }
                    if (!knowledgeList.contains(knowledgeApplicationNewDataReq.getKnowledgeId())) continue;
                    repeatKnowledgeIdList.add(knowledgeApplicationNewDataReq.getKnowledgeId());
                }
            }
            if (CollectionUtils.isNotEmpty(repeatApplicationIdList) || CollectionUtils.isNotEmpty(repeatKnowledgeIdList)) {
                return ResultBean.success((Object)resp);
            }
            if (CollectionUtils.isNotEmpty(reqList)) {
                for (KnowledgeApplicationNewDataReq knowledgeApplicationNewDataReq : reqList) {
                    knowledgeApplicationNewDataReq.setTenantId(tenantId);
                    knowledgeApplicationNewDataReq.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
                    knowledgeApplicationNewDataReq.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
                }
            }
            this.knowledgeApplicationService.batchInsertRecord(reqList);
            return ResultBean.success((Object)resp);
        }
        catch (Exception e) {
            logger.error("batchInsert error. reqList:{}", reqList, (Object)e);
            throw new Exception("\u67e5\u8be2\u77e5\u8bc6\u5e93\u5e94\u7528\u5173\u7cfb\u5217\u8868");
        }
    }

    @Operation(summary="\u66f4\u65b0\u77e5\u8bc6\u5e93\u5e94\u7528\u5173\u7cfb")
    @PostMapping(value={"/updateRecord"})
    public ResultBean updateRecord(@RequestBody KnowledgeApplicationNewDataReq req) throws Exception {
        try {
            KnowledgeApplicationNewDataResp resp = new KnowledgeApplicationNewDataResp();
            ArrayList<String> repeatApplicationIdList = new ArrayList<String>();
            ArrayList<String> repeatKnowledgeIdList = new ArrayList<String>();
            resp.setRepeatKnowledgeIdList(repeatKnowledgeIdList);
            resp.setRepeatApplicationIdList(repeatApplicationIdList);
            QueryWrapper param = new QueryWrapper();
            param.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            param.eq((Object)"del_flag", (Object)0);
            List knowledgeApplicationRefs = this.knowledgeApplicationService.getBaseMapper().selectList((Wrapper)param);
            KnowledgeApplicationRef nowData = (KnowledgeApplicationRef)this.knowledgeApplicationService.getBaseMapper().selectById((Serializable)req.getId());
            if (CollectionUtils.isNotEmpty((Collection)knowledgeApplicationRefs)) {
                List applicationList = knowledgeApplicationRefs.stream().map(d -> "" + d.getApplicationType() + "@@@" + d.getApplicationId()).collect(Collectors.toList());
                List knowledgeList = knowledgeApplicationRefs.stream().map(KnowledgeApplicationRef::getKnowledgeId).collect(Collectors.toList());
                String appIdType = "" + req.getApplicationType() + "@@@" + req.getApplicationId();
                String nowAppIdType = "" + nowData.getApplicationType() + "@@@" + nowData.getApplicationId();
                if (!Objects.equals(nowAppIdType, appIdType) && applicationList.contains(appIdType)) {
                    repeatApplicationIdList.add(appIdType);
                }
                if (!Objects.equals(nowData.getKnowledgeId(), req.getKnowledgeId()) && knowledgeList.contains(req.getKnowledgeId())) {
                    repeatKnowledgeIdList.add(req.getKnowledgeId());
                }
            }
            if (CollectionUtils.isNotEmpty(repeatApplicationIdList) || CollectionUtils.isNotEmpty(repeatKnowledgeIdList)) {
                return ResultBean.success((Object)resp);
            }
            KnowledgeApplicationRef ref = new KnowledgeApplicationRef();
            ref.setApplicationId(req.getApplicationId());
            ref.setAppPrimaryId(req.getAppPrimaryId());
            ref.setKnowledgeId(req.getKnowledgeId());
            ref.setApplicationSource(req.getApplicationSource());
            ref.setApplicationType(req.getApplicationType());
            ref.setIsEnable(req.getIsEnable());
            ref.setId(req.getId());
            ref.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            ref.setModifyUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
            ref.setModifyTime(DateUtils.getNowTime((String)""));
            this.knowledgeApplicationService.updateById((Object)ref);
            if (!nowData.getIsEnable().equals(req.getIsEnable())) {
                if (Constants.VALID_STATUS_ENABLE.equals(req.getIsEnable())) {
                    log.info("updateRecord | update record authorize user app, param:{}, actionType:{}", (Object)JSONObject.toJSONString(Collections.singletonList(ref)), (Object)Constants.IamAuthorizeTypeEnum.INSERT.getVal());
                    this.knowledgeApplicationService.authorizeUserApp(Collections.singletonList(ref), Constants.IamAuthorizeTypeEnum.INSERT.getVal());
                }
                if (Constants.VALID_STATUS_UNUSABLE.equals(req.getIsEnable())) {
                    log.info("updateRecord | update record authorize user app, param:{}, actionType:{}", (Object)JSONObject.toJSONString(Collections.singletonList(nowData)), (Object)Constants.IamAuthorizeTypeEnum.DELETE.getVal());
                    this.knowledgeApplicationService.authorizeUserApp(Collections.singletonList(nowData), Constants.IamAuthorizeTypeEnum.DELETE.getVal());
                }
            }
            if (nowData.getIsEnable().equals(req.getIsEnable()) && Constants.VALID_STATUS_ENABLE.equals(req.getIsEnable()) && (!(nowData.getApplicationType() + "-" + nowData.getAppPrimaryId()).equals(ref.getApplicationType() + "-" + ref.getAppPrimaryId()) || !nowData.getKnowledgeId().equals(ref.getKnowledgeId()))) {
                log.info("updateRecord | update record authorize user app, param:{}, actionType:{}", (Object)JSONObject.toJSONString(Collections.singletonList(nowData)), (Object)Constants.IamAuthorizeTypeEnum.INSERT.getVal());
                this.knowledgeApplicationService.authorizeUserApp(Collections.singletonList(nowData), Constants.IamAuthorizeTypeEnum.DELETE.getVal());
                log.info("updateRecord | update record authorize user app, param:{}, actionType:{}", (Object)JSONObject.toJSONString(Collections.singletonList(ref)), (Object)Constants.IamAuthorizeTypeEnum.DELETE.getVal());
                this.knowledgeApplicationService.authorizeUserApp(Collections.singletonList(ref), Constants.IamAuthorizeTypeEnum.INSERT.getVal());
            }
            return ResultBean.success((Object)resp);
        }
        catch (Exception e) {
            logger.error("updateRecord error. req:{}", (Object)req, (Object)e);
            throw new Exception("\u66f4\u65b0\u77e5\u8bc6\u5e93\u5e94\u7528\u5173\u7cfb");
        }
    }

    @Operation(summary="\u4fee\u6539\u72b6\u6001")
    @PostMapping(value={"/batchEnable"})
    public ResultBean batchEnable(@RequestBody KnowledgeApplicationEnableReq req) throws Exception {
        try {
            if (CollectionUtils.isEmpty((Collection)req.getIdList()) || Objects.isNull(req.getStatus())) {
                return ResultBean.success(null);
            }
            ArrayList<KnowledgeApplicationRef> result = new ArrayList<KnowledgeApplicationRef>();
            for (Long aLong : req.getIdList()) {
                KnowledgeApplicationRef ref = new KnowledgeApplicationRef();
                ref.setIsEnable(req.getStatus());
                ref.setId(aLong);
                ref.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
                ref.setModifyUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                ref.setModifyTime(DateUtils.getNowTime((String)""));
                result.add(ref);
            }
            this.knowledgeApplicationService.updateBatchById(result);
            QueryWrapper param = new QueryWrapper();
            param.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            param.in((Object)"id", (Collection)req.getIdList());
            List knowledgeApplicationRefs = this.knowledgeApplicationService.getBaseMapper().selectList((Wrapper)param);
            Integer actionType = Constants.VALID_STATUS_ENABLE.equals(req.getStatus()) ? Constants.IamAuthorizeTypeEnum.INSERT.getVal() : Constants.IamAuthorizeTypeEnum.DELETE.getVal();
            log.info("batchEnable | batch enable authorize user app, param:{}, actionType:{}", (Object)JSONObject.toJSONString((Object)knowledgeApplicationRefs), (Object)actionType);
            this.knowledgeApplicationService.authorizeUserApp(knowledgeApplicationRefs, actionType);
            return ResultBean.success(null);
        }
        catch (Exception e) {
            throw new Exception("\u66f4\u65b0\u77e5\u8bc6\u5e93\u5e94\u7528\u5173\u7cfb");
        }
    }

    @Operation(summary="\u5220\u9664\u77e5\u8bc6\u5e93\u5e94\u7528\u5173\u7cfb")
    @PostMapping(value={"/delete"})
    public ResultBean delete(@RequestBody KnowledgeApplicationEnableReq req) throws Exception {
        try {
            if (CollectionUtils.isEmpty((Collection)req.getIdList())) {
                return ResultBean.success(null);
            }
            ArrayList<KnowledgeApplicationRef> list = new ArrayList<KnowledgeApplicationRef>();
            for (Long aLong : req.getIdList()) {
                KnowledgeApplicationRef ref = new KnowledgeApplicationRef();
                ref.setId(aLong);
                ref.setDelFlag(Integer.valueOf(1));
                ref.setDelTime(LocalDateTime.now());
                ref.setDelUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                list.add(ref);
            }
            this.knowledgeApplicationService.updateBatchById(list);
            QueryWrapper param = new QueryWrapper();
            param.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            param.in((Object)"id", (Collection)req.getIdList());
            List knowledgeApplicationRefs = this.knowledgeApplicationService.getBaseMapper().selectList((Wrapper)param);
            List enableList = knowledgeApplicationRefs.stream().filter(x -> Constants.VALID_STATUS_ENABLE.equals(x.getIsEnable())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(enableList)) {
                log.info("delete | delete record authorize user app, param:{}, actionType:{}", (Object)JSONObject.toJSONString(enableList), (Object)Constants.IamAuthorizeTypeEnum.DELETE.getVal());
                this.knowledgeApplicationService.authorizeUserApp(enableList, Constants.IamAuthorizeTypeEnum.DELETE.getVal());
            }
            return ResultBean.success(null);
        }
        catch (Exception e) {
            logger.error("updateRecord error. req:{}", (Object)req, (Object)e);
            throw new Exception("\u66f4\u65b0\u77e5\u8bc6\u5e93\u5e94\u7528\u5173\u7cfb");
        }
    }

    @Operation(summary="\u5e94\u7528\u4e0b\u62c9\u5217\u8868")
    @PostMapping(value={"/applicationList"})
    public ResultBean applicationList() throws Exception {
        try {
            ArrayList<JSONObject> result = new ArrayList<JSONObject>();
            AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
            List appLinkListDTO = this.appLinkService.queryManageListSync(user);
            if (CollectionUtils.isEmpty((Collection)appLinkListDTO)) {
                ResultBean resultBean = new ResultBean();
                resultBean.setResponse(result);
                return resultBean;
            }
            QueryWrapper param = new QueryWrapper();
            param.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            param.eq((Object)"del_flag", (Object)0);
            List knowledgeApplicationRefs = this.knowledgeApplicationService.getBaseMapper().selectList((Wrapper)param);
            List kList = knowledgeApplicationRefs.stream().map(d -> "" + d.getApplicationType() + "@@@" + d.getApplicationId()).collect(Collectors.toList());
            appLinkListDTO = this.filterRepeatApp(appLinkListDTO, kList);
            if (CollectionUtils.isNotEmpty((Collection)appLinkListDTO)) {
                for (AppLinkDTO appLinkDTO : appLinkListDTO) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("applicationId", (Object)appLinkDTO.getCode());
                    jsonObject.put("appPrimaryId", (Object)appLinkDTO.getPrimaryId());
                    jsonObject.put("applicationName", (Object)appLinkDTO.getName());
                    jsonObject.put("applicationSource", (Object)appLinkDTO.getDataSource());
                    jsonObject.put("applicationType", (Object)appLinkDTO.getType());
                    jsonObject.put("applicationDesc", (Object)(appLinkDTO.getCode() + " " + appLinkDTO.getName()));
                    result.add(jsonObject);
                }
            }
            ResultBean resultBean = new ResultBean();
            resultBean.setResponse(result);
            return resultBean;
        }
        catch (Exception e) {
            throw new Exception("\u5e94\u7528\u4e0b\u62c9\u5217\u8868");
        }
    }

    @Operation(summary="\u77e5\u8bc6\u5e93\u4e0b\u62c9\u5217\u8868")
    @PostMapping(value={"/knowledgeList"})
    public ResultBean knowledgeList() throws Exception {
        try {
            ArrayList<JSONObject> result = new ArrayList<JSONObject>();
            List ks = this.aniaService.getKnowledgeAssistants(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            if (CollectionUtils.isEmpty((Collection)ks)) {
                ResultBean resultBean = new ResultBean();
                resultBean.setResponse(result);
                return resultBean;
            }
            QueryWrapper param = new QueryWrapper();
            param.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            param.eq((Object)"del_flag", (Object)0);
            List knowledgeApplicationRefs = this.knowledgeApplicationService.getBaseMapper().selectList((Wrapper)param);
            List kList = knowledgeApplicationRefs.stream().map(KnowledgeApplicationRef::getKnowledgeId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)ks)) {
                for (KnowledgeAssistantDTO knowledgeAssistantDTO : ks) {
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{knowledgeAssistantDTO.getAssistantCode()}) || kList.contains(knowledgeAssistantDTO.getAssistantCode())) continue;
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("knowledgeId", (Object)knowledgeAssistantDTO.getAssistantCode());
                    jsonObject.put("knowledgeName", (Object)knowledgeAssistantDTO.getName());
                    jsonObject.put("knowledgeDesc", (Object)(knowledgeAssistantDTO.getAssistantCode() + " " + knowledgeAssistantDTO.getName()));
                    result.add(jsonObject);
                }
            }
            ResultBean resultBean = new ResultBean();
            resultBean.setResponse(result);
            return resultBean;
        }
        catch (Exception e) {
            throw new Exception("\u77e5\u8bc6\u5e93\u4e0b\u62c9\u5217\u8868");
        }
    }

    private List<AppLinkDTO> filterRepeatApp(List<AppLinkDTO> appLinkListDT, List<String> kList) {
        ArrayList<AppLinkDTO> appLinkDTOList = new ArrayList<AppLinkDTO>();
        List matchedLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType())).collect(Collectors.toList());
        Map preListMap = matchedLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getAppId, Function.identity(), (a, b) -> a));
        List iamLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())).collect(Collectors.toList());
        Map iamListMap = iamLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity(), (a, b) -> a));
        for (AppLinkDTO appLink : appLinkListDT) {
            AppLinkDTO iamData = (AppLinkDTO)iamListMap.get(appLink.getAppId());
            if (appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != iamData) continue;
            AppLinkDTO preData = (AppLinkDTO)preListMap.get(appLink.getPrimaryId());
            if (!appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != preData) {
                appLink.setName(preData.getName());
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appLink.getCode()}) || kList.contains("" + appLink.getType() + "@@@" + appLink.getCode())) continue;
            appLinkDTOList.add(appLink);
        }
        return appLinkDTOList;
    }
}

