/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.enums.IfNotIntegerEnum;
import com.digiwin.athena.semc.entity.portal.News;
import com.digiwin.athena.semc.entity.portal.Notice;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.service.portal.NewsService;
import com.digiwin.athena.semc.service.portal.NoticeService;
import com.digiwin.athena.semc.service.portal.TodoListService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.google.common.collect.Lists;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/label/common"})
public class LabelCommonController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelCommonController.class);
    private static final String LABEL = "label";
    private static final String ID = "id";
    private static final String IS_READ = "is_read";
    private static final String NOTICE = "notice";
    private static final String TODO = "todo";
    private static final String NEWS = "news";
    @Resource
    private TodoListService todoListService;
    @Resource
    private NoticeService noticeService;
    @Resource
    private NewsService newsService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/read"})
    public ResponseEntity<BaseResultDTO<Boolean>> read(HttpServletRequest request, @NotBlank(message="\u6d88\u606f\u4f53\u4e0d\u80fd\u4e3a\u7a7a") @RequestBody @NotBlank(message="\u6d88\u606f\u4f53\u4e0d\u80fd\u4e3a\u7a7a") JSONObject body) {
        if (Objects.isNull(body.get((Object)LABEL)) || Objects.isNull(body.get((Object)ID))) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
        }
        if (!Lists.newArrayList((Object[])new String[]{NOTICE, TODO, NEWS}).contains(body.get((Object)LABEL)) || !(body.get((Object)ID) instanceof Integer)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
        }
        try {
            boolean success = false;
            if (NOTICE.equals(body.get((Object)LABEL))) {
                Notice notice = new Notice();
                notice.setId(Long.valueOf(Long.parseLong(body.get((Object)ID).toString())));
                notice.setIsRead(IfNotIntegerEnum.YES.getValue());
                success = this.noticeService.updateById((Object)notice);
            } else if (TODO.equals(body.get((Object)LABEL))) {
                TodoList todoList = new TodoList();
                todoList.setId(Long.valueOf(Long.parseLong(body.get((Object)ID).toString())));
                todoList.setIsRead(IfNotIntegerEnum.YES.getValue());
                success = this.todoListService.updateById((Object)todoList);
            } else if (NEWS.equals(body.get((Object)LABEL))) {
                News news = new News();
                news.setId(Long.valueOf(Long.parseLong(body.get((Object)ID).toString())));
                news.setIsRead(IfNotIntegerEnum.YES.getValue());
                success = this.newsService.updateById((Object)news);
            }
            if (!success) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.UPDATE_FAILED, (String)this.messageUtils.getMessage("error.message.common.update-error"));
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("read exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/getUnread"})
    public ResponseEntity<BaseResultDTO<Long>> getUnread(HttpServletRequest request, @NotBlank(message="label\u4e0d\u80fd\u4e3a\u7a7a") @RequestParam @NotBlank(message="label\u4e0d\u80fd\u4e3a\u7a7a") String label) {
        if (!Lists.newArrayList((Object[])new String[]{NOTICE, TODO}).contains(label)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
        }
        try {
            Long unreadCount = 0L;
            if (TODO.equals(label)) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"to_do_user", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                wrapper.eq((Object)IS_READ, (Object)IfNotIntegerEnum.NO.getValue());
                unreadCount = this.todoListService.count((Wrapper)wrapper);
            } else if (NOTICE.equals(label) || NEWS.equals(label)) {
                QueryWrapper noticeQueryWrapper = new QueryWrapper();
                noticeQueryWrapper.eq((Object)"notice_user", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                noticeQueryWrapper.eq((Object)IS_READ, (Object)IfNotIntegerEnum.NO.getValue());
                QueryWrapper newsWrapper = new QueryWrapper();
                newsWrapper.eq((Object)"news_user", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                newsWrapper.eq((Object)IS_READ, (Object)IfNotIntegerEnum.NO.getValue());
                unreadCount = this.noticeService.count((Wrapper)noticeQueryWrapper) + this.newsService.count((Wrapper)newsWrapper);
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)unreadCount);
        }
        catch (Exception e) {
            log.error("updateBrowseTime exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

