/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.service.menu.AuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.SecurityLogUtil;
import com.digiwin.athena.semc.vo.common.AuthSystemLabelReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemReq;
import com.digiwin.athena.semc.vo.common.UserSystemLabelVo;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant/semc/system/"})
public class LabelSystemAuthController {
    private static final Logger logger = LoggerFactory.getLogger(LabelSystemAuthController.class);
    @Autowired
    LabelSystemAuthService labelSystemAuthService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private AuthService authService;

    @PostMapping(value={"/pageListAuthSystem"})
    public ResultPageBean pageListAuthSystem(@RequestBody AuthSystemLabelReq req) {
        ResultPageBean resultPageBean;
        try {
            resultPageBean = this.labelSystemAuthService.pageListAuthSystem(req);
        }
        catch (Exception e) {
            logger.error("pageListAuthSystem Error", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/tenant/semc/system/pageListAuthSystem");
            resultPageBean = ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.LABEL_SYSTEM_CUSTOM, error));
        }
        return resultPageBean;
    }

    @Operation(summary="\u4fdd\u5b58\u7ec4\u4ef6\u6743\u9650")
    @PostMapping(value={"/saveSystemAuth"})
    public ResponseEntity<BaseResultDTO<Integer>> saveSystemAuth(@RequestBody @Valid BizObjAuthRelBatchSystemReq req, HttpServletRequest request) {
        try {
            if (!this.authService.hasAuth("application-configuration")) {
                SecurityLogUtil.writeSecurityLog((HttpServletRequest)request, (String)JSON.toJSONString((Object)req));
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.labelSystemAuthService.saveSystemAuth(req));
        }
        catch (Exception e) {
            logger.error("saveSystemAuth exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u5168\u90e8\u5173\u8054/\u89e3\u9664\u7ec4\u4ef6\u6743\u9650")
    @PostMapping(value={"/saveSystemAuthAll"})
    public ResponseEntity<BaseResultDTO<Integer>> saveSystemAuthAll(@RequestBody AuthSystemLabelReq req, HttpServletRequest request) {
        try {
            if (!this.authService.hasAuth("application-configuration")) {
                SecurityLogUtil.writeSecurityLog((HttpServletRequest)request, (String)JSON.toJSONString((Object)req));
            }
            if (null == req.getAuthId()) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"authId is not null");
            }
            if (null == req.getIsRelated()) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"isRelated is not null");
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.labelSystemAuthService.saveSystemAuthAll(req));
        }
        catch (Exception e) {
            logger.error("saveSystemAuthAll exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u67e5\u8be2\u9996\u9875\u7528\u6237\u7ec4\u4ef6")
    @PostMapping(value={"/queryUserLayout"})
    public ResponseEntity<BaseResultDTO<List<UserSystemLabelVo>>> queryUserLayout() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.labelSystemAuthService.queryUserLayout());
        }
        catch (Exception e) {
            logger.error("queryUserLayout exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

