/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.portal.QueryGroupReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.service.portal.LabelSystemBusinessTodoService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.GroupRuleResp;
import com.digiwin.athena.semc.vo.portal.GroupRuleValueResp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/business/todo"})
public class LabelSystemBusinessToDoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemBusinessToDoController.class);
    @Resource
    private LabelSystemBusinessTodoService labelSystemBusinessTodoService;
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    private LabelSystemDataService labelSystemDataService;

    @PostMapping(value={"/queryAgileGroupList"})
    public ResponseEntity<BaseResultDTO<List<GroupRuleResp>>> queryAgileGroupList(@RequestBody QueryGroupReq queryGroupReq) {
        try {
            List groupRuleRespList = this.labelSystemBusinessTodoService.queryAgileGroupList(queryGroupReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)groupRuleRespList);
        }
        catch (Exception e) {
            log.error("query agile group list error. param:{}", (Object)queryGroupReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/business/todo/queryAgileGroupList, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryThirdGroupList"})
    public ResponseEntity<BaseResultDTO<List<GroupRuleResp>>> queryThirdGroupList(@RequestBody @Valid QueryGroupReq queryGroupReq) {
        try {
            if (ObjectUtil.isNull((Object)queryGroupReq.getDataModel())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"dataModel is missing");
            }
            if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(queryGroupReq.getDataModel())) {
                if (StringUtils.isBlank((String)queryGroupReq.getMiddleSystemName()) || StringUtils.isBlank((String)queryGroupReq.getMiddleSystemUid())) {
                    String error = this.messageUtils.getMessage("error.message.middle.system.param.missing");
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)error);
                }
            } else if (StringUtils.isBlank((String)queryGroupReq.getRestUrl())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"restUrl is missing");
            }
            List groupRuleRespList = this.labelSystemBusinessTodoService.queryThirdGroupList(queryGroupReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)groupRuleRespList);
        }
        catch (Exception e) {
            log.error("query third group list error, param:{}", (Object)queryGroupReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/business/todo/queryThirdGroupList, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryBusinessTodoValue"})
    public ResponseEntity<BaseResultDTO<GroupRuleValueResp>> queryBusinessTodoValue(@RequestBody QueryGroupReq queryGroupReq) {
        try {
            if (ObjectUtil.isNull((Object)queryGroupReq.getSystemId())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"param is missing");
            }
            List systemDataList = this.labelSystemDataService.querySystemDataBySystemId(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(), Collections.singletonList(queryGroupReq.getSystemId()), Utils.getTenantId());
            if (CollectionUtils.isEmpty((Collection)systemDataList)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("the data source is not exist, systemId:" + queryGroupReq.getSystemId()));
            }
            LabelSystemData systemData = (LabelSystemData)systemDataList.get(0);
            log.info("queryBusinessTodoValue | query label system data result:{}", (Object)systemData);
            if (!ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(systemData.getDataType())) {
                if (StringUtils.isBlank((String)systemData.getCountCode()) && StringUtils.isBlank((String)systemData.getCountContentCode())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"countCode and countContentCode is missing");
                }
                if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(systemData.getDataModel())) {
                    if (StringUtils.isBlank((String)systemData.getMiddleSystemName()) || StringUtils.isBlank((String)systemData.getMiddleSystemUid())) {
                        String error = this.messageUtils.getMessage("error.message.middle.system.param.missing");
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)error);
                    }
                } else if (StringUtils.isBlank((String)systemData.getRestUrl())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"systemData restUrl is missing");
                }
                GroupRuleValueResp groupRuleValueResp = this.labelSystemBusinessTodoService.queryThirdGroupValueList(systemData);
                return ResponseEntityWrapperUtil.wrapperOk((Object)groupRuleValueResp);
            }
            List groupRuleRespList = this.labelSystemBusinessTodoService.queryAgileGroupValueList(queryGroupReq.getClientId(), systemData);
            return ResponseEntityWrapperUtil.wrapperOk((Object)(CollectionUtils.isEmpty((Collection)groupRuleRespList) ? new GroupRuleValueResp() : (GroupRuleValueResp)groupRuleRespList.get(0)));
        }
        catch (Exception e) {
            log.error("query business todo value error. param:{}", (Object)queryGroupReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/business/todo/queryBusinessTodoValue, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

