/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.fineReport.QueryFineReportUrlReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCountDataDTO;
import com.digiwin.athena.semc.dto.portal.QueryCountLinkReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.portal.LabelSystemClickService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/layout/component"})
public class LabelSystemClickController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemClickController.class);
    @Resource
    private LabelSystemDataService labelSystemDataService;
    @Resource
    private LabelSystemClickService labelSystemClickService;
    @Resource
    private LabelSystemPreService labelSystemPreService;
    @Autowired
    private AppLinkService appLinkService;
    @Resource
    private MessageUtils messageUtils;

    @GetMapping(value={"/custom/click"})
    public ResponseEntity<BaseResultDTO<AppLinkDTO>> queryCustomAppLink(@RequestParam Long systemId) {
        try {
            AppLinkDTO appLinkDTO = this.labelSystemClickService.queryCustomJumpLink(systemId);
            if (null != appLinkDTO && !appLinkDTO.getIsHavePerm().booleanValue()) {
                String error = this.messageUtils.getMessage("error.message.mobile.work.not.auth");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)error);
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkDTO);
        }
        catch (Exception e) {
            log.error("query custom application link error. systemId:{}", (Object)systemId, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/layout/component/custom/click");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryCountLink"})
    public ResponseEntity<?> queryCountLink(@RequestBody @Valid QueryCountLinkReq queryCountLinkReq) {
        AppLinkDTO appLinkDTO;
        List systemDataList = this.labelSystemDataService.querySystemDataBySystemId(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(), Collections.singletonList(queryCountLinkReq.getSystemId()), Utils.getTenantId());
        if (CollectionUtils.isEmpty((Collection)systemDataList)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("the data source is not exist, param:" + queryCountLinkReq));
        }
        LabelSystemData systemData = (LabelSystemData)systemDataList.get(0);
        String countContentInfo = systemData.getCountContentCode();
        if (StringUtils.isBlank((CharSequence)countContentInfo)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("the count content info is null, param:" + queryCountLinkReq));
        }
        List countDataDTOList = JSON.parseArray((String)countContentInfo, LabelSystemCountDataDTO.class);
        LabelSystemCountDataDTO labelSystemCountDataDTO = countDataDTOList.stream().filter(x -> queryCountLinkReq.getContentCode().equals(x.getContentCode())).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)labelSystemCountDataDTO)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("the count content info is null, contnetCode:" + queryCountLinkReq.getContentCode()));
        }
        LabelSystemCountDataDTO.JobInfo jobInfo = labelSystemCountDataDTO.getJobInfo();
        if (ObjectUtils.isNotEmpty((Object)jobInfo) && ObjectUtils.isNotEmpty((Object)jobInfo.getAppPrimaryId()) && ObjectUtils.isNotEmpty((Object)jobInfo.getDataType()) && (Constants.IsNeedJobEnum.NEED_CUSTOM_JOB.getValue().equals(jobInfo.getIsJob()) && StringUtils.isNotBlank((CharSequence)jobInfo.getCallBackUrl()) || Constants.IsNeedJobEnum.NOT_NEED_JOB.getValue().equals(jobInfo.getIsJob()) && StringUtils.isNotBlank((CharSequence)jobInfo.getWorkCode()))) {
            appLinkDTO = this.labelSystemClickService.queryCountLink(labelSystemCountDataDTO);
        } else {
            appLinkDTO = this.appLinkService.queryApplicationByDataType(systemData.getDataType(), systemData.getAppCode(), AppAuthContextHolder.getContext().getAuthoredUser());
            if (ObjectUtils.isEmpty((Object)appLinkDTO)) {
                return ResponseEntityWrapper.wrapperOk((Object)appLinkDTO);
            }
            String jumpUrl = this.appLinkService.parseJumpUrl(labelSystemCountDataDTO.getContentLink(), appLinkDTO);
            appLinkDTO.setCloudwebsite(jumpUrl);
        }
        return ResponseEntityWrapper.wrapperOk((Object)appLinkDTO);
    }

    @GetMapping(value={"/queryStatus"})
    public ResponseEntity<BaseResultDTO<Integer>> queryStatus(@RequestParam Integer dataType) {
        try {
            LabelSystemPre labelSystemPre;
            if (null != dataType && dataType.equals(Constants.DataTypeEnum.TYPE_TODO.getVal())) {
                dataType = Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal();
            }
            if ((labelSystemPre = this.labelSystemPreService.getPreSystemID(dataType)) == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the component is not exist");
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)labelSystemPre.getValidStatus());
        }
        catch (Exception e) {
            log.error("query status error. dataType:{}", (Object)dataType, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/layout/component/queryStatus");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryFineReportUrl"})
    public ResponseEntity<?> queryFineReportUrl(@RequestBody @Valid QueryFineReportUrlReq queryFineReportUrlReq) {
        JSONObject resp = this.labelSystemClickService.queryFineReportUrl(queryFineReportUrlReq);
        return ResponseEntityWrapperUtil.wrapperOk((Object)resp);
    }
}

