/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.service.portal.LabelSystemCountService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/count/component"})
@CrossOrigin(value={"*"})
public class LabelSystemCountController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemCountController.class);
    @Resource
    LabelSystemCountService labelSystemCountService;
    @Autowired
    private LabelSystemDataService labelSystemDataService;

    @PostMapping(value={"/queryCountConfigList"})
    public ResponseEntity<BaseResultDTO<JSONArray>> queryCountConfigList(@RequestBody LabelSystemData labelSystemData) {
        if (!Constants.COUNT_COMPOENT_TYPE.equals(labelSystemData.getDataCategory())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("dataCategory is illegal:" + labelSystemData.getDataCategory()));
        }
        if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemData.getDataModel()) && (StringUtils.isBlank((CharSequence)labelSystemData.getMiddleSystemUid()) || StringUtils.isBlank((CharSequence)labelSystemData.getMiddleSystemName()))) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"param is missing");
        }
        if (Constants.DataModelEnum.MODEL_CLOUD.getVal().equals(labelSystemData.getDataModel()) && StringUtils.isBlank((CharSequence)labelSystemData.getRestUrl())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"param is missing");
        }
        JSONArray jsonArray = this.labelSystemCountService.queryCountConfigData(labelSystemData);
        return ResponseEntityWrapperUtil.wrapperOk((Object)jsonArray);
    }

    @PostMapping(value={"/queryCountMetricList"})
    public ResponseEntity<?> queryCountContentList(@RequestBody Map<String, Object> param) {
        if (MapUtils.isEmpty(param) || ObjectUtils.isEmpty((Object)param.get("id"))) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"param is missing");
        }
        List systemDataList = this.labelSystemDataService.querySystemDataBySystemId(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(), Collections.singletonList(Long.valueOf(param.get("id").toString())), Utils.getTenantId());
        if (CollectionUtils.isEmpty((Collection)systemDataList)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("the data source is not exist, systemId:" + param.get("id")));
        }
        LabelSystemData systemData = (LabelSystemData)systemDataList.get(0);
        log.info("query count metric list | query label system data result:{}", (Object)systemData);
        Map frontList = this.labelSystemCountService.queryCountContentDataByConfig(systemData);
        if (frontList.isEmpty()) {
            return ResponseEntityWrapper.wrapperOk((Object)new JSONArray());
        }
        return ResponseEntityWrapper.wrapperOk((Object)frontList);
    }
}

