/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomDeleteReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomSaveReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.service.bench.JobBenchService;
import com.digiwin.athena.semc.service.menu.AuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.SecurityLogUtil;
import com.digiwin.athena.semc.vo.bench.JobBenchSaveVO;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/custom/component"})
public class LabelSystemCustomController {
    @Resource
    LabelSystemCustomService labelSystemCustomService;
    @Autowired
    JobBenchService jobBenchService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private AuthService authService;

    @Operation(method="pageQuery", description="\u67e5\u8be2\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5217\u8868")
    @PostMapping(value={"/pageQuery"})
    public ResultPageBean pageQuery(@RequestBody @Valid LabelSystemCustomQueryReq labelSystemCustomQueryReq) {
        return this.labelSystemCustomService.pageQuery(labelSystemCustomQueryReq);
    }

    @Operation(method="query", description="\u67e5\u8be2\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u4e0d\u5206\u9875")
    @PostMapping(value={"/query"})
    public ResponseEntity<?> query(@RequestBody Map map) {
        if (Objects.isNull(MapUtils.getInteger((Map)map, (Object)"clientType"))) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)"param clientType is can not null");
        }
        return this.labelSystemCustomService.query(MapUtils.getInteger((Map)map, (Object)"clientType"), MapUtils.getInteger((Map)map, (Object)"isLayout", null));
    }

    @Operation(method="save", description="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u7ec4\u4ef6")
    @PostMapping(value={"/save"})
    public ResponseEntity<?> save(@RequestBody @Valid LabelSystemCustomSaveReq labelSystemCustomSaveReq, HttpServletRequest request) {
        if (!this.authService.hasAuth("custom-component")) {
            SecurityLogUtil.writeSecurityLog((HttpServletRequest)request, (String)JSON.toJSONString((Object)labelSystemCustomSaveReq));
        }
        return this.labelSystemCustomService.save(labelSystemCustomSaveReq);
    }

    @Operation(method="updateState", description="\u66f4\u65b0\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u72b6\u6001")
    @PostMapping(value={"/updateState"})
    public ResponseEntity<?> updateState(@RequestBody @Valid LabelSystemCustomSaveReq labelSystemCustomSaveReq) {
        return this.labelSystemCustomService.updateState(labelSystemCustomSaveReq);
    }

    @Operation(method="delete", description="\u5220\u9664\u81ea\u5b9a\u4e49\u7ec4\u4ef6")
    @PostMapping(value={"/delete"})
    public ResponseEntity<?> delete(@RequestBody LabelSystemCustomDeleteReq labelSystemCustomDeleteReq) {
        if (CollectionUtils.isEmpty((Collection)labelSystemCustomDeleteReq.getIdList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)"id cannot be empty");
        }
        if (Objects.isNull(labelSystemCustomDeleteReq.getClientType())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)"clientType cannot be null");
        }
        JobBenchSaveVO req = new JobBenchSaveVO();
        req.setSystemIdList(labelSystemCustomDeleteReq.getIdList());
        List jobBenchCustomList = this.jobBenchService.selectBySystem(req);
        if (CollectionUtils.isNotEmpty((Collection)jobBenchCustomList)) {
            String error = this.messageUtils.getMessage("error.message.job.system.data.del.error");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return this.labelSystemCustomService.delete(labelSystemCustomDeleteReq.getIdList(), labelSystemCustomDeleteReq.getClientType());
    }

    @Operation(method="queryCustomSystem", description="\u67e5\u8be2\u9884\u8bbe\u7ec4\u4ef6\u548c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5217\u8868")
    @PostMapping(value={"/queryCustomSystem"})
    public ResponseEntity<BaseResultDTO<List<LabelSystemCustom>>> queryCustomSystem(@RequestBody LabelSystemAllVo req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.labelSystemCustomService.queryCustomSystem(req));
    }
}

