/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustomImport;
import com.digiwin.athena.semc.entity.portal.LabelSystemDataImport;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.service.portal.impl.SystemCustomWriteHandler;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.SystemCustomExportVo;
import com.digiwin.athena.semc.vo.portal.SystemCustomImportVo;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/custom/component"})
public class LabelSystemCustomImportController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemCustomImportController.class);
    @Autowired
    private LabelSystemCustomService labelSystemCustomService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/importReport"})
    public ResponseEntity<BaseResultDTO<ImportExcelResp>> importReport(@RequestBody LabelSystemDataImport req) {
        if (StringUtils.isEmpty((String)req.getFileId())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"file code cannot be empty");
        }
        ImportExcelResp excelResp = new ImportExcelResp();
        try {
            List excelVoList = this.labelSystemCustomService.readExcel(req.getFileId());
            if (CollectionUtils.isEmpty((Collection)excelVoList)) {
                String error = this.messageUtils.getMessage("error.message.import.cannot.be.empty");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            excelVoList = this.trimDataList(excelVoList);
            excelResp = this.labelSystemCustomService.importReport(excelVoList);
            return ResponseEntityWrapperUtil.wrapperOk((Object)excelResp);
        }
        catch (Exception e) {
            log.error("LabelSystemCustomImportController import excel exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    public List<SystemCustomImportVo> trimDataList(List<SystemCustomImportVo> excelVoList) {
        for (SystemCustomImportVo excelVo : excelVoList) {
            if (StringUtils.isNotEmpty((String)excelVo.getNameZh())) {
                excelVo.setNameZh(excelVo.getNameZh().trim());
            }
            if (StringUtils.isNotEmpty((String)excelVo.getDataCategory())) {
                excelVo.setDataCategory(excelVo.getDataCategory().trim());
            }
            if (StringUtils.isNotEmpty((String)excelVo.getValidStatus())) {
                excelVo.setValidStatus(excelVo.getValidStatus().trim());
            }
            if (StringUtils.isNotEmpty((String)excelVo.getRemark())) {
                excelVo.setRemark(excelVo.getRemark().trim());
            }
            if (!StringUtils.isNotEmpty((String)excelVo.getDataName())) continue;
            excelVo.setDataName(excelVo.getDataName().trim());
        }
        return excelVoList;
    }

    @PostMapping(value={"/queryImportRecord"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<LabelSystemCustomImport>>> queryImportRecord(@RequestBody @Valid QueryImportRecordReq queryImportRecordReq) {
        try {
            if (StringUtils.isNotBlank((String)queryImportRecordReq.getStartTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss") || StringUtils.isNotBlank((String)queryImportRecordReq.getEndTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
            }
            PageInfoResp pageInfoResp = this.labelSystemCustomService.queryImportRecord(queryImportRecordReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("LabelSystemCustomImportController queryImportRecord exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/exportReport"})
    public void exportReport(HttpServletResponse response) {
        try {
            List excelVoList = this.labelSystemCustomService.exportReport();
            String filename = "\u81ea\u5b9a\u4e49\u7ec4\u4ef6_" + LocalDate.now().toString().replace("-", "") + ".xlsx";
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename=" + new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), SystemCustomExportVo.class).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).sheet("\u81ea\u5b9a\u4e49\u7ec4\u4ef6").relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)new SystemCustomWriteHandler())).doWrite((Collection)excelVoList);
        }
        catch (Exception e) {
            log.error("LabelSystemCustomImportController exportReport exception", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

