/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.erpsso.QueryAppListReq;
import com.digiwin.athena.semc.dto.portal.QueryGroupReq;
import com.digiwin.athena.semc.dto.portal.QueryLabelSystemReq;
import com.digiwin.athena.semc.dto.portal.ValidateLabelReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.bench.SyncJobInfoService;
import com.digiwin.athena.semc.service.menu.AuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemBusinessTodoService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.LabelSystemSourceService;
import com.digiwin.athena.semc.service.portal.TodoAppSortService;
import com.digiwin.athena.semc.service.temp.TemplateSystemDataService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.SecurityLogUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.GroupRuleResp;
import io.github.linpeilie.Converter;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import java.text.Collator;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/label/system/data/"})
public class LabelSystemDataController {
    private static final Logger logger = LoggerFactory.getLogger(LabelSystemDataController.class);
    @Autowired
    LabelSystemDataService labelSystemDataService;
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    private AppLinkService appLinkService;
    @Autowired
    private LabelSystemSourceService labelSystemSourceService;
    @Autowired
    private LabelSystemBusinessTodoService labelSystemBusinessTodoService;
    @Autowired
    private SyncJobInfoService syncJobInfoService;
    @Autowired
    private KmService kmService;
    @Autowired
    private TemplateSystemDataService templateSystemDataService;
    @Autowired
    private AuthService authService;
    @Autowired
    private TodoAppSortService todoAppSortService;
    @Resource
    private Converter converter;
    private static final String FILTER_MESSAGE_TYPE = "message";

    @PostMapping(value={"/queryAppList"})
    public ResponseEntity<BaseResultDTO<List<AppLinkDTO>>> queryAppList(@RequestBody QueryAppListReq queryAppListReq) {
        try {
            List appLinkListDTO = this.queryAppLinkList(queryAppListReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkListDTO);
        }
        catch (Exception e) {
            logger.error("queryAppList exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/label/system/data/queryAppList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    private List<AppLinkDTO> queryAppLinkList(QueryAppListReq queryAppListReq) {
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List appLinkListDTO = this.appLinkService.queryManageList(user);
        appLinkListDTO = this.filterRepeatApp(appLinkListDTO);
        if (queryAppListReq != null && FILTER_MESSAGE_TYPE.equals(queryAppListReq.getFilterType())) {
            appLinkListDTO = appLinkListDTO.stream().filter(x -> !ApplicationTypeEnum.IAM_APPLICATION.getType().equals(x.getDataSource()) && StringUtils.isNotBlank((CharSequence)x.getApplicationAppId())).collect(Collectors.toList());
        }
        return appLinkListDTO;
    }

    @PostMapping(value={"/queryAppListForDataSource"})
    public ResponseEntity<BaseResultDTO<List<AppLinkDTO>>> queryAppListForDataSource(@RequestBody QueryAppListReq queryAppListReq) {
        try {
            List appLinkListDTO = this.queryAppLinkList(queryAppListReq);
            AppLinkDTO appLinkDTO = Utils.initAppInteraction();
            appLinkListDTO.add(appLinkDTO);
            if (null != queryAppListReq.getIsNeedApp() && queryAppListReq.getIsNeedApp() == 1) {
                AppLinkDTO athenaAppLinkDTO = Utils.initAthenaApp();
                appLinkListDTO.add(athenaAppLinkDTO);
            }
            AppLinkDTO fineReportApp = Utils.initFineReportApp();
            appLinkListDTO.add(fineReportApp);
            return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkListDTO);
        }
        catch (Exception e) {
            logger.error("query app list for data source. param:{}", (Object)queryAppListReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/label/system/data/queryAppListForDataSource");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryAppListForCountJob"})
    public ResponseEntity<BaseResultDTO<List<AppLinkDTO>>> queryAppListForDataSource() {
        List appLinkListDTO = this.queryAppLinkList(null);
        return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkListDTO);
    }

    @PostMapping(value={"/queryJobAppList"})
    public ResponseEntity<BaseResultDTO<List<AppLinkDTO>>> queryJobAppList(@RequestBody QueryAppListReq queryAppListReq) {
        try {
            AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
            List appLinkListDTO = this.appLinkService.queryManageList(user);
            appLinkListDTO = this.filterRepeatApp(appLinkListDTO);
            appLinkListDTO = this.filterJobApp(appLinkListDTO);
            Collator comparator = Collator.getInstance(Locale.CHINA);
            Collections.sort(appLinkListDTO, (o1, o2) -> comparator.compare(o1.getName(), o2.getName()));
            return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkListDTO);
        }
        catch (Exception e) {
            logger.error("queryAppList exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/label/system/data/queryAppList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    public List<AppLinkDTO> filterJobApp(List<AppLinkDTO> appLinkListDT) {
        ArrayList<AppLinkDTO> appLinkDTOList = new ArrayList<AppLinkDTO>();
        if (CollectionUtils.isEmpty(appLinkListDT)) {
            return appLinkDTOList;
        }
        List ssoAppIdList = appLinkListDT.stream().map(AppLinkDTO::getApplicationAppId).collect(Collectors.toList());
        List appIdList = this.syncJobInfoService.getJobAppIdList(ssoAppIdList);
        List appJobListDTOList = this.kmService.queryAppJobList();
        Map<Object, Object> appJobListMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)appJobListDTOList)) {
            appJobListMap = appJobListDTOList.stream().collect(Collectors.toMap(AppJobDTO::getAppCode, Function.identity(), (a, b) -> a));
        }
        for (AppLinkDTO appLink : appLinkListDT) {
            AppJobDTO appJobDTO;
            if (!appLink.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType()) && appIdList.contains(appLink.getApplicationAppId())) {
                appLinkDTOList.add(appLink);
            }
            if (!appLink.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType()) || null == appJobListMap || null == appJobListMap.get(appLink.getPrimaryId()) || !CollectionUtils.isNotEmpty((Collection)(appJobDTO = (AppJobDTO)appJobListMap.get(appLink.getPrimaryId())).getData())) continue;
            appLinkDTOList.add(appLink);
        }
        return appLinkDTOList;
    }

    public List<AppLinkDTO> filterRepeatApp(List<AppLinkDTO> appLinkListDT) {
        ArrayList<AppLinkDTO> appLinkDTOList = new ArrayList<AppLinkDTO>();
        List matchedLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType())).collect(Collectors.toList());
        Map preListMap = matchedLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getAppId, Function.identity(), (a, b) -> a));
        List iamLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())).collect(Collectors.toList());
        Map iamListMap = iamLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity(), (a, b) -> a));
        for (AppLinkDTO appLink : appLinkListDT) {
            AppLinkDTO iamData = (AppLinkDTO)iamListMap.get(appLink.getApplicationAppId());
            if (appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != iamData) continue;
            AppLinkDTO preData = (AppLinkDTO)preListMap.get(appLink.getPrimaryId());
            if (!appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != preData) {
                appLink.setName(preData.getName());
            }
            appLinkDTOList.add(appLink);
        }
        return appLinkDTOList;
    }

    @Operation(summary="\u67e5\u8be2\u6570\u636e\u6e90")
    @PostMapping(value={"/queryDataList"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<LabelSystemData>>> queryDataList(@RequestBody QueryLabelSystemReq req) {
        try {
            if (null == req.getPageNum() || null == req.getPageSize()) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing paging parameter");
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.labelSystemDataService.queryDataList(req));
        }
        catch (Exception e) {
            logger.error("queryDataList exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/label/system/data/queryDataList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u542f\u7528\u505c\u7528")
    @PostMapping(value={"/updateValidStatus"})
    public ResponseEntity<?> updateValidStatus(@RequestBody QueryLabelSystemReq req) {
        try {
            if (null == req.getId()) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"id cannot be empty");
            }
            if (null == req.getValidStatus()) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the status cannot be empty");
            }
            return this.labelSystemDataService.updateValidStatus(req);
        }
        catch (Exception e) {
            logger.error("updateValidStatus exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/label/system/data/updateValidStatus");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u6570\u636e\u6e90")
    @PostMapping(value={"/delData"})
    public ResponseEntity<?> delData(@RequestBody QueryLabelSystemReq req) {
        try {
            if (CollectionUtils.isEmpty((Collection)req.getIds())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"id cannot be empty");
            }
            return this.labelSystemDataService.delData(req);
        }
        catch (Exception e) {
            logger.error("delData exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/label/system/data/delData");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u6821\u9a8c\u5206\u7ec4\u662f\u5426\u5b58\u5728")
    @PostMapping(value={"/validateGroupExist"})
    public ResponseEntity<BaseResultDTO<JSONObject>> validateGroupExist(@RequestBody ValidateLabelReq validateLabelReq) {
        try {
            QueryGroupReq queryGroupReq;
            JSONObject jsonObject = new JSONObject();
            if (ObjectUtils.isEmpty((Object)validateLabelReq.getSystemId()) && ObjectUtils.isEmpty((Object)validateLabelReq.getSourceId())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"param is missing");
            }
            LabelSystemData systemData = new LabelSystemData();
            if (validateLabelReq.getSourceType() == 0) {
                if (ObjectUtils.isNotEmpty((Object)validateLabelReq.getSourceId())) {
                    systemData = (LabelSystemData)this.labelSystemDataService.getBaseMapper().selectById((Serializable)validateLabelReq.getSourceId());
                } else if (ObjectUtils.isNotEmpty((Object)validateLabelReq.getSystemId())) {
                    List dataIdList = this.labelSystemSourceService.selectBySystem(validateLabelReq.getSystemId(), Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
                    if (CollectionUtils.isEmpty((Collection)dataIdList)) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("the custom system rel data source is not exist, systemId:" + validateLabelReq.getSystemId()));
                    }
                    List systemDataList = this.labelSystemDataService.queryByIds(dataIdList);
                    if (CollectionUtils.isEmpty((Collection)systemDataList)) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("the data source is not exist, sourceId:" + dataIdList.get(0) + ", systemId:" + validateLabelReq.getSystemId()));
                    }
                    systemData = (LabelSystemData)systemDataList.get(0);
                }
            }
            if (validateLabelReq.getSourceType() == 1) {
                TemplateSystemData systemDataTemp = new TemplateSystemData();
                if (ObjectUtils.isNotEmpty((Object)validateLabelReq.getSourceId())) {
                    systemDataTemp = (TemplateSystemData)this.templateSystemDataService.getBaseMapper().selectById((Serializable)validateLabelReq.getSourceId());
                } else if (ObjectUtils.isNotEmpty((Object)validateLabelReq.getSystemId())) {
                    List dataIdList = this.templateSystemDataService.selectBySystemId(validateLabelReq.getSystemId());
                    if (CollectionUtils.isEmpty((Collection)dataIdList)) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("the custom system rel data source is not exist, systemId:" + validateLabelReq.getSystemId()));
                    }
                    List systemDataTempList = this.templateSystemDataService.queryByIds(dataIdList);
                    if (CollectionUtils.isEmpty((Collection)systemDataTempList)) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("the data source is not exist, sourceId:" + dataIdList.get(0) + ", systemId:" + validateLabelReq.getSystemId()));
                    }
                    systemDataTemp = (TemplateSystemData)systemDataTempList.get(0);
                }
                systemData = (LabelSystemData)this.converter.convert((Object)systemDataTemp, LabelSystemData.class);
            }
            if (null == systemData) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)("system data is not exist. param:" + JSON.toJSONString((Object)validateLabelReq)));
            }
            String countCode = systemData.getCountCode();
            String countContentCode = systemData.getCountContentCode();
            if (!ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(systemData.getDataType())) {
                if (StringUtils.isBlank((CharSequence)systemData.getCountCode()) && StringUtils.isBlank((CharSequence)systemData.getCountContentCode())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"countCode and countContentCode is missing");
                }
                if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(systemData.getDataModel())) {
                    if (StringUtils.isBlank((CharSequence)systemData.getMiddleSystemName()) || StringUtils.isBlank((CharSequence)systemData.getMiddleSystemUid())) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)("systemData is missing, middleSystemName:" + systemData.getMiddleSystemName() + ", middleSystemUid:" + systemData.getMiddleSystemUid()));
                    }
                } else if (StringUtils.isBlank((CharSequence)systemData.getRestUrl())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"systemData restUrl is missing");
                }
                queryGroupReq = new QueryGroupReq();
                queryGroupReq.setDataModel(systemData.getDataModel());
                queryGroupReq.setMiddleSystemName(systemData.getMiddleSystemName());
                queryGroupReq.setMiddleSystemUid(systemData.getMiddleSystemUid());
                queryGroupReq.setRestUrl(systemData.getRestUrl());
                List groupRuleRespList = this.labelSystemBusinessTodoService.queryThirdGroupList(queryGroupReq);
                boolean flag = Boolean.FALSE;
                if (StringUtils.isBlank((CharSequence)systemData.getCountContentCode())) {
                    List codeList = groupRuleRespList.stream().map(GroupRuleResp::getCode).collect(Collectors.toList());
                    flag = codeList.stream().anyMatch(x -> x.equals(countCode));
                } else {
                    for (GroupRuleResp groupRuleResp : groupRuleRespList) {
                        if (!groupRuleResp.getCode().equals(systemData.getCountCode())) continue;
                        List codeList = groupRuleResp.getGroupConditionList().stream().map(GroupRuleResp::getCode).collect(Collectors.toList());
                        flag = codeList.stream().anyMatch(x -> x.equals(countContentCode));
                        break;
                    }
                }
                jsonObject.put((Object)"terminal", (Object)1);
                jsonObject.put((Object)"flag", (Object)flag);
                return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
            }
            jsonObject.put((Object)"terminal", (Object)0);
            queryGroupReq = new QueryGroupReq();
            List groupRuleRespList = this.labelSystemBusinessTodoService.queryAgileGroupList(queryGroupReq);
            boolean flag = groupRuleRespList.stream().anyMatch(x -> x.getCode().equals(countCode));
            if (!flag) {
                jsonObject.put((Object)"flag", (Object)false);
                return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
            }
            queryGroupReq.setGroupCode(systemData.getCountCode());
            groupRuleRespList = this.labelSystemBusinessTodoService.queryAgileGroupList(queryGroupReq);
            flag = groupRuleRespList.stream().anyMatch(x -> x.getCode().equals(countContentCode));
            jsonObject.put((Object)"flag", (Object)flag);
            return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
        }
        catch (Exception e) {
            logger.error("validate group exist error. param:{}", (Object)validateLabelReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/label/system/data/validateGroupExist");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u4fdd\u5b58\u548c\u4fee\u6539\u6570\u636e\u6e90")
    @PostMapping(value={"/saveData"})
    public ResponseEntity<?> saveData(@RequestBody @Valid LabelSystemData req, HttpServletRequest request) {
        try {
            if (!this.authService.hasAuth("datasource-configuration")) {
                SecurityLogUtil.writeSecurityLog((HttpServletRequest)request, (String)JSON.toJSONString((Object)req));
            }
            return this.labelSystemDataService.saveData(req);
        }
        catch (Exception e) {
            logger.error("saveData exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/label/system/data/saveData");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u67e5\u8be2\u7ec4\u4ef6\u4e0b\u6570\u636e\u6e90\u7684\u5e94\u7528\u7cfb\u7edf")
    @PostMapping(value={"/systemList"})
    public ResponseEntity<BaseResultDTO<List<LabelSystemData>>> querySystemList(@RequestBody QueryLabelSystemReq querySystemReq) {
        if (null == querySystemReq.getDataType()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"component type cannot be empty");
        }
        try {
            List dataIds;
            List labelSystemDataList;
            if (null != querySystemReq.getDataType() && querySystemReq.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())) {
                querySystemReq.setDataType(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
            }
            if (CollectionUtils.isEmpty((Collection)(labelSystemDataList = this.labelSystemDataService.queryDataInfoBy(dataIds = this.labelSystemSourceService.selectPreSystem(querySystemReq.getDataType(), Constants.LabelTypeEnum.SYSTEM_PRE.getVal()), Boolean.valueOf(true))))) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)labelSystemDataList);
            }
            if (querySystemReq.getDataType().equals(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal())) {
                return ResponseEntityWrapperUtil.wrapperOk((Object)this.todoAppSortService.sortLabelSystemData(labelSystemDataList));
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)labelSystemDataList);
        }
        catch (Exception e) {
            logger.error("/semc/label/system/data/systemList exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/label/system/data/systemList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u5e94\u7528\u4e0b\u4f5c\u4e1a")
    @PostMapping(value={"/queryAppJobList"})
    public ResponseEntity<BaseResultDTO<List<AppJobDTO.Job>>> queryAppJobList(@RequestBody LabelSystemData req) {
        if (StringUtils.isEmpty((CharSequence)req.getAppCode())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"app code cannot be empty");
        }
        if (req.getDataSource() == null) {
            req.setDataSource(ApplicationTypeEnum.IAM_APPLICATION.getType());
        }
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.labelSystemDataService.getAppJobList(req.getAppCode(), req.getDataSource(), Boolean.valueOf(true), req.getType()));
        }
        catch (Exception e) {
            logger.error("/semc/label/system/data/queryAppJobList exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/label/system/data/queryAppJobList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u67e5\u8be2\u5df2\u5bf9\u63a5\u7684\u5e94\u7528\u4e0b\u4f5c\u4e1a")
    @PostMapping(value={"/queryJobPageList"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<AppJobDTO.Job>>> queryJobPageList(@RequestBody QueryLabelSystemReq req) {
        if (StringUtils.isEmpty((CharSequence)req.getAppCode())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"app code cannot be empty");
        }
        if (null == req.getPageNum()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"pageNum cannot be empty");
        }
        if (null == req.getPageSize()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"pageSize cannot be empty");
        }
        if (req.getDataSource() == null) {
            req.setDataSource(ApplicationTypeEnum.IAM_APPLICATION.getType());
        }
        try {
            List jobList = this.labelSystemDataService.getAppJobList(req.getAppCode(), req.getDataSource(), Boolean.valueOf(false), null);
            ArrayList<AppJobDTO.Job> jobListResp = new ArrayList<AppJobDTO.Job>();
            for (AppJobDTO.Job job : jobList) {
                if (StringUtils.isEmpty((CharSequence)req.getJobCodeName())) {
                    jobListResp.add(job);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)req.getJobCodeName()) && StringUtils.isEmpty((CharSequence)req.getJobCodeName().trim())) {
                    jobListResp.add(job);
                    continue;
                }
                if (!job.getName().contains(req.getJobCodeName()) && !job.getCode().contains(req.getJobCodeName())) continue;
                jobListResp.add(job);
            }
            jobListResp.sort(Comparator.nullsLast(Comparator.comparing(AppJobDTO.Job::getName, Comparator.nullsLast(String::compareTo))));
            List jobPageList = Utils.subList(jobListResp, (int)req.getPageSize(), (int)req.getPageNum());
            PageInfoResp pageInfoResp = new PageInfoResp();
            int totalPages = jobListResp.size() / req.getPageSize();
            if (jobListResp.size() % req.getPageSize() != 0) {
                ++totalPages;
            }
            pageInfoResp.setTotalPages(totalPages);
            pageInfoResp.setPageNo(req.getPageNum().intValue());
            pageInfoResp.setPageSize(req.getPageSize().intValue());
            pageInfoResp.setTotalRecords(jobListResp.size());
            pageInfoResp.setList(jobPageList);
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            logger.error("/semc/label/system/data/queryJobPageList exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/label/system/data/queryJobPageList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

