/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemDataImport;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.impl.SystemDataWriteHandler;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.SystemDataExportVo;
import com.digiwin.athena.semc.vo.portal.SystemDataImportVo;
import com.digiwin.athena.semc.vo.portal.SystemDataJobExportVo;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/label/system/data"})
public class LabelSystemDataImportController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemDataImportController.class);
    @Autowired
    private LabelSystemDataService labelSystemDataService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/importReport"})
    public ResponseEntity<BaseResultDTO<ImportExcelResp>> importReport(@RequestBody LabelSystemDataImport req) {
        if (StringUtils.isEmpty((String)req.getFileId())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"file code cannot be empty");
        }
        ImportExcelResp excelResp = new ImportExcelResp();
        try {
            List excelVoList = this.labelSystemDataService.readExcel(req.getFileId());
            if (CollectionUtils.isEmpty((Collection)excelVoList)) {
                String error = this.messageUtils.getMessage("error.message.import.cannot.be.empty");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            excelVoList = this.trimDataList(excelVoList);
            excelResp = this.labelSystemDataService.importReport(excelVoList);
            return ResponseEntityWrapperUtil.wrapperOk((Object)excelResp);
        }
        catch (Exception e) {
            log.error("LabelSystemDataImportController import excel exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    public List<SystemDataImportVo> trimDataList(List<SystemDataImportVo> excelVoList) {
        for (SystemDataImportVo excelVo : excelVoList) {
            if (StringUtils.isNotEmpty((String)excelVo.getAppName())) {
                excelVo.setAppName(excelVo.getAppName().trim());
            }
            if (StringUtils.isNotEmpty((String)excelVo.getCategory())) {
                excelVo.setCategory(excelVo.getCategory().trim());
            }
            if (StringUtils.isNotEmpty((String)excelVo.getJobType())) {
                excelVo.setJobType(excelVo.getJobType().trim());
            }
            if (StringUtils.isNotEmpty((String)excelVo.getJobVal())) {
                excelVo.setJobVal(excelVo.getJobVal().trim());
            }
            if (StringUtils.isNotEmpty((String)excelVo.getName())) {
                excelVo.setName(excelVo.getName().trim());
            }
            if (StringUtils.isNotEmpty((String)excelVo.getRemark())) {
                excelVo.setRemark(excelVo.getRemark().trim());
            }
            if (!StringUtils.isNotEmpty((String)excelVo.getValidStatus())) continue;
            excelVo.setValidStatus(excelVo.getValidStatus().trim());
        }
        return excelVoList;
    }

    @PostMapping(value={"/queryImportRecord"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<LabelSystemDataImport>>> queryImportRecord(@RequestBody @Valid QueryImportRecordReq queryImportRecordReq) {
        try {
            if (StringUtils.isNotBlank((String)queryImportRecordReq.getStartTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss") || StringUtils.isNotBlank((String)queryImportRecordReq.getEndTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
            }
            PageInfoResp pageInfoResp = this.labelSystemDataService.queryImportRecord(queryImportRecordReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("queryImportRecord exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/exportReport"})
    public void exportReport(HttpServletResponse response) {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String filename = "\u6570\u636e\u6e90\u914d\u7f6e_" + LocalDate.now().toString().replace("-", "") + ".xlsx";
        response.setHeader("Content-disposition", "attachment;filename=" + new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try {
            List excelVoList = this.labelSystemDataService.exportReport();
            ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), SystemDataExportVo.class).sheet("\u6570\u636e\u6e90\u914d\u7f6e").relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).registerWriteHandler((WriteHandler)new SystemDataWriteHandler())).doWrite((Collection)excelVoList);
        }
        catch (Exception e) {
            log.error("exportReport exception", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @GetMapping(value={"/exportJobList"})
    public void exportJobList(HttpServletResponse response) {
        String filename = "\u5df2\u5bf9\u63a5\u4f5c\u4e1a_" + LocalDate.now().toString().replace("-", "") + ".xlsx";
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try {
            List excelVoList = this.labelSystemDataService.exportJobList();
            ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), SystemDataJobExportVo.class).sheet("\u5df2\u5bf9\u63a5\u4f5c\u4e1a").registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).doWrite((Collection)excelVoList);
        }
        catch (Exception e) {
            log.error("exportReport exception", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

