/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataSourceUpdateReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemUpdateValidReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreCustomVo;
import com.digiwin.athena.semc.vo.portal.ValidLabelRelVO;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Collection;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/preset/component"})
public class LabelSystemPreController {
    @Resource
    LabelSystemPreService labelSystemPreService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(method="pageQuery", description="\u67e5\u8be2\u9884\u8bbe\u7ec4\u4ef6\u5217\u8868")
    @PostMapping(value={"/pageQuery"})
    public ResultPageBean pageQuery(@RequestBody @Valid LabelSystemPreQueryReq labelSystemPreQueryReq) {
        return this.labelSystemPreService.pageQuery(labelSystemPreQueryReq);
    }

    @Operation(method="updateDataSource", description="\u66f4\u65b0\u7ec4\u4ef6\u6570\u636e\u6e90")
    @PostMapping(value={"/updateDataSource"})
    public ResponseEntity<?> updateDataSource(@RequestBody @Valid LabelSystemDataSourceUpdateReq labelSystemUpdateReq) {
        if (CollectionUtils.isEmpty((Collection)labelSystemUpdateReq.getDataSourceInfo())) {
            String error = this.messageUtils.getMessage("error.message.system.data.source.empty");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return this.labelSystemPreService.updateDataSource(labelSystemUpdateReq);
    }

    @PostMapping(value={"/validLabelRel"})
    public ResponseEntity<?> validLabelRel(@RequestBody @Valid LabelSystemUpdateValidReq labelSystemUpdateValidReq) {
        ValidLabelRelVO validLabelRelVO = this.labelSystemPreService.validLabelRel(labelSystemUpdateValidReq);
        return ResponseEntityWrapperUtil.wrapperOk((Object)validLabelRelVO);
    }

    @Operation(method="updateValidStatus", description="\u66f4\u65b0\u542f\u7528\u505c\u7528\u72b6\u6001")
    @PostMapping(value={"/updateValidStatus"})
    public ResponseEntity<?> updateValidStatus(@RequestBody @Valid LabelSystemUpdateValidReq labelSystemUpdateValidReq) {
        return this.labelSystemPreService.updateValidStatus(labelSystemUpdateValidReq.getId(), labelSystemUpdateValidReq.getValidStatus(), labelSystemUpdateValidReq.getComponentSource(), labelSystemUpdateValidReq.getClientType());
    }

    @Operation(method="queryAllSystem", description="\u67e5\u8be2\u9884\u8bbe\u7ec4\u4ef6\u548c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5217\u8868")
    @PostMapping(value={"/queryAllSystem"})
    public ResponseEntity<BaseResultDTO<LabelSystemPreCustomVo>> queryAllSystem(@RequestBody LabelSystemAllVo req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.labelSystemPreService.queryAllSystem(req));
    }

    @PostMapping(value={"/queryAllSystemLabel"})
    public ResponseEntity<BaseResultDTO<LabelSystemPreCustomVo>> queryAllSystemLabel(@RequestBody LabelSystemAllVo req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.labelSystemPreService.queryAllSystemLabel(req));
    }

    @PostMapping(value={"/editToDoData"})
    public ResponseEntity<BaseResultDTO<Integer>> editToDoData(@RequestBody LabelSystemPre req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.labelSystemPreService.editToDoData(req));
    }
}

