/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.controller.portal.PreinstalledApplicationController;
import com.digiwin.athena.semc.dto.portal.AddLogoReq;
import com.digiwin.athena.semc.dto.portal.LogoReq;
import com.digiwin.athena.semc.entity.common.PlatformConfig;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.service.portal.ILogoService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Arrays;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant/api/homepage/logo"})
public class LogoController {
    private static final Logger logger = LoggerFactory.getLogger(PreinstalledApplicationController.class);
    @Autowired
    ILogoService logoService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private EnvProperties envProperties;

    @Operation(summary="\u6dfb\u52a0\u9996\u9875logo\u56fe\u7247")
    @PostMapping(value={"/add"})
    public ResultBean addLogo(@RequestBody @Valid AddLogoReq req) {
        ResultBean resultBean = new ResultBean();
        resultBean.setResponse((Object)this.logoService.addLogoPic(req));
        return resultBean;
    }

    @Operation(summary="\u67e5\u8be2logo\u56fe\u7247\u5730\u5740")
    @GetMapping(value={"/queryLogo"})
    public ResultBean queryLogoByCondition(@RequestParam(value="sceneFlag") Integer sceneFlag) throws Exception {
        if (sceneFlag == null) {
            sceneFlag = Constants.SceneFlagEnum.LOGIN_AFTER_PAGE.getFlag();
        }
        if (!Arrays.asList(Constants.SceneFlagEnum.LOGIN_BEFORE_PAGE.getFlag(), Constants.SceneFlagEnum.LOGIN_AFTER_PAGE.getFlag()).contains(sceneFlag)) {
            throw new Exception("\u573a\u666f\u6807\u8bc6\u4e0d\u5408\u6cd5:" + sceneFlag);
        }
        ResultBean resultBean = new ResultBean();
        String logoUrl = this.logoService.queryLogoByCondition(sceneFlag);
        resultBean.setResponse((Object)logoUrl);
        return resultBean;
    }

    @Operation(summary="\u67e5\u8be2\u767b\u5f55\u9875logo\u5730\u5740")
    @GetMapping(value={"/login"})
    public ResponseEntity<BaseResultDTO<LogoReq>> queryLogoLogin(@RequestParam(value="locale", required=false) String locale, @RequestParam(value="channel", required=false) String channel) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.logoService.queryLoginLogo(locale, channel));
        }
        catch (Exception e) {
            logger.error("query Logo login occur error", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u6dfb\u52a0\u9996\u9875logo\u56fe\u7247")
    @PostMapping(value={"/saveSett"})
    public ResponseEntity<?> saveSett(@RequestBody LogoReq req) {
        ResultBean resultBean = new ResultBean();
        try {
            ResponseEntity responseEntity = this.checkSettParam(req);
            if (null != responseEntity) {
                return responseEntity;
            }
            resultBean.setResponse((Object)this.logoService.saveSett(req));
        }
        catch (Exception e) {
            logger.error("saveSett error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public ResponseEntity<?> checkSettParam(LogoReq req) throws IllegalAccessException {
        if (null == req || Utils.isAllFieldsNull((Object)req)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"\u8bf7\u8f93\u5165\u53c2\u6570");
        }
        if (null != req.getJumpStatus() && req.getJumpStatus().equals(Constants.JumpStatusEnum.YES.getFlag()) && StringUtils.isEmpty((CharSequence)req.getWebSiteAddr())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u8bf7\u8f93\u5165\u8d85\u94fe\u5185\u5bb9");
        }
        if (null != req.getJumpStatusTw() && req.getJumpStatusTw().equals(Constants.JumpStatusEnum.YES.getFlag()) && StringUtils.isEmpty((CharSequence)req.getWebSiteAddrTw())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u8bf7\u8f93\u5165\u8d85\u94fe\u5185\u5bb9");
        }
        if (null != req.getJumpStatusUs() && req.getJumpStatusUs().equals(Constants.JumpStatusEnum.YES.getFlag()) && StringUtils.isEmpty((CharSequence)req.getWebSiteAddrUs())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u8bf7\u8f93\u5165\u8d85\u94fe\u5185\u5bb9");
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getTitle()) && req.getTitle().length() > 20) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_LENGTH_ERROR, (String)"\u6700\u591a\u8f93\u516520\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getTitleTw()) && req.getTitleTw().length() > 20) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_LENGTH_ERROR, (String)"\u6700\u591a\u8f93\u516520\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getTitleUs()) && req.getTitleUs().length() > 20) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_LENGTH_ERROR, (String)"\u6700\u591a\u8f93\u516520\u4e2a\u5b57\u7b26");
        }
        return null;
    }

    @Operation(summary="\u67e5\u8be2\u4f01\u4e1a\u6807\u8bc6\u8bbe\u7f6e")
    @PostMapping(value={"/getSett"})
    public ResponseEntity<BaseResultDTO<LogoReq>> getSett() {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.logoService.getSett());
    }

    @Operation(summary="\u67e5\u8be2\u767b\u5f55\u540e\u4f01\u4e1a\u6807\u8bc6\u4fe1\u606f")
    @PostMapping(value={"/querySettInfo"})
    public ResponseEntity<BaseResultDTO<LogoReq>> querySettInfo() {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.logoService.querySettInfo());
    }

    @Operation(summary="\u83b7\u53d6\u5e73\u53f0\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"/platform/getConfig"})
    public ResponseEntity<BaseResultDTO<PlatformConfig>> getPlatformConfig(@RequestBody PlatformConfig req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.logoService.getPlatformConfig(req.getChannel()));
    }
}

