/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.dto.portal.NewsPageQueryResp;
import com.digiwin.athena.semc.dto.portal.NoticePageQueryReq;
import com.digiwin.athena.semc.entity.portal.News;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.service.portal.NewsService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/news"})
public class NewsController
extends BasicController<NewsService, News> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsController.class);
    @Resource
    private ESPService espService;
    @Resource
    private NewsService newsService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/pageQuery"})
    public ResultPageBean pageQueryNews(HttpServletRequest request, @Valid @RequestBody NoticePageQueryReq noticePageQueryReq) {
        ResultPageBean resultPageBean;
        log.info("Query news list param: {}", (Object)JsonUtils.objectToString((Object)noticePageQueryReq));
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        try {
            ArrayList filteredNewsList = new ArrayList();
            NewsPageQueryResp newsPageQueryResp = new NewsPageQueryResp();
            noticePageQueryReq.getEaiSysInfoList().forEach(eaiSysInfo -> {
                Map result = this.espService.queryByEsp(eaiSysInfo.getEaiSysName(), eaiSysInfo.getEaiSysUid(), EAIServiceNameEnum.NEWS.getServiceName(), null, null, null, null);
                filteredNewsList.addAll(this.newsService.handleEspResult(result, eaiSysInfo, newsPageQueryResp, noticePageQueryReq.getQryCondition()));
                filteredNewsList.forEach(x -> x.setNewsUrl(x.getNewsUrl() + (x.getNewsUrl().contains("?") ? "&" : "?") + "appToken=" + eaiSysInfo.getAppToken() + "&tenantId=" + tenantId + "&bindMode=" + eaiSysInfo.getUserBindFlag()));
            });
            List sortedNewsAllList = filteredNewsList.stream().sorted(Comparator.comparing(News::getPublishTime).reversed()).collect(Collectors.toList());
            newsPageQueryResp.setNewsList(sortedNewsAllList.stream().skip((long)(noticePageQueryReq.getPageNum() - 1) * noticePageQueryReq.getPageSize().longValue()).limit(noticePageQueryReq.getPageSize().intValue()).collect(Collectors.toList()));
            resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)newsPageQueryResp, (PageInfo)PageInfo.getPageInfo((Integer)noticePageQueryReq.getPageNum(), (Integer)noticePageQueryReq.getPageSize(), (Integer)filteredNewsList.size())));
        }
        catch (BizException bizException) {
            return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.ADAPT_SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.news.open-error")));
        }
        catch (Exception e) {
            log.error("Query news Error", (Throwable)e);
            resultPageBean = ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.SYSTEM_ERROR, this.messageUtils.getMessage("error.message.common.system-error")));
        }
        return resultPageBean;
    }

    @PostMapping(value={"/label/pageQueryNews"})
    public ResultPageBean pageQueryNews(@Valid @RequestBody LabelSystemPreReq newsListReq) {
        ResultPageBean resultPageBean;
        log.info("pageQueryNews:{}", (Object)JSON.toJSONString((Object)newsListReq));
        try {
            resultPageBean = this.newsService.pageQueryNews(newsListReq);
        }
        catch (RuntimeException bizException) {
            log.error("pageQueryNews exception", (Throwable)bizException);
            return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.ADAPT_SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.news.open-error")));
        }
        catch (Exception e) {
            log.error("pageQueryNews query exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/news/label/pageQueryNews");
            resultPageBean = ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.SYSTEM_ERROR, error));
        }
        return resultPageBean;
    }
}

