/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.dto.portal.NoticePageQueryReq;
import com.digiwin.athena.semc.dto.portal.NoticePageQueryResp;
import com.digiwin.athena.semc.entity.portal.Notice;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.service.portal.NoticeService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/notice"})
public class NoticeController
extends BasicController<NoticeService, Notice> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NoticeController.class);
    @Resource
    private NoticeService noticeService;
    @Resource
    private ESPService espService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    EnvProperties envProperties;

    @PostMapping(value={"/pageQuery"})
    public ResultPageBean pageQueryNotice(HttpServletRequest request, @Valid @RequestBody NoticePageQueryReq noticePageQueryReq) {
        ResultPageBean resultPageBean;
        log.info("Query notice list param: noticePageQueryReq:{}", (Object)JSON.toJSONString((Object)noticePageQueryReq));
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        try {
            HashMap<String, String> extHeader = new HashMap<String, String>();
            extHeader.put("digi-userToken", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
            ArrayList filteredNoticeList = new ArrayList();
            NoticePageQueryResp noticePageQueryResp = new NoticePageQueryResp();
            noticePageQueryReq.getEaiSysInfoList().forEach(eaiSysInfo -> {
                extHeader.put("digi-appToken", StringUtils.isBlank((CharSequence)eaiSysInfo.getAppToken()) ? this.envProperties.getAppToken() : eaiSysInfo.getAppToken());
                Map result = this.espService.queryByEsp(eaiSysInfo.getEaiSysName(), eaiSysInfo.getEaiSysUid(), EAIServiceNameEnum.NOTICE.getServiceName(), extHeader, null, null, null);
                filteredNoticeList.addAll(this.noticeService.handleEspResult(result, eaiSysInfo, noticePageQueryReq.getQryCondition(), noticePageQueryResp));
                filteredNoticeList.forEach(x -> x.setNoticeUrl(x.getNoticeUrl() + (x.getNoticeUrl().contains("?") ? "&" : "?") + "appToken=" + eaiSysInfo.getAppToken() + "&tenantId=" + tenantId + "&bindMode=" + eaiSysInfo.getUserBindFlag()));
            });
            List sortedNoticeAllList = filteredNoticeList.stream().sorted(Comparator.comparing(Notice::getPublishTime).reversed()).collect(Collectors.toList());
            noticePageQueryResp.setNoticeList(sortedNoticeAllList.stream().skip((long)(noticePageQueryReq.getPageNum() - 1) * noticePageQueryReq.getPageSize().longValue()).limit(noticePageQueryReq.getPageSize().intValue()).collect(Collectors.toList()));
            resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)noticePageQueryResp, (PageInfo)PageInfo.getPageInfo((Integer)noticePageQueryReq.getPageNum(), (Integer)noticePageQueryReq.getPageSize(), (Integer)sortedNoticeAllList.size())));
        }
        catch (Exception e) {
            log.error("notice query exception", (Throwable)e);
            resultPageBean = ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.SYSTEM_ERROR, this.messageUtils.getMessage("error.message.common.system-error")));
        }
        return resultPageBean;
    }

    @PostMapping(value={"/label/pageQueryNotice"})
    public ResultPageBean pageQueryNotice(@Valid @RequestBody LabelSystemPreReq noticesListReq) {
        ResultPageBean resultPageBean;
        log.info("pageQueryNotices:{}", (Object)JSON.toJSONString((Object)noticesListReq));
        try {
            resultPageBean = this.noticeService.pageQueryNotice(noticesListReq);
        }
        catch (Exception e) {
            log.error("pageQueryNotices query exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/notice/label/pageQueryNotices");
            resultPageBean = ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.SYSTEM_ERROR, error));
        }
        return resultPageBean;
    }
}

