/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.AddUseRecordRequest;
import com.digiwin.athena.semc.dto.portal.PortalInfoCheckResp;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.dto.portal.PortalSelectOptionRespDTO;
import com.digiwin.athena.semc.dto.portal.UserPortalInfoRequest;
import com.digiwin.athena.semc.dto.portal.VisitPortalReq;
import com.digiwin.athena.semc.dto.portal.WebLinkPermissionDTO;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalContentKingKongDistrict;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoAuth;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.portal.PortalInfoUse;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalInfoMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoMapper;
import com.digiwin.athena.semc.proxy.dmc.service.DmcService;
import com.digiwin.athena.semc.proxy.dmc.service.FileInfo;
import com.digiwin.athena.semc.service.mobile.MobilePortalService;
import com.digiwin.athena.semc.service.portal.PortalInfoService;
import com.digiwin.athena.semc.service.portal.PortalVisitService;
import com.digiwin.athena.semc.service.workbench.constant.PublishSourceEnum;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthReq;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthResp;
import com.digiwin.athena.semc.vo.portal.PortalUserAuthResp;
import io.swagger.v3.oas.annotations.Operation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/semc/portal/"})
public class PortalInfoController {
    private static final Logger logger = LoggerFactory.getLogger(PortalInfoController.class);
    @Autowired
    PortalInfoService portalInfoService;
    @Autowired
    PortalVisitService portalVisitService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    PortalInfoMapper portalInfoMapper;
    @Autowired
    MobilePortalInfoMapper mobilePortalInfoMapper;
    @Autowired
    private MobilePortalService mobilePortalService;
    @Autowired
    private DmcService dmcService;

    @Operation(method="getUserPortal", description="\u67e5\u8be2\u7528\u6237\u9009\u62e9\u95e8\u6237\u63a5\u53e3")
    @PostMapping(value={"/info/getUserPortal"})
    public ResponseEntity<?> getUserPortal() {
        PortalInfoUse infoUse = this.portalInfoService.getUserPortal();
        return ResponseEntityWrapper.wrapperOk((Object)infoUse);
    }

    @Operation(method="getDefaultPortal", description="\u83b7\u53d6\u9ed8\u8ba4\u95e8\u6237\u63a5\u53e3")
    @GetMapping(value={"/info/getDefaultPortal"})
    public ResponseEntity<?> getDefaultPortal() {
        PortalInfo portalInfo = this.portalInfoService.getDefaultPortal();
        return ResponseEntityWrapper.wrapperOk((Object)portalInfo);
    }

    @Operation(method="savePortal", description="\u95e8\u6237\u4fdd\u5b58")
    @PostMapping(value={"/info/savePortal"})
    public ResponseEntity<?> savePortal(@RequestBody @Valid PortalInfo req) {
        ResponseEntity checkResult;
        req.setClientType(Optional.ofNullable(req.getClientType()).orElse(Constants.ClientTypeEnum.PC.getValue()));
        List portalInfoList = this.portalInfoService.checkPortal(req);
        if (CollectionUtils.isNotEmpty((Collection)portalInfoList)) {
            Optional<PortalInfo> optional = portalInfoList.stream().filter(portalInfo -> PublishSourceEnum.ISV.name().equals(portalInfo.getPublishSource())).findAny();
            if (optional.isPresent()) {
                String error = this.messageUtils.getMessage("error.unsupported.edit.isv.portal");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            if (null == req.getTemplateId()) {
                String error = this.messageUtils.getMessage("error.message.job.bench.name.repeat");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
        }
        if (Constants.ClientTypeTypeEnum.MOBILE.getFlag().equals(req.getClientType()) && null != (checkResult = this.checkMobilePortal(req))) {
            return checkResult;
        }
        try {
            this.portalInfoService.savePortal(req);
        }
        catch (Exception e) {
            logger.error("savePortal exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/portal/info/savePortal");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public ResponseEntity<?> checkMobilePortal(PortalInfo req) {
        List contentList = req.getContentList();
        if (CollectionUtils.isEmpty((Collection)contentList)) {
            return null;
        }
        List taskDataList = contentList.stream().filter(item -> Constants.PrtalMobileContentTypeEnum.PRE_TASK.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(taskDataList) && taskDataList.size() > 1) {
            String error = this.messageUtils.getMessage("error.message.mobile.portal.task.can.only.error");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        List projectDataList = contentList.stream().filter(item -> Constants.PrtalMobileContentTypeEnum.PRE_PROJECT.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(projectDataList) && taskDataList.size() > 1) {
            String error = this.messageUtils.getMessage("error.message.mobile.portal.project.can.only.error");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        List districtList = contentList.stream().filter(item -> Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(item.getContentType())).collect(Collectors.toList());
        int customDistrict = 0;
        for (PortalInfoContent district : districtList) {
            PortalContentKingKongDistrict kingKongDistrict = (PortalContentKingKongDistrict)JSON.parseObject((String)JSON.toJSONString((Object)district.getContentConfig()), PortalContentKingKongDistrict.class);
            if (kingKongDistrict.getCustomType().equals(Constants.DistrictCustomTypeEnum.USER_TYPE.getValue())) {
                ++customDistrict;
            }
            if (customDistrict > 1) {
                String error = this.messageUtils.getMessage("error.message.mobile.portal.custom.district.can.only.error");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            if (!Constants.DistrictinteractionTypeEnum.EXPAND_ALL.getValue().equals(kingKongDistrict.getInteractionType())) continue;
            kingKongDistrict.setLineNum(null);
        }
        return null;
    }

    @Operation(method="/manage/pageQuery", description="\u67e5\u8be2\u95e8\u6237\u5217\u8868")
    @PostMapping(value={"/manage/pageQuery"})
    public ResultPageBean pageQuery(@RequestBody @Valid PortalInfoQueryReq req) {
        return this.portalInfoService.pageQuery(req);
    }

    @Operation(method="updateStatus", description="\u6279\u91cf\u53d1\u5e03\u548c\u53d6\u6d88\u53d1\u5e03")
    @PostMapping(value={"/info/updateStatus"})
    public ResponseEntity<?> updateStatus(@RequestBody PortalInfoQueryReq req) {
        List newPortalIdList;
        if (CollectionUtils.isEmpty((Collection)req.getIdList()) && CollectionUtils.isEmpty((Collection)req.getMobileIdReqList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"idList is null");
        }
        if (null == req.getStatus()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"status is null");
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getIdList())) {
            if (this.portalInfoService.checkISVPortal(req.getIdList())) {
                String error = this.messageUtils.getMessage("error.unsupported.push.isv.portal");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
        } else if (CollectionUtils.isNotEmpty((Collection)req.getMobileIdReqList()) && CollectionUtils.isNotEmpty(newPortalIdList = req.getMobileIdReqList().stream().filter(x -> Boolean.FALSE.equals(x.getOldPortalFlag())).map(PortalInfoQueryReq.MobileIdReq::getId).collect(Collectors.toList())) && this.portalInfoService.checkISVPortal(newPortalIdList)) {
            String error = this.messageUtils.getMessage("error.unsupported.push.isv.portal");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        this.portalInfoService.updateBat(req);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Operation(method="batchDel", description="\u6279\u91cf\u5220\u9664\u5e03\u5c40")
    @PostMapping(value={"info/batchDel"})
    public ResponseEntity<?> batchDel(@RequestBody PortalInfoQueryReq req) {
        List newPortalIdList;
        if (CollectionUtils.isEmpty((Collection)req.getIdList()) && CollectionUtils.isEmpty((Collection)req.getMobileIdReqList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"idList is null");
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getIdList())) {
            if (this.portalInfoService.checkISVPortal(req.getIdList())) {
                String error = this.messageUtils.getMessage("error.unsupported.delete.isv.portal");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
        } else if (CollectionUtils.isNotEmpty((Collection)req.getMobileIdReqList()) && CollectionUtils.isNotEmpty(newPortalIdList = req.getMobileIdReqList().stream().filter(x -> Boolean.FALSE.equals(x.getOldPortalFlag())).map(PortalInfoQueryReq.MobileIdReq::getId).collect(Collectors.toList())) && this.portalInfoService.checkISVPortal(newPortalIdList)) {
            String error = this.messageUtils.getMessage("error.unsupported.delete.isv.portal");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        this.portalInfoService.delBat(req);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Operation(summary="\u4fdd\u5b58\u7ec4\u4ef6\u6743\u9650")
    @PostMapping(value={"/userAuth/savePortalAuth"})
    public ResponseEntity<BaseResultDTO<Integer>> savePortalAuth(@RequestBody @Valid PortalInfoAuthReq req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.portalInfoService.savePortalAuth(req));
        }
        catch (Exception e) {
            logger.error("savePortalAuth exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u67e5\u8be2\u95e8\u6237\u6743\u9650\u4fe1\u606f")
    @PostMapping(value={"/userAuth/selectByPortal"})
    public ResponseEntity<BaseResultDTO<PortalInfoAuthResp>> selectByPortal(@RequestBody PortalInfoAuth req) {
        if (null == req.getId()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.portalInfoService.selectByPortalAuth(req.getId()));
    }

    @Operation(summary="\u67e5\u8be2\u7528\u6237\u804c\u80fd\u95e8\u6237\u5217\u8868")
    @PostMapping(value={"/info/userAuth/selectUserPortal"})
    public ResponseEntity<BaseResultDTO<List<PortalUserAuthResp>>> selectUserPortal(@RequestBody PortalInfo req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.portalInfoService.selectUserPortal(req.getClientType()));
        }
        catch (Exception e) {
            logger.error("selectUserPortal exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(method="getPortalDetail", description="\u83b7\u53d6\u95e8\u6237\u6570\u636e\u8be6\u60c5")
    @PostMapping(value={"/info/getPortalDetail"})
    public ResponseEntity<?> getPortalDetail(@RequestBody PortalInfo req) {
        PortalInfo portalInfo;
        if (null == req.getId()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id cannot be empty");
        }
        if (Constants.LabelOrPoralSourceEnum.TENANT.getFlag().equals(req.getPortalTypeSource())) {
            portalInfo = this.portalInfoService.getTempPortal(req.getId());
        } else {
            portalInfo = this.portalInfoService.queryPortalInfoByDesignerId(req.getId());
            portalInfo.setPortalTypeSource(Constants.PortalTypeSourceEnum.ISV.getFlag());
        }
        if (null == portalInfo) {
            String recentlyMsg = this.messageUtils.getMessage("error.message.choose.portal.recovery");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)recentlyMsg);
        }
        return this.portalInfoService.getPortalDetail(portalInfo);
    }

    @Operation(method="getPortalInfo", description="\u83b7\u53d6\u95e8\u6237\u8be6\u60c5")
    @PostMapping(value={"/info/getPortalInfo"})
    public ResponseEntity<?> getPortalInfo(@RequestBody UserPortalInfoRequest req) {
        req.setClientType(Optional.ofNullable(req.getClientType()).orElse(Constants.ClientTypeEnum.PC.getValue()));
        if (Constants.ClientTypeEnum.MOBILE.getValue().equals(req.getClientType())) {
            return this.getPortalInfoByMobile(req);
        }
        return this.getPortalInfoByPc(req);
    }

    private ResponseEntity<?> getPortalInfoByPc(UserPortalInfoRequest req) {
        String recentlyMsg;
        PortalInfo portalInfo;
        Long id = req.getId();
        if (null == id) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
        }
        Integer clientType = Optional.ofNullable(req.getClientType()).orElse(Constants.ClientTypeEnum.PC.getValue());
        Integer portalTypeSource = Optional.ofNullable(req.getPortalTypeSource()).orElse(Constants.PortalTypeSourceEnum.TENANT.getFlag());
        if (Constants.PortalTypeSourceEnum.ISV.getFlag().equals(portalTypeSource)) {
            portalInfo = this.portalInfoService.queryPortalInfoByDesignerId(id);
        } else {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PortalInfo::getId, (Object)id)).eq(PortalInfo::getClientType, (Object)clientType);
            portalInfo = (PortalInfo)InterceptorIgnoreUtil.handler(() -> (PortalInfo)this.portalInfoMapper.selectOne((Wrapper)queryWrapper));
        }
        if (null == portalInfo) {
            portalInfo = new PortalInfo();
            recentlyMsg = this.messageUtils.getMessage("error.message.choose.portal.recovery");
            portalInfo.setRecentlyMsg(recentlyMsg);
            return ResponseEntityWrapper.wrapperOk((Object)portalInfo);
        }
        if (portalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal()) && !portalInfo.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_YES)) {
            recentlyMsg = this.messageUtils.getMessage("error.message.choose.portal.recovery");
            portalInfo.setRecentlyMsg(recentlyMsg);
            return ResponseEntityWrapper.wrapperOk((Object)portalInfo);
        }
        try {
            portalInfo.setPortalTypeSource(portalTypeSource);
            return this.portalInfoService.getPortalInfo(portalInfo);
        }
        catch (Exception e) {
            logger.error("getPortalInfo exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/portal/info/getPortalInfo");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    private ResponseEntity<?> getPortalInfoByMobile(UserPortalInfoRequest req) {
        if (req.getScene() == 0) {
            PortalInfo portalInfo = this.portalInfoService.getUserMobilePortalInfo(req);
            if (null == portalInfo && req.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag())) {
                portalInfo = new PortalInfo();
                String recentlyMsg = this.messageUtils.getMessage("error.message.not.auth");
                portalInfo.setRecentlyMsg(recentlyMsg);
                return ResponseEntityWrapperUtil.wrapperOk((Object)portalInfo);
            }
            if (null == portalInfo && req.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
                String recentlyMsg = this.messageUtils.getMessage("error.message.mobile.portal.custom.del");
                return ResponseEntityWrapperUtil.wrapperOk((Object)recentlyMsg);
            }
            if (null == portalInfo) {
                portalInfo = new PortalInfo();
                String recentlyMsg = this.messageUtils.getMessage("error.message.not.auth");
                portalInfo.setRecentlyMsg(recentlyMsg);
                return ResponseEntityWrapperUtil.wrapperOk((Object)portalInfo);
            }
            if (portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag()) && portalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal()) && !portalInfo.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_YES)) {
                String recentlyMsg = this.messageUtils.getMessage("error.message.not.auth");
                portalInfo.setRecentlyMsg(recentlyMsg);
                return ResponseEntityWrapperUtil.wrapperOk((Object)portalInfo);
            }
            if (portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag()) && portalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
                String recentlyMsg = this.messageUtils.getMessage("error.message.mobile.portal.custom.del");
                return ResponseEntityWrapperUtil.wrapperOk((Object)recentlyMsg);
            }
            try {
                return ResponseEntityWrapperUtil.wrapperOk((Object)this.portalInfoService.getUserMobilePortalDetail(portalInfo));
            }
            catch (Exception e) {
                logger.error("getPortalInfo exception {}", (Object)e.getMessage());
                String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/portal/info/getPortalInfo");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
        }
        PortalInfo result = this.portalInfoService.getPreMobilePortal(req.getId());
        return ResponseEntityWrapperUtil.wrapperOk((Object)result);
    }

    @Operation(method="checkPortalInfo", description="\u6821\u9a8c\u95e8\u6237\u6743\u9650")
    @PostMapping(value={"/info/checkPortalInfo"})
    public ResponseEntity<?> checkPortalInfo(@RequestBody PortalInfo req) {
        req.setClientType(Optional.ofNullable(req.getClientType()).orElse(Constants.ClientTypeEnum.PC.getValue()));
        if (Constants.ClientTypeEnum.MOBILE.getValue().equals(req.getClientType())) {
            return this.checkPortalInfoByMobile(req);
        }
        return this.checkPortalInfoByPc(req);
    }

    private ResponseEntity<?> checkPortalInfoByMobile(PortalInfo req) {
        PortalInfo portalInfo;
        if (null == req.getId()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
        }
        PortalInfoCheckResp checkResp = new PortalInfoCheckResp();
        checkResp.setIsHavePort(Boolean.valueOf(false));
        MobilePortalInfo mobilePortalInfo = null;
        if (Constants.PortalTypeSourceEnum.ISV.getFlag().equals(req.getPortalTypeSource())) {
            portalInfo = this.portalInfoService.queryPortalInfoByDesignerId(req.getId());
        } else {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PortalInfo::getId, (Object)req.getId())).eq(PortalInfo::getClientType, (Object)req.getClientType());
            portalInfo = (PortalInfo)InterceptorIgnoreUtil.handler(() -> (PortalInfo)this.portalInfoMapper.selectOne((Wrapper)queryWrapper));
            if (portalInfo == null && Constants.ClientTypeEnum.MOBILE.getValue().equals(req.getClientType()) && (mobilePortalInfo = (MobilePortalInfo)this.mobilePortalInfoMapper.selectById((Serializable)req.getId())) != null) {
                portalInfo = new PortalInfo();
                BeanUtils.copyProperties((Object)mobilePortalInfo, (Object)portalInfo);
                portalInfo.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
                portalInfo.setMenuTypeSource(Constants.MenuTypeSourceEnum.TENANT.getFlag());
                portalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
            }
        }
        if (null == portalInfo && req.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag())) {
            checkResp.setErrorMsg(this.messageUtils.getMessage("error.message.not.auth"));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        if (null == portalInfo && req.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
            checkResp.setErrorMsg(this.messageUtils.getMessage("error.message.mobile.portal.custom.del"));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        if (null == portalInfo) {
            checkResp.setErrorMsg(this.messageUtils.getMessage("error.message.not.auth"));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        checkResp.setPortalName(portalInfo.getName());
        if (!Objects.equals(Constants.DEFAULT_CONFIGURED_FLAG_YES, portalInfo.getDefaultFlag()) && portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.PORTAL.getFlag()) && portalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
            checkResp.setErrorMsg(this.messageUtils.getMessage("error.message.not.auth"));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        if (portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag()) && portalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
            checkResp.setErrorMsg(this.messageUtils.getMessage("error.message.mobile.portal.custom.del"));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        if (portalInfo.getDefaultFlag() == 1) {
            checkResp.setIsHavePort(Boolean.valueOf(true));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        try {
            if (mobilePortalInfo == null) {
                return this.portalInfoService.checkPortalInfo(portalInfo);
            }
            return this.mobilePortalService.checkPortalInfo(mobilePortalInfo);
        }
        catch (Exception e) {
            logger.error("checkPortalInfo exception {}", (Object)e.getMessage());
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobilePortal/info/getPortalInfo");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    private ResponseEntity<?> checkPortalInfoByPc(PortalInfo req) {
        PortalInfo portalInfo;
        if (null == req.getId()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
        }
        PortalInfoCheckResp checkResp = new PortalInfoCheckResp();
        checkResp.setIsHavePort(Boolean.valueOf(false));
        if (Constants.PortalTypeSourceEnum.ISV.getFlag().equals(req.getPortalTypeSource())) {
            portalInfo = this.portalInfoService.queryPortalInfoByDesignerId(req.getId());
        } else {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PortalInfo::getId, (Object)req.getId())).eq(PortalInfo::getClientType, (Object)req.getClientType());
            portalInfo = (PortalInfo)InterceptorIgnoreUtil.handler(() -> (PortalInfo)this.portalInfoMapper.selectOne((Wrapper)queryWrapper));
        }
        if (null == portalInfo) {
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        if (portalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        if (portalInfo.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_YES)) {
            checkResp.setIsHavePort(Boolean.valueOf(true));
            return ResponseEntityWrapper.wrapperOk((Object)checkResp);
        }
        try {
            return this.portalInfoService.checkPortalInfo(portalInfo);
        }
        catch (Exception e) {
            logger.error("checkPortalInfo exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/portal/info/getPortalInfo");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/info/addUseRecord"})
    public ResponseEntity<?> addUseRecord(@RequestBody AddUseRecordRequest req) {
        if (Constants.ClientTypeEnum.MOBILE.getValue().equals(req.getClientType())) {
            return this.addUseRecordByMobile(req);
        }
        return this.addUseRecordByPc(req);
    }

    private ResponseEntity<?> addUseRecordByMobile(AddUseRecordRequest req) {
        if (req.getClientType() == null) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u672a\u4f20\u5165\u76f8\u5173\u7684\u53c2\u6570");
        }
        if (req.getPortalTypeSource() == null) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u672a\u4f20\u5165\u76f8\u5173\u7684\u53c2\u6570");
        }
        this.portalInfoService.addUseRecordByMobile(req);
        return ResponseEntityWrapperUtil.wrapperOk((Object)req.getId());
    }

    private ResponseEntity<?> addUseRecordByPc(AddUseRecordRequest req) {
        PortalInfo portalInfo;
        Long id = req.getId();
        if (null == id) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
        }
        Integer clientType = Optional.ofNullable(req.getClientType()).orElse(Constants.ClientTypeEnum.PC.getValue());
        Integer portalTypeSource = Optional.ofNullable(req.getPortalTypeSource()).orElse(Constants.PortalTypeSourceEnum.TENANT.getFlag());
        if (Constants.PortalTypeSourceEnum.ISV.getFlag().equals(portalTypeSource)) {
            portalInfo = this.portalInfoService.queryPortalInfoByDesignerId(id);
        } else {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PortalInfo::getId, (Object)id)).eq(PortalInfo::getClientType, (Object)clientType);
            portalInfo = (PortalInfo)InterceptorIgnoreUtil.handler(() -> (PortalInfo)this.portalInfoMapper.selectOne((Wrapper)queryWrapper));
        }
        if (null == portalInfo) {
            portalInfo = new PortalInfo();
            String recentlyMsg = this.messageUtils.getMessage("error.message.choose.portal.recovery");
            portalInfo.setRecentlyMsg(recentlyMsg);
            return ResponseEntityWrapper.wrapperOk((Object)portalInfo);
        }
        try {
            this.portalInfoService.addUseRecord(id, clientType, portalTypeSource);
            return ResponseEntityWrapper.wrapperOk((Object)id);
        }
        catch (Exception e) {
            logger.error("getPortalInfo exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/portal/info/getPortalInfo");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryLinkList"})
    public ResponseEntity<BaseResultDTO<List<PortalSelectOptionRespDTO>>> queryLinkList(@RequestBody Map<String, Integer> req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.portalInfoService.queryLinkList(req.get("isvDesign")));
        }
        catch (Exception e) {
            logger.error("queryLinkList exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/checkLinkPerm"})
    public ResponseEntity<BaseResultDTO<WebLinkPermissionDTO>> checkLinkPerm(@RequestBody WebLinkPermissionDTO req) {
        try {
            if (null == req.getType()) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"type is null");
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.portalInfoService.checkLinkPerm(req));
        }
        catch (Exception e) {
            logger.error("checkLinkPerm exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @PostMapping(value={"/visitPortal"})
    public ResponseEntity<?> visitPortal(@RequestBody @Valid VisitPortalReq visitPortalReq) {
        this.portalVisitService.recordVisit(visitPortalReq);
        return ResponseEntityWrapperUtil.wrapperOk((Object)true);
    }

    @Operation(summary="\u590d\u5236\u95e8\u6237")
    @PostMapping(value={"info/copyPortal"})
    public ResponseEntity<?> copyPortal(@RequestBody PortalInfo req) {
        try {
            if (null == req.getId() || req.getOldPortalFlag() == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id  cannot be empty");
            }
            return this.portalInfoService.copyPortal(req.getId(), req.getOldPortalFlag());
        }
        catch (Exception e) {
            logger.error("copyPortal exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u590d\u5236\u95e8\u6237")
    @PostMapping(value={"/upload"})
    public ResponseEntity<?> upload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="ids") String ids) {
        File file2 = this.convertMultiPartFileToFileV2(file);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setId(ids);
        String contentType = URLConnection.guessContentTypeFromName(file2.getName());
        String id = this.dmcService.upload(file2, contentType, fileInfo);
        return ResponseEntityWrapper.wrapperOk((Object)id);
    }

    public File convertMultiPartFileToFileV2(MultipartFile file) {
        File convFile = new File(file.getOriginalFilename());
        try (InputStream targetStream = file.getInputStream();
             FileOutputStream outStream = new FileOutputStream(convFile);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = targetStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return convFile;
    }
}

