/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.erpsso.PreApplicationUpdateDto;
import com.digiwin.athena.semc.dto.portal.PreinstalledApplicationConfigUpdateDto;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/management/preinstalledapp"})
public class PreinstalledApplicationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreinstalledApplicationController.class);
    private static final Logger logger = LoggerFactory.getLogger(PreinstalledApplicationController.class);
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;
    @Resource
    private MessageUtils messageUtils;

    @GetMapping(value={"/getPreinstalledApplicationConfig"})
    public ResponseEntity<BaseResultDTO<List<PreinstalledApplication>>> queryPreinstalledAppList(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        List preinstalledApplicationList = this.preinstalledApplicationService.queryPreinstalledAppList(user);
        if (CollectionUtils.isNotEmpty((Collection)preinstalledApplicationList)) {
            preinstalledApplicationList.forEach(preinstalledApplication -> preinstalledApplication.setApplicationConfig(""));
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)preinstalledApplicationList);
    }

    @GetMapping(value={"/getPreinstalledApplicationConfig/{applicationType}/{preinstalledApplicationId}"})
    public ResponseEntity<BaseResultDTO<JSONObject>> queryPreinstalledAppDetail(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @PathVariable(value="applicationType") @NotEmpty(message="\u5e94\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5e94\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") String applicationType, @PathVariable(value="preinstalledApplicationId") @NotNull(message="\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a") long preinstalledApplicationId) {
        JSONObject jsonObject = this.preinstalledApplicationService.queryPreinstalledAppDetail(user, applicationType, preinstalledApplicationId);
        return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
    }

    @PostMapping(value={"/updatePreinstalledApplicationConfig"})
    public ResponseEntity<?> updatePreinstalledAppConfig(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @RequestBody @Valid PreinstalledApplicationConfigUpdateDto preinstalledApplicationConfigUpdateDto) {
        if (!Objects.isNull(preinstalledApplicationConfigUpdateDto.getConfig()) && preinstalledApplicationConfigUpdateDto.getConfig().toString().length() > 200) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_LENGTH_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-length"));
        }
        this.preinstalledApplicationService.updatePreinstalledAppConfig(user, preinstalledApplicationConfigUpdateDto);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Operation(summary="\u66f4\u65b0\u5e94\u7528\u53cb\u60c5\u94fe\u63a5\u663e\u793a\u6807\u8bc6")
    @PostMapping(value={"/updatePreApplicationDisplayFlag"})
    public ResponseEntity<BaseResultDTO<Boolean>> updatePreApplicationDisplayFlag(@RequestBody PreApplicationUpdateDto preApplicationUpdateDto) {
        try {
            this.preinstalledApplicationService.updateAppInfo(preApplicationUpdateDto.getPreApplicationIdList(), null, preApplicationUpdateDto.getLinkDisplayFlag());
            return ResponseEntityWrapperUtil.wrapperOk((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            logger.error("update pre application display flag error. preApplicationUpdateDto:{} ", (Object)preApplicationUpdateDto, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/delApplicationInstance"})
    public ResponseEntity<BaseResultDTO<Integer>> delApplicationInstance(@RequestParam(value="ids") List<Long> idList) {
        try {
            Integer count = this.preinstalledApplicationService.delApplicationInstance(idList);
            return ResponseEntityWrapperUtil.wrapperOk((Object)count);
        }
        catch (Exception e) {
            logger.error("del app application instance error. idList:{} ", idList, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

