/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.dto.portal.ReportPageQueryReq;
import com.digiwin.athena.semc.entity.portal.Report;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.service.portal.ReportService;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/report"})
public class ReportController
extends BasicController<ReportService, Report> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportController.class);
    @Resource
    private ESPService espService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private ReportService reportService;

    @PostMapping(value={"/pageQuery"})
    public ResultPageBean pageQueryReport(@Valid @RequestBody ReportPageQueryReq reportPageQueryReq) {
        ResultPageBean resultPageBean;
        log.info("Query report by page param: reportPageQueryReq:{}", (Object)JSON.toJSONString((Object)reportPageQueryReq));
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        try {
            ReportPageQueryReq.EaiSysInfo eaiSysInfo = (ReportPageQueryReq.EaiSysInfo)reportPageQueryReq.getEaiSysInfoList().get(0);
            Map result = this.espService.queryByEsp(eaiSysInfo.getEaiSysName(), eaiSysInfo.getEaiSysUid(), EAIServiceNameEnum.REPORT.getServiceName(), null, null, reportPageQueryReq.getQryCondition(), PageInfo.getPageInfo((Integer)reportPageQueryReq.getPageNum(), (Integer)reportPageQueryReq.getPageSize()));
            if (Objects.nonNull(result.get("report_info_list"))) {
                Integer totalResults = Integer.parseInt(result.get("total_results").toString());
                JSONArray array = JSONArray.fromObject(result.get("report_info_list"));
                ArrayList list = Lists.newArrayList();
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject jsonObject = array.getJSONObject(i);
                    String reportUrl = jsonObject.getString("report_url");
                    jsonObject.put((Object)"report_url", (Object)(reportUrl + (reportUrl.contains("?") ? "&" : "?") + "appToken=" + eaiSysInfo.getAppToken() + "&tenantId=" + tenantId + "&bindMode=" + eaiSysInfo.getUserBindFlag()));
                    list.add(jsonObject);
                }
                resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)list, (PageInfo)PageInfo.getPageInfo((Integer)reportPageQueryReq.getPageNum(), (Integer)reportPageQueryReq.getPageSize(), (Integer)totalResults)));
            } else {
                resultPageBean = ResultPageBean.success(null);
            }
        }
        catch (BizException bizException) {
            return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.ADAPT_SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.report.open-error")));
        }
        catch (Exception e) {
            log.error("Report qryReport exception", (Throwable)e);
            resultPageBean = ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.SYSTEM_ERROR, this.messageUtils.getMessage("error.message.common.system-error")));
        }
        return resultPageBean;
    }

    @PostMapping(value={"/label/pageQueryReport"})
    public ResultPageBean pageQueryLabelReport(@Valid @RequestBody LabelSystemPreReq reportPageQueryReq) {
        ResultPageBean resultPageBean;
        log.info("/label/pageQueryLabelReport Req:{}", (Object)JSON.toJSONString((Object)reportPageQueryReq));
        try {
            resultPageBean = this.reportService.pageQueryReport(reportPageQueryReq);
        }
        catch (Exception e) {
            log.error("pageQueryLabelReport exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/report/label/pageQueryReport");
            resultPageBean = ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.SYSTEM_ERROR, error));
        }
        return resultPageBean;
    }
}

