/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.message.DeleteMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.entity.portal.ThirdTodoConfig;
import com.digiwin.athena.semc.quartz.ThirdTodoPullTaskJob;
import com.digiwin.athena.semc.service.menu.AuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.ThirdTodoConfigService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.SecurityLogUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/third/toDo"})
public class ThirdTodoConfigontroller
extends BasicController<ThirdTodoConfigService, ThirdTodoConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdTodoConfigontroller.class);
    @Resource
    private ThirdTodoConfigService thirdTodoConfigService;
    @Resource
    ThirdTodoPullTaskJob thirdTodoPullTaskJob;
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    private LabelSystemDataService labelSystemDataService;
    @Autowired
    private AuthService authService;

    @PostMapping(value={"/queryToDoConfigPage"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<ThirdTodoConfig>>> queryToDoConfigPage(@RequestBody @Valid QueryThirdMessageConfigReq queryImportRecordReq) {
        try {
            PageInfoResp pageInfoResp = this.thirdTodoConfigService.queryConfigPage(queryImportRecordReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("queryToDoConfigPage error, param:{}", (Object)queryImportRecordReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/toDo/queryToDoConfigPage");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/saveApplication"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveApplication(@RequestBody @Valid ThirdTodoConfig req, HttpServletRequest request) {
        try {
            boolean flag;
            if (!this.authService.hasAuth("third-todo")) {
                SecurityLogUtil.writeSecurityLog((HttpServletRequest)request, (String)JSON.toJSONString((Object)req));
            }
            if (Constants.DataGetTypeEnum.PULL.getFlag().equals(req.getDataGetType())) {
                if (req.getPullPeriod() == null) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the pullPeriod cannot be null");
                }
                if (req.getAppAccessModel() == null) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the appAccessModel cannot be null");
                }
                if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(req.getAppAccessModel())) {
                    if (StringUtils.isBlank((String)req.getMiddleSystemName())) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the middleSystemName cannot be null");
                    }
                    if (StringUtils.isBlank((String)req.getMiddleSystemUid())) {
                        return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the middleSystemUid cannot be null");
                    }
                } else if (StringUtils.isBlank((String)req.getDomain())) {
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the domain cannot be null");
                }
            }
            if (flag = this.thirdTodoConfigService.validConfigExist(req)) {
                String error = this.messageUtils.getMessage("error.message.app.repeat");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            if (req.getId() != null) {
                this.thirdTodoPullTaskJob.deleteJob("ThirdTodoPullTaskJob", "TodoJob_" + req.getId());
            }
            this.thirdTodoConfigService.saveThirdToDo(req);
            if (req.getDataGetType() == 2 && req.getValidStatus() == 1) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", req.getId());
                params.put("appPrimaryId", req.getAppPrimaryId());
                params.put("appSource", req.getAppSource());
                params.put("pullPeriod", req.getPullPeriod());
                params.put("appAccessModel", req.getAppAccessModel());
                params.put("middleSystemName", req.getMiddleSystemName());
                params.put("middleSystemUid", req.getMiddleSystemUid());
                params.put("domain", req.getDomain());
                params.put("tenantsid", AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                Map ssoInfoMap = this.labelSystemDataService.getSSoInfo(Long.valueOf(Long.parseLong(req.getAppPrimaryId())), req.getAppSource());
                if (null != ssoInfoMap && StringUtils.isNotEmpty((String)((String)ssoInfoMap.get("appId")))) {
                    params.put("appId", ssoInfoMap.get("appId"));
                    params.put("appIdCode", ssoInfoMap.get("appIdCode"));
                }
                this.thirdTodoPullTaskJob.addJob(params);
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("saveApplication error:{}", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/toDo/saveApplication");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/updateStatus"})
    public ResponseEntity<BaseResultDTO<Boolean>> updateStatus(@RequestBody ThirdTodoConfig req) {
        try {
            if (null == req.getId()) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"id is Empty");
            }
            if (null == req.getValidStatus()) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"validStatus is Empty");
            }
            QueryWrapper condition = new QueryWrapper();
            condition.eq((Object)"id", (Object)req.getId());
            List toDoConfigList = this.thirdTodoConfigService.getBaseMapper().selectList((Wrapper)condition);
            if (toDoConfigList.size() > 0 && ((ThirdTodoConfig)toDoConfigList.get(0)).getDataGetType() == 2) {
                if (req.getValidStatus() == 0) {
                    this.thirdTodoPullTaskJob.pauseJob("ThirdTodoPullTaskJob", "TodoJob_" + req.getId());
                }
                if (req.getValidStatus() == 1) {
                    this.thirdTodoPullTaskJob.resumeJob("ThirdTodoPullTaskJob", "TodoJob_" + req.getId());
                }
            }
            ThirdTodoConfig todoConfig = (ThirdTodoConfig)this.thirdTodoConfigService.getById((Serializable)req.getId());
            todoConfig.setValidStatus(req.getValidStatus());
            this.thirdTodoConfigService.saveThirdToDo(todoConfig);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("updateStatus error:{}", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/toDo/updateStatus");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/delToDoConfig"})
    public ResponseEntity<BaseResultDTO<Boolean>> delToDoConfig(@RequestBody DeleteMessageConfigReq deleteMessageConfigReq) {
        try {
            if (CollectionUtils.isEmpty((Collection)deleteMessageConfigReq.getIdList())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)"idList is not empty");
            }
            QueryWrapper condition = new QueryWrapper();
            condition.in((Object)"id", (Collection)deleteMessageConfigReq.getIdList());
            condition.eq((Object)"valid_status", (Object)Constants.VALID_STATUS_ENABLE);
            List toDoConfigList = this.thirdTodoConfigService.getBaseMapper().selectList((Wrapper)condition);
            if (CollectionUtils.isNotEmpty((Collection)toDoConfigList)) {
                String error = this.messageUtils.getMessage("error.message.app.enable.del");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            List idList = deleteMessageConfigReq.getIdList();
            for (Long id : idList) {
                this.thirdTodoPullTaskJob.deleteJob("ThirdTodoPullTaskJob", "TodoJob_" + id);
            }
            this.thirdTodoConfigService.delThirdToDo(deleteMessageConfigReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("delToDoConfig error. e:{}", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/third/toDo/delToDoConfig");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

