/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.dto.portal.PreSystemToDoCountReq;
import com.digiwin.athena.semc.dto.portal.PreSystemToDoReq;
import com.digiwin.athena.semc.dto.portal.PreSystemToDoSearchAppReq;
import com.digiwin.athena.semc.dto.portal.PreSystemToDoUpdateReq;
import com.digiwin.athena.semc.dto.portal.ReimburseReq;
import com.digiwin.athena.semc.dto.portal.TodoCountResp;
import com.digiwin.athena.semc.dto.portal.TodoListReq;
import com.digiwin.athena.semc.dto.portal.TodoListResp;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.LabelSystemSourceService;
import com.digiwin.athena.semc.service.portal.TodoAppSortService;
import com.digiwin.athena.semc.service.portal.TodoListService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/todoList"})
public class TodoListController
extends BasicController<TodoListService, TodoList> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TodoListController.class);
    @Resource
    private TodoListService todoListService;
    @Autowired
    LabelSystemSourceService labelSystemSourceService;
    @Autowired
    LabelSystemDataService labelSystemDataService;
    @Resource
    private ESPService espService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private TodoAppSortService todoAppSortService;

    @PostMapping(value={"/queryTodoListTest"})
    public ResponseEntity<BaseResultDTO<Map<String, Object>>> queryTodoListTest(@RequestBody TodoListReq.EaiSys todoListReq) {
        String qryCondition = "";
        Map resultMap = new HashMap();
        TodoListResp todoListResp = new TodoListResp();
        try {
            HashMap<String, String> extHeader = new HashMap<String, String>();
            extHeader.put("digi-userToken", Utils.getUserToken());
            extHeader.put("digi-appToken", this.envProperties.getAppToken());
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("page_no", 1);
            parameter.put("page_size", 100);
            parameter.put("tenant_id", Utils.getTenantId());
            Map result = this.espService.queryByEsp(todoListReq.getEaiSysName(), todoListReq.getEaiSysUid(), "to.do.list.query", extHeader, parameter, qryCondition, null);
            if (Objects.isNull(result.get("display_field_list"))) {
                log.error(this.messageUtils.getMessage("error.message.todo.field-missing-error"));
                todoListResp.setResultCode("3001");
            }
            resultMap = result;
        }
        catch (RuntimeException bizException) {
            log.error("TodoList handleEspResult exception", (Throwable)bizException);
            todoListResp.setResultCode("3001");
        }
        catch (Exception e) {
            log.error("TodoList query exception", (Throwable)e);
            todoListResp.setResultCode("3001");
        }
        return ResponseEntityWrapperUtil.wrapperOk(resultMap);
    }

    @PostMapping(value={"/queryTodoList"})
    public ResponseEntity<BaseResultDTO<Map<String, Object>>> queryTodoList(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user, @Valid @RequestBody TodoListReq todoListReq) {
        log.info("Query todo list param: todoListReq:{}", (Object)JSON.toJSONString((Object)todoListReq));
        HashMap resultMap = new HashMap();
        todoListReq.getEaiSysList().stream().forEach(eaiSys -> {
            TodoListResp todoListResp = new TodoListResp();
            try {
                HashMap<String, String> extHeader = new HashMap<String, String>();
                extHeader.put("digi-userToken", user.getToken());
                extHeader.put("digi-appToken", StringUtils.isBlank((CharSequence)eaiSys.getAppToken()) ? this.envProperties.getAppToken() : eaiSys.getAppToken());
                Map result = this.espService.queryByEsp(eaiSys.getEaiSysName(), eaiSys.getEaiSysUid(), EAIServiceNameEnum.TODOLIST.getServiceName(), extHeader, null, todoListReq.getQryCondition(), null);
                if (Objects.isNull(result.get("display_field_list"))) {
                    log.error(this.messageUtils.getMessage("error.message.todo.field-missing-error"));
                    todoListResp.setResultCode("3001");
                }
                todoListResp = this.todoListService.handleEspResult(user, eaiSys, result, todoListReq.getQryCondition(), null);
            }
            catch (RuntimeException bizException) {
                log.error("TodoList handleEspResult exception", (Throwable)bizException);
                todoListResp.setResultCode("3001");
            }
            catch (Exception e) {
                log.error("TodoList query exception", (Throwable)e);
                todoListResp.setResultCode("3001");
            }
            resultMap.put(eaiSys.getEaiSysName(), todoListResp);
        });
        return ResponseEntityWrapperUtil.wrapperOk(resultMap);
    }

    @PostMapping(value={"/label/pageQueryTodo"})
    public ResultPageBean pageQueryTodo(@Valid @RequestBody LabelSystemPreReq todoListReq) {
        log.info("pageQueryTodo:{}", (Object)JSON.toJSONString((Object)todoListReq));
        TodoListResp todoListResp = new TodoListResp();
        try {
            todoListResp = this.todoListService.pageQueryTodo(todoListReq);
        }
        catch (Exception e) {
            log.error("pageQueryTodo query exception", (Throwable)e);
            todoListResp.setResultCode("3001");
        }
        return ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)todoListResp, (PageInfo)PageInfo.getPageInfo((Integer)todoListReq.getPageNum(), (Integer)todoListReq.getPageSize(), (Integer)todoListResp.getTotalResults())));
    }

    @PostMapping(value={"/todo/selectTodoList"})
    public ResultPageBean selectTodoList(@Valid @RequestBody PreSystemToDoReq todoListReq) {
        log.info("selectTodoList:{}", (Object)JSON.toJSONString((Object)todoListReq));
        TodoListResp todoListResp = new TodoListResp();
        try {
            todoListResp = this.todoListService.selectTodoList(todoListReq);
        }
        catch (Exception e) {
            log.error("selectTodoList query exception", (Throwable)e);
            todoListResp.setResultCode("3001");
        }
        return ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)todoListResp, (PageInfo)PageInfo.getPageInfo((Integer)todoListReq.getPageNum(), (Integer)todoListReq.getPageSize(), (Integer)todoListResp.getTotalResults())));
    }

    @Operation(method="getTodoListUrl", description="\u83b7\u53d6\u8df3\u8f6curl")
    @PostMapping(value={"/getTodoListUrl"})
    public ResponseEntity<?> getTodoListUrl(@RequestBody @Valid ReimburseReq reimburseReq) {
        return this.todoListService.getTodoListUrl(reimburseReq);
    }

    @GetMapping(value={"/queryToDoCount"})
    public ResponseEntity<BaseResultDTO<JSONObject>> queryToDoCount() {
        try {
            JSONObject jsonObject = new JSONObject();
            List dataIds = this.labelSystemSourceService.selectPreSystem(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal(), Constants.LabelTypeEnum.SYSTEM_PRE.getVal());
            List systemDataList = this.labelSystemDataService.queryDataInfoBy(dataIds, Boolean.valueOf(false));
            if (CollectionUtils.isEmpty((Collection)systemDataList)) {
                jsonObject.put("toDoCount", (Object)0);
                jsonObject.put("unReadCount", (Object)0);
                return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
            }
            jsonObject = this.todoListService.queryToDoCount(systemDataList);
            return ResponseEntityWrapperUtil.wrapperOk((Object)jsonObject);
        }
        catch (Exception e) {
            log.error("query to do count error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/todoList/queryToDoCount");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/todo/syncThirdTodoData"})
    public ResponseEntity<?> syncThirdTodoData(@Valid @RequestBody PreSystemToDoUpdateReq req) {
        return this.todoListService.syncThirdTodoData(req);
    }

    @PostMapping(value={"/todo/saveAppSort"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveAppSort(@RequestBody List<String> req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.todoAppSortService.save(req));
    }

    @PostMapping(value={"/todo/selectTodoCount"})
    public ResponseEntity<BaseResultDTO<TodoCountResp>> selectTodoCount(@Valid @RequestBody PreSystemToDoCountReq req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.todoListService.selectTodoCount(req));
    }

    @PostMapping(value={"/todo/searchApp"})
    public ResponseEntity<BaseResultDTO<List<LabelSystemData>>> searchTodoApp(@Valid @RequestBody PreSystemToDoSearchAppReq req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.todoListService.searchTodoApp(req));
    }
}

