/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.entity.portal.TodosRefreshSet;
import com.digiwin.athena.semc.service.portal.TodosRefreshSetService;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/todo"})
public class TodosRefreshSetController {
    private static final Logger logger = LoggerFactory.getLogger(TodosRefreshSetController.class);
    @Resource
    private TodosRefreshSetService todosRefreshSetService;

    @PostMapping(value={"/refreshSet"})
    public ResultBean refreshSet(@RequestBody TodosRefreshSet req) {
        logger.info("refreshSet param:{},appName:{}", (Object)JSON.toJSONString((Object)req));
        ResultBean resultBean = new ResultBean();
        try {
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            req.setTenantId(tenantId);
            String userName = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
            req.setCreateUserId(userName);
            req.setModifyUserId(userName);
            this.todosRefreshSetService.saveRefreshSet(req);
            return resultBean;
        }
        catch (Exception e) {
            logger.error("/refreshSet  error req:{},e:{}", (Object)JSON.toJSONString((Object)req), (Object)e);
            return resultBean;
        }
    }

    @PostMapping(value={"/getRefresh"})
    public ResultBean getRefresh() {
        ResultBean resultBean = new ResultBean();
        try {
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            if (StringUtils.isEmpty((String)tenantId)) {
                return resultBean;
            }
            TodosRefreshSet refreshSet = this.todosRefreshSetService.getRefreshSet(tenantId);
            if (null == refreshSet) {
                refreshSet = new TodosRefreshSet();
                refreshSet.setTabsTime(Constants.TABS_TIME_DEF);
                refreshSet.setTodoDetailTime(Constants.TABS_TIME_DEF);
                refreshSet.setIsOpen(Constants.TABS_IS_OPEN);
            }
            resultBean.setResponse((Object)refreshSet);
            return resultBean;
        }
        catch (Exception e) {
            logger.error("/getRefresh  error:{}", (Throwable)e);
            return resultBean;
        }
    }
}

