/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.portal;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.dto.portal.ActionFunctionResp;
import com.digiwin.athena.semc.service.portal.IUserActionService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/action"})
public class UserActionController {
    private static final Logger logger = LoggerFactory.getLogger(UserActionController.class);
    @Autowired
    IUserActionService userActionService;

    @Operation(summary="\u67e5\u8be2\u7528\u6237\u884c\u4e3a\u5bf9\u5e94\u7684\u529f\u80fd\u5217\u8868")
    @GetMapping(value={"/function/query"})
    public ResponseEntity<BaseResultDTO<List<ActionFunctionResp>>> queryUserActionFunction(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        try {
            List functionRespList = this.userActionService.queryUserFunctionList(authoredUser);
            return ResponseEntityWrapperUtil.wrapperOk((Object)functionRespList);
        }
        catch (Exception e) {
            logger.error("query user action-function error. userId: {}", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId(), (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)e.getMessage());
        }
    }
}

