/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.router;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.erpsso.AuthorizeDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.util.HttpRequestDeviceUtils;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/semc/router"})
public class RoutingAddressController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoutingAddressController.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    @Autowired
    private AppLinkService appLinkService;
    @Resource
    private IamService iamService;
    private static final String WE_COM = "weCom";
    private static final String SOURCE_TYPE = "enterprise_Wechat";
    private static final String RESPONSE_TYPE = "token";
    private static final String MOBILE_SSO_PATH = "/mobile/v1/sso/grantOauthAccess";
    private static final String PC_SSO_PATH = "/api/iam/v2/identity/oauth/token/access";
    private static final String REDIRECT_URL_TEMPLATE = "%s/sso-login?userToken=%s&routerLink=/entrance/third-login&proxyToken=%s&taskId=%s&dwLang=%s";
    private static final String REDIRECT_URL_TEMPLATE_HOME = "%s/sso-login?userToken=%s&routerLink=/&dwLang=%s";
    private static final String HOME_PAGE_REDIRECT_TEMPLATE = "%s";

    @Operation(method="routingDistribution", description="\u8def\u7531\u5206\u53d1")
    @GetMapping(value={"/routingDistribution"})
    public ResponseEntity<?> routingJudgment(HttpServletRequest request, @RequestParam(value="code") String code, @RequestParam(value="taskId") String taskId, @RequestParam(value="appId") String appId, @RequestParam(value="tenantId") String tenantId, HttpServletResponse response) throws IOException {
        if (HttpRequestDeviceUtils.isMobileDevice((HttpServletRequest)request)) {
            String url = this.handleMobileTask(code, tenantId, appId, taskId);
            response.sendRedirect(url);
        } else {
            this.handlePcLogin(request, code, tenantId, appId, taskId, response);
        }
        return null;
    }

    @Operation(method="enterpriseWeChatLogin", description="\u4f01\u5fae\u8df3\u8f6c")
    @GetMapping(value={"/enterpriseWeChatLogin"})
    public ResponseEntity<?> routingToHomepage(HttpServletRequest request, @RequestParam(value="appId") String appId, @RequestParam(value="code") String code, @RequestParam(value="tenantId") String tenantId, HttpServletResponse response) throws IOException {
        if (HttpRequestDeviceUtils.isMobileDevice((HttpServletRequest)request)) {
            String url = this.handleMobileLogin(code, tenantId, appId);
            response.sendRedirect(url);
        } else {
            this.handlePcLoginHomePage(request, code, tenantId, response, appId);
        }
        return null;
    }

    private String handleMobileTask(String code, String tenantId, String appId, String taskId) {
        String url = String.format("%s%s?code=%s&tenantId=%s&appId=%s&taskId=%s&targetTenantId=%s&sourceType=%s&isHideAppBar=false&canBack=false", this.envProperties.getMobileUrl(), MOBILE_SSO_PATH, code, tenantId, appId, taskId, tenantId, SOURCE_TYPE);
        ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.GET, null, JSONObject.class, new Object[0]);
        JSONObject data = ((JSONObject)exchange.getBody()).getJSONObject("data");
        return data.getString("data");
    }

    private String handleMobileLogin(String code, String tenantId, String appId) {
        String url = String.format("%s%s?code=%s&tenantId=%s&appId=%s&sourceType=%s&isHideAppBar=false", this.envProperties.getMobileUrl(), MOBILE_SSO_PATH, code, tenantId, appId, SOURCE_TYPE);
        ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.GET, null, JSONObject.class, new Object[0]);
        JSONObject data = ((JSONObject)exchange.getBody()).getJSONObject("data");
        return data.getString("data");
    }

    private ResponseEntity<?> handlePcLogin(HttpServletRequest request, String code, String tenantId, String appId, String taskId, HttpServletResponse response) throws IOException {
        String token;
        ResponseEntity respEntity = this.getJsonObjectResponseEntity(code, tenantId, appId);
        if (respEntity.getStatusCode() == HttpStatus.OK && respEntity.getBody() != null && StringUtils.isNotEmpty((String)(token = ((JSONObject)respEntity.getBody()).getString(RESPONSE_TYPE)))) {
            String redirectUrl = String.format(REDIRECT_URL_TEMPLATE, this.envProperties.getHomePageUrl(), token, "", taskId, request.getLocale());
            response.sendRedirect(redirectUrl);
            log.info("Authorization successful, redirecting to details.");
            return null;
        }
        this.redirectToHomePage(response);
        return null;
    }

    private ResponseEntity<JSONObject> getJsonObjectResponseEntity(String code, String tenantId, String appId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("code", code);
        requestMap.put("oauthType", WE_COM);
        requestMap.put("appId", appId);
        String url = this.envProperties.getIamUri() + PC_SSO_PATH;
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
        }
        catch (RestClientException e) {
            log.error("Failed to call IAM API: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
        return respEntity;
    }

    private void redirectToHomePage(HttpServletResponse response) throws IOException {
        String homePageUrl = String.format(HOME_PAGE_REDIRECT_TEMPLATE, this.envProperties.getHomePageUrl());
        response.sendRedirect(homePageUrl);
        log.info("Authorization failed, redirecting to home page.");
    }

    private ResponseEntity<?> handlePcLoginHomePage(HttpServletRequest request, String code, String tenantId, HttpServletResponse response, String appId) throws IOException {
        String token;
        ResponseEntity respEntity = this.getJsonObjectResponseEntity(code, tenantId, appId);
        if (respEntity.getStatusCode() == HttpStatus.OK && respEntity.getBody() != null && StringUtils.isNotEmpty((String)(token = ((JSONObject)respEntity.getBody()).getString(RESPONSE_TYPE)))) {
            String redirectUrl = String.format(REDIRECT_URL_TEMPLATE_HOME, this.envProperties.getHomePageUrl(), token, request.getLocale());
            response.sendRedirect(redirectUrl);
            log.info("Authorization to Homepage successful, redirecting to details.");
            return null;
        }
        this.redirectToHomePage(response);
        return null;
    }

    @Operation(method="thirdMessageRouting", description="\u8def\u7531\u5206\u53d1")
    @GetMapping(value={"/thirdMessageRouting"})
    public ResponseEntity<?> thirdMessageRouting(HttpServletRequest request, @RequestParam(value="code") String code, @RequestParam(value="appId") String appId, @RequestParam(value="tenantId") String tenantId, @RequestParam(value="messageAppCode") String messageAppCode, @RequestParam(value="messageUrl") String messageUrl, @RequestParam(value="mobileMessageUrl") String mobileMessageUrl, HttpServletResponse response) throws Exception {
        log.info("thirdMessageRouting routing param. code:{}, appId:{}, tenantId:{}, messageAppCode:{}", new Object[]{code, appId, tenantId, messageAppCode});
        String callbackUrl = StringUtils.isNotBlank((String)messageUrl) ? messageUrl : mobileMessageUrl;
        ResponseEntity respEntity = this.getJsonObjectResponseEntity(code, tenantId, appId);
        if (respEntity.getStatusCode() == HttpStatus.OK && respEntity.getBody() != null) {
            String userToken = ((JSONObject)respEntity.getBody()).getString(RESPONSE_TYPE);
            if (StringUtils.isEmpty((String)userToken)) {
                log.error("thirdMessageRouting query user token return empty. code:{}, tenantId:{}, appId:{}", new Object[]{code, tenantId, appId});
                return null;
            }
            AuthoredUser authoredUser = new AuthoredUser();
            authoredUser.setToken(userToken);
            authoredUser.setTenantId(tenantId);
            AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
            List appLinkDTOList = this.appLinkService.queryManageListSync(AppAuthContextHolder.getContext().getAuthoredUser());
            AppLinkDTO appLinkDTO = appLinkDTOList.stream().filter(x -> x.getCode().equals(messageAppCode)).findFirst().orElse(null);
            if (ObjectUtil.isNull((Object)appLinkDTO)) {
                log.error("thirdMessageRouting query appInfo return empty. userToken:{}, tenantId:{}", (Object)userToken, (Object)tenantId);
                return null;
            }
            String redirectUrl = this.appLinkService.parseJumpUrl(callbackUrl, appLinkDTO);
            AuthorizeDTO authorizeDTO = this.iamService.queryAuthorizeInfo(appLinkDTO.getApplicationAppId(), appLinkDTO.getCallBackUrl());
            if (ObjectUtil.isNotEmpty((Object)authorizeDTO)) {
                redirectUrl = redirectUrl + "&code=" + authorizeDTO.getCode();
            }
            log.info("thirdMessageRouting sso redirect url:{}", (Object)redirectUrl);
            response.sendRedirect(redirectUrl);
        }
        log.info("thirdMessageRouting redirect url:{}", (Object)callbackUrl);
        response.sendRedirect(callbackUrl);
        return null;
    }
}

