/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.sso;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.PreinstalledApplicationTypeEnum;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.erpsso.AddSsoInfoReq;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.dto.erpsso.RegisterDTO;
import com.digiwin.athena.semc.dto.erpsso.SsoBindReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkGroupDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkListDTO;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.message.ThirdSystemMessageService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.portal.AppExistVO;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@Tag(name="\u7a33\u6001\u5355\u70b9\u767b\u5f55\u7ba1\u7406")
@RestController
@RequestMapping(value={"/tenant/erpSsoInfo"})
public class ErpSsoInfoController
extends BasicController<IErpSsoInfoService, ErpSsoInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErpSsoInfoController.class);
    private static final Logger logger = LoggerFactory.getLogger(ErpSsoInfoController.class);
    @Autowired
    IErpSsoInfoService erpSsoInfoService;
    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;
    @Resource
    private IamService iamService;
    @Autowired
    private AppLinkService appLinkService;
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    LabelSystemDataService labelSystemDataService;
    @Resource
    private ThirdSystemMessageService thirdSystemMessageService;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;

    @Operation(summary="\u6839\u636e\u79df\u6237id\u67e5\u8be2\u7a33\u6001\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/listByTenantId"})
    public ResponseEntity<BaseResultDTO<List<ErpSsoInfo>>> querySsoInfoList(@RequestParam(required=false, value="protocolType") Integer protocolType) {
        try {
            String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
            List ssoInfoList = this.erpSsoInfoService.querySsoList(tenantId, protocolType);
            return ResponseEntityWrapperUtil.wrapperOk((Object)ssoInfoList);
        }
        catch (Exception e) {
            log.error("ErpSsoInfoController query sso info list error", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Operation(summary="\u4fdd\u5b58\u7a33\u6001\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"/saveErpInfo"})
    public ResponseEntity<BaseResultDTO<ErpSsoInfo>> saveErpSsoInfo(@RequestBody @Valid AddSsoInfoReq addSsoInfoReq) throws Exception {
        ErpSsoInfoController.logger.info("save erp sso | param:[" + addSsoInfoReq + "]");
        if (this.dynamicParamValid(addSsoInfoReq)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.dynamic.param.illegal"));
        }
        erpSsoInfoList = this.erpSsoInfoService.existByNameOrAppToken(addSsoInfoReq.getId(), addSsoInfoReq.getCode(), addSsoInfoReq.getName(), addSsoInfoReq.getAppToken());
        if (CollectionUtils.isNotEmpty((Collection)erpSsoInfoList)) {
            if (addSsoInfoReq.getCode().equals(((ErpSsoInfo)erpSsoInfoList.get(0)).getCode())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.appcode.repeat"));
            }
            if (addSsoInfoReq.getName().equals(((ErpSsoInfo)erpSsoInfoList.get(0)).getName())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.appname.repeat"));
            }
            if (StringUtils.isNotBlank((CharSequence)addSsoInfoReq.getAppToken()) && addSsoInfoReq.getAppToken().equals(((ErpSsoInfo)erpSsoInfoList.get(0)).getAppToken())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.apptoken.repeat"));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(thirdSsoInfoList = this.thirdSsoInfoService.existThirdSso(null, addSsoInfoReq.getCode(), addSsoInfoReq.getName(), addSsoInfoReq.getAppToken())))) {
            if (addSsoInfoReq.getCode().equals(((ThirdSsoInfo)thirdSsoInfoList.get(0)).getAppCode())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.bs.appcode.repeat"));
            }
            if (addSsoInfoReq.getName().equals(((ThirdSsoInfo)thirdSsoInfoList.get(0)).getAppName())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.bs.appname.repeat"));
            }
            if (StringUtils.isNotBlank((CharSequence)addSsoInfoReq.getAppToken()) && addSsoInfoReq.getAppToken().equals(((ThirdSsoInfo)thirdSsoInfoList.get(0)).getAppToken())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.bs.apptoken.repeat"));
            }
        }
        applicationList = this.preinstalledApplicationService.queryPreinstalledAppList(AppAuthContextHolder.getContext().getAuthoredUser());
        for (PreinstalledApplication application : applicationList) {
            if (!application.getApplicationName().equals(addSsoInfoReq.getName())) continue;
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.pre.appname.repeat"));
        }
        erpSsoInfo = new ErpSsoInfo();
        updateFlag = Boolean.FALSE;
        if (addSsoInfoReq.getId() != null) {
            erpSsoInfo = this.erpSsoInfoService.querySsoInfo(addSsoInfoReq.getId());
            if (erpSsoInfo == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.app.query.not.found"));
            }
            if (!erpSsoInfo.getCode().equals(addSsoInfoReq.getCode())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.appCode.change"));
            }
            if (Constants.BindFlagEnum.AUTO.getFlag().equals(addSsoInfoReq.getUserBindFlag()) || Constants.BindFlagEnum.HAND.getFlag().equals(addSsoInfoReq.getUserBindFlag())) {
                registerReq = new RegisterDTO();
                try {
                    if (erpSsoInfo.getAppSid() == null) {
                        this.registerCsApp(addSsoInfoReq);
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)erpSsoInfo.getCode(), (CharSequence)addSsoInfoReq.getCode()) && StringUtils.equalsIgnoreCase((CharSequence)erpSsoInfo.getAppDesc(), (CharSequence)addSsoInfoReq.getDesc())) ** GOTO lbl54
                    registerReq = this.buildRegisterReq(erpSsoInfo.getAppSid(), addSsoInfoReq.getCode(), addSsoInfoReq.getName(), addSsoInfoReq.getDesc(), addSsoInfoReq.getAppToken());
                    this.iamService.updateAppInfoForIAM(registerReq);
                    updateFlag = Boolean.TRUE;
                }
                catch (Exception e) {
                    ErpSsoInfoController.logger.error("ErpSsoInfoController saveErpInfo invoke iam error error, registerReq:{}, AddSsoInfoReq:{}", new Object[]{registerReq, addSsoInfoReq, e});
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.ADAPT_SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
                }
            }
        } else if (Constants.BindFlagEnum.AUTO.getFlag().equals(addSsoInfoReq.getUserBindFlag()) || Constants.BindFlagEnum.HAND.getFlag().equals(addSsoInfoReq.getUserBindFlag())) {
            try {
                this.registerCsApp(addSsoInfoReq);
            }
            catch (Exception e) {
                ErpSsoInfoController.logger.error("ErpSsoInfoController saveErpInfo invoke iam error error, addSsoInfoReq:{}", (Object)addSsoInfoReq, (Object)e);
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.ADAPT_SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
            }
        }
lbl54:
        // 7 sources

        try {
            ssoInfoId = this.erpSsoInfoService.saveOrUpdateSsoInfo(addSsoInfoReq);
            erpSsoInfoResp = this.erpSsoInfoService.querySsoInfo(ssoInfoId);
            if (Constants.BindFlagEnum.NO.getFlag().equals(addSsoInfoReq.getUserBindFlag()) || Constants.BindFlagEnum.OUTSIDE.getFlag().equals(addSsoInfoReq.getUserBindFlag())) {
                erpSsoInfoResp.setAppId("");
                erpSsoInfoResp.setAppSecret("");
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)erpSsoInfoResp);
        }
        catch (Exception e) {
            if (updateFlag) {
                registerReq = this.buildRegisterReq(erpSsoInfo.getAppSid(), erpSsoInfo.getCode(), erpSsoInfo.getName(), erpSsoInfo.getAppDesc(), erpSsoInfo.getAppToken());
                this.iamService.updateAppInfoForIAM(registerReq);
            }
            ErpSsoInfoController.logger.info("ErpSsoInfoController save erp sso occur error. addSsoInfoReq:{}", (Object)addSsoInfoReq, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    private boolean dynamicParamValid(AddSsoInfoReq addSsoInfoReq) {
        String dynamicParam = addSsoInfoReq.getExt();
        if (StringUtils.isNotBlank((CharSequence)dynamicParam)) {
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)dynamicParam);
                if (jsonObject.isEmpty()) {
                    return true;
                }
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    private void registerCsApp(AddSsoInfoReq addSsoInfoReq) throws Exception {
        RegisterDTO registerReq = this.buildRegisterReq(null, addSsoInfoReq.getCode(), addSsoInfoReq.getName(), addSsoInfoReq.getDesc(), addSsoInfoReq.getAppToken());
        RegisterDTO registerResp = this.thirdSsoInfoService.registerApp(registerReq);
        addSsoInfoReq.setAppSid(registerResp.getSid());
        addSsoInfoReq.setAppId(registerResp.getId());
        addSsoInfoReq.setAppSecret(registerResp.getSecret());
    }

    private RegisterDTO buildRegisterReq(Long appSid, String code, String name, String desc, String appToken) {
        RegisterDTO registerReq = new RegisterDTO();
        registerReq.setSid(appSid);
        registerReq.setName(code);
        registerReq.setDescription(desc);
        registerReq.setAppToken(appToken);
        registerReq.setCallbackUrl(String.format("http://www.%s.com", code));
        return registerReq;
    }

    @Operation(summary="\u4fee\u6539\u751f\u6548\u72b6\u6001")
    @GetMapping(value={"/updateStatus"})
    public ResponseEntity<BaseResultDTO<Boolean>> editSsoValidateStatus(@RequestParam(value="ssoInfoId") Long ssoInfoId, @RequestParam(value="status") Integer status) {
        try {
            List systemDataList;
            if (ssoInfoId == null || status == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
            }
            ErpSsoInfo erpSsoInfo = this.erpSsoInfoService.querySsoInfo(ssoInfoId);
            if (erpSsoInfo == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.app.query.not.found"));
            }
            if (status == 0 && CollectionUtils.isNotEmpty((Collection)(systemDataList = this.labelSystemDataService.getDataNameList(Integer.valueOf(Integer.parseInt(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue())), ssoInfoId + "")))) {
                String dataNames = systemDataList.stream().collect(Collectors.joining("\u3001"));
                String error = String.format(this.messageUtils.getMessage("error.message.system.sso.erp.fail"), dataNames);
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            int ssoId = this.erpSsoInfoService.updateSsoStatus(ssoInfoId, status);
            return ResponseEntityWrapperUtil.wrapperOk((Object)(ssoId > 0 ? Boolean.TRUE : Boolean.FALSE));
        }
        catch (Exception e) {
            logger.info("ErpSsoInfoController update c/s app status error. ssoInfoId:{}, status:{}", new Object[]{ssoInfoId, status, e});
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u5220\u9664\u914d\u7f6e")
    @GetMapping(value={"/deleteById"})
    @Transactional
    public ResponseEntity<BaseResultDTO<Boolean>> deleteSsoInfo(@RequestParam(value="ssoInfoId") Long ssoInfoId) throws Exception {
        try {
            if (ssoInfoId == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
            }
            ErpSsoInfo erpSsoInfo = this.erpSsoInfoService.querySsoInfo(ssoInfoId);
            if (erpSsoInfo == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.app.query.not.found"));
            }
            if (Constants.VALID_STATUS_ENABLE.equals(erpSsoInfo.getValidStatus())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.config.in.effect"));
            }
            List systemDataList = this.labelSystemDataService.getDataNameList(Integer.valueOf(Integer.parseInt(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue())), ssoInfoId + "");
            if (CollectionUtils.isNotEmpty((Collection)systemDataList)) {
                String dataNames = systemDataList.stream().collect(Collectors.joining("\u3001"));
                String error = String.format(this.messageUtils.getMessage("error.message.system.sso.erp.delfail"), dataNames);
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            QueryThirdMessageConfigReq queryImportRecordReq = new QueryThirdMessageConfigReq();
            queryImportRecordReq.setAppPrimaryId(String.valueOf(ssoInfoId));
            queryImportRecordReq.setAppSource(ApplicationTypeEnum.CS_APPLICATION.getType());
            PageInfoResp thirdMessageConfigPageInfoResp = this.thirdSystemMessageService.queryMessageConfigPage(queryImportRecordReq);
            if (CollectionUtils.isNotEmpty((Collection)thirdMessageConfigPageInfoResp.getList())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.system.sso.del.fail"));
            }
            Boolean flag = this.erpSsoInfoService.removeById((Serializable)ssoInfoId);
            this.erpSsoInfoService.deleteErpSsoParams(ssoInfoId);
            return ResponseEntityWrapperUtil.wrapperOk((Object)flag);
        }
        catch (Exception e) {
            logger.info("ErpSsoInfoController delete c/s app error. ssoInfoId:{}", (Object)ssoInfoId, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u6839\u636e\u5e94\u7528\u540d\u79f0\u67e5\u8be2\u5e94\u7528\u4fe1\u606f")
    @PostMapping(value={"/queryByName"})
    public ResponseEntity<BaseResultDTO<AppLinkDTO>> querySsoInfoByName(@RequestBody QuerySsoListReq querySsoListReq) {
        if (CollectionUtils.isEmpty((Collection)querySsoListReq.getAppNameList())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
        }
        try {
            String appName;
            AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
            AppLinkListDTO appLinkListDTO = this.appLinkService.queryLinkList(user);
            List appLinkList = appLinkListDTO.getAll();
            ArrayList allAppLinkList = Lists.newArrayList();
            for (AppLinkGroupDTO appLinkGroupDTO : appLinkList) {
                List linkList = appLinkGroupDTO.getLinks();
                allAppLinkList.addAll(linkList);
            }
            if (CollectionUtils.isEmpty((Collection)allAppLinkList)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)this.messageUtils.getMessage("error.message.query.not-found"));
            }
            Map appNameMap = allAppLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getName, Function.identity(), (a, b) -> a));
            AppLinkDTO appLinkDTO = null;
            Iterator iterator = querySsoListReq.getAppNameList().iterator();
            while (iterator.hasNext() && (appLinkDTO = (AppLinkDTO)appNameMap.get(appName = (String)iterator.next())) == null) {
            }
            if (appLinkDTO == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)this.messageUtils.getMessage("error.message.query.not-found"));
            }
            return ResponseEntityWrapperUtil.wrapperOk(appLinkDTO);
        }
        catch (Exception e) {
            log.error("ErpSsoInfoController query app by name occur error", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.query.error"));
        }
    }

    @Operation(summary="\u8bbe\u7f6e\u5f52\u6237\u6a21\u5f0f")
    @PostMapping(value={"/updateBindFlag"})
    public ResponseEntity<BaseResultDTO<Boolean>> updateBindFlag(@RequestBody SsoBindReq ssoBindReq) throws Exception {
        try {
            if (CollectionUtils.isEmpty((Collection)ssoBindReq.getIdList()) || ssoBindReq.getBindFlag() == null || ssoBindReq.getAppType() == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
            }
            if (!Arrays.asList(Constants.BindFlagEnum.AUTO.getFlag(), Constants.BindFlagEnum.HAND.getFlag(), Constants.BindFlagEnum.NO.getFlag()).contains(ssoBindReq.getBindFlag())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
            }
            QuerySsoListReq querySsoListReq = new QuerySsoListReq();
            querySsoListReq.setIdList(ssoBindReq.getIdList());
            if (PreinstalledApplicationTypeEnum.CS_APPLICATION.getType().equals(String.valueOf(ssoBindReq.getAppType()))) {
                List erpSsoInfoList = this.erpSsoInfoService.querySsoListByScope(querySsoListReq);
                for (ErpSsoInfo erpSsoInfo : erpSsoInfoList) {
                    if (!Objects.equals(erpSsoInfo.getValidStatus(), Constants.VALID_STATUS_ENABLE)) continue;
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.bindMode.in.effect"));
                }
                this.erpSsoInfoService.updateBindFlag(ssoBindReq.getIdList(), ssoBindReq.getBindFlag());
            } else if (PreinstalledApplicationTypeEnum.BS_APPLICATION.getType().equals(String.valueOf(ssoBindReq.getAppType()))) {
                List thirdSsoInfoList = this.thirdSsoInfoService.queryThirdListByScope(querySsoListReq);
                for (ThirdSsoInfo thirdSsoInfo : thirdSsoInfoList) {
                    if (!Objects.equals(thirdSsoInfo.getValidStatus(), Constants.VALID_STATUS_ENABLE)) continue;
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.bindMode.in.effect"));
                }
                this.thirdSsoInfoService.updateBindFlag(ssoBindReq.getIdList(), ssoBindReq.getBindFlag());
            } else {
                List applicationList = this.preinstalledApplicationService.queryPreinstalledApplicationList(ssoBindReq.getIdList());
                for (PreinstalledApplication application : applicationList) {
                    if (!PreinstalledApplicationTypeEnum.SPECIAL_APPLICATION.getType().equals(application.getApplicationType())) continue;
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.contain.special.application"));
                }
                this.preinstalledApplicationService.updateAppInfo(ssoBindReq.getIdList(), ssoBindReq.getBindFlag(), null);
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("ErpSsoInfoController update bind flag error, ssoBindReq:{}", (Object)ssoBindReq, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/queryAppListExistAppToken"})
    public ResponseEntity<BaseResultDTO<List<AppExistVO.AppDTO>>> queryAppListExistAppToken() {
        try {
            List list = this.iamService.queryAppListExistAppToken();
            return ResponseEntityWrapperUtil.wrapperOk((Object)list);
        }
        catch (Exception e) {
            log.error("query appList exist appToken error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/tenant/erpSsoInfo/queryAppListExistAppToken, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @GetMapping(value={"/queryAppTokenBySid"})
    public ResponseEntity<BaseResultDTO<Map<String, Object>>> queryAppTokenBySid(@RequestParam Long sid) {
        try {
            Map map = this.iamService.queryAppTokenBySid(sid);
            return ResponseEntityWrapperUtil.wrapperOk((Object)map);
        }
        catch (Exception e) {
            log.error("query appToken by sid error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/tenant/erpSsoInfo/queryAppTokenBySid, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

