/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.sso;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.erpsso.RegisterDTO;
import com.digiwin.athena.semc.dto.mobile.CustomApplicationsListPageReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.sso.MobileSsoInfo;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.mobile.MobileDatasourceInfoService;
import com.digiwin.athena.semc.service.sso.IMobileSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/mobile/sso"})
public class MobileSsoInfoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileSsoInfoController.class);
    @Autowired
    private IMobileSsoInfoService mobileSsoInfoService;
    @Autowired
    private IThirdSsoInfoService thirdSsoInfoService;
    @Autowired
    private AppLinkService appLinkService;
    @Autowired
    private MobileDatasourceInfoService mobileDatasourceInfoService;
    @Resource
    private MessageUtils messageUtils;

    @GetMapping(value={"/queryMobileSsoList"})
    public ResponseEntity<BaseResultDTO<List<MobileSsoInfo>>> queryMobileSsoList() {
        try {
            List mobileSsoInfoList = this.mobileSsoInfoService.list();
            return ResponseEntityWrapperUtil.wrapperOk((Object)mobileSsoInfoList);
        }
        catch (Exception e) {
            log.error("MobileSsoInfoController query mobile sso list error.", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/sso/queryMobileSsoList, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/saveMobileInfo"})
    public ResponseEntity<BaseResultDTO<MobileSsoInfo>> saveMobileInfo(@RequestBody @Valid MobileSsoInfo mobileSsoInfoReq) {
        List mobileSsoInfoList = this.mobileSsoInfoService.existMobileApp(mobileSsoInfoReq);
        if (CollectionUtils.isNotEmpty((Collection)mobileSsoInfoList)) {
            if (mobileSsoInfoReq.getAppCode().equals(((MobileSsoInfo)mobileSsoInfoList.get(0)).getAppCode())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.appcode.repeat"));
            }
            if (mobileSsoInfoReq.getAppName().equals(((MobileSsoInfo)mobileSsoInfoList.get(0)).getAppName())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.appname.repeat"));
            }
            if (StringUtils.isNotBlank((CharSequence)mobileSsoInfoReq.getAppToken()) && mobileSsoInfoReq.getAppToken().equals(((MobileSsoInfo)mobileSsoInfoList.get(0)).getAppToken())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.apptoken.repeat"));
            }
        }
        boolean updateFlag = Boolean.FALSE;
        if (!ObjectUtils.isEmpty((Object)mobileSsoInfoReq.getId())) {
            MobileSsoInfo mobileSsoInfo = (MobileSsoInfo)this.mobileSsoInfoService.getBaseMapper().selectById((Serializable)mobileSsoInfoReq.getId());
            if (ObjectUtils.isEmpty((Object)mobileSsoInfo)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.app.query.not.found"));
            }
            if (ObjectUtils.isEmpty((Object)mobileSsoInfo.getAppSid())) {
                updateFlag = Boolean.TRUE;
            }
        }
        if ((updateFlag || ObjectUtils.isEmpty((Object)mobileSsoInfoReq.getId())) && Arrays.asList(Constants.BindFlagEnum.AUTO.getFlag(), Constants.BindFlagEnum.HAND.getFlag()).contains(mobileSsoInfoReq.getUserBindFlag())) {
            try {
                this.registerMobileApp(mobileSsoInfoReq);
            }
            catch (Exception e) {
                log.error("MobileSsoInfoController.saveMobileInfo invoke iam error error. param:{}", (Object)mobileSsoInfoReq, (Object)e);
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.ADAPT_SYSTEM_ERROR, (String)(this.messageUtils.getMessage("error.message.invoke.iam.error") + ":" + e.getMessage()));
            }
        }
        try {
            Long id = this.mobileSsoInfoService.saveMobileSso(mobileSsoInfoReq);
            MobileSsoInfo mobileSsoInfo = this.mobileSsoInfoService.queryMobileSsoInfo(id);
            if (Arrays.asList(Constants.BindFlagEnum.NO.getFlag(), Constants.BindFlagEnum.OUTSIDE.getFlag()).contains(mobileSsoInfoReq.getUserBindFlag())) {
                mobileSsoInfo.setAppId("");
                mobileSsoInfo.setAppSecret("");
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)mobileSsoInfo);
        }
        catch (Exception e) {
            log.error("MobileSsoInfoController save mobile info error. param:{}", (Object)mobileSsoInfoReq, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/sso/saveMobileInfo, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    private void registerMobileApp(MobileSsoInfo mobileSsoInfoReq) throws Exception {
        RegisterDTO registerReq = new RegisterDTO();
        registerReq.setName(mobileSsoInfoReq.getAppCode());
        registerReq.setDescription(mobileSsoInfoReq.getAppDesc());
        registerReq.setCallbackUrl(mobileSsoInfoReq.getCallBackUrl());
        RegisterDTO registerResp = this.thirdSsoInfoService.registerApp(registerReq);
        mobileSsoInfoReq.setAppSid(registerResp.getSid());
        mobileSsoInfoReq.setAppId(registerResp.getId());
        mobileSsoInfoReq.setAppSecret(registerResp.getSecret());
    }

    @GetMapping(value={"/delMobileInfo"})
    public ResponseEntity<BaseResultDTO<Boolean>> deleteInfo(@RequestParam Long id) {
        try {
            if (ObjectUtils.isEmpty((Object)id)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
            }
            MobileSsoInfo mobileSsoInfo = this.mobileSsoInfoService.queryMobileSsoInfo(id);
            if (ObjectUtils.isEmpty((Object)mobileSsoInfo)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.app.query.not.found"));
            }
            CustomApplicationsListPageReq customApplicationReq = new CustomApplicationsListPageReq();
            customApplicationReq.setPrimaryId(String.valueOf(id));
            List mobileDatasourceList = this.mobileDatasourceInfoService.queryDatasourceInfo(customApplicationReq);
            if (CollectionUtils.isNotEmpty((Collection)mobileDatasourceList)) {
                List mobileAppLinkList = this.appLinkService.queryMobileManageListSync(AppAuthContextHolder.getContext().getAuthoredUser());
                Map<String, String> appLinkMap = mobileAppLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, AppLinkDTO::getName, (a, b) -> a));
                ArrayList appNameList = Lists.newArrayList();
                mobileDatasourceList.forEach(x -> {
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)appLinkMap.get(x.getApplicationPrimaryId())))) {
                        appNameList.add(appLinkMap.get(x.getApplicationPrimaryId()));
                    }
                });
                String dataNames = String.join((CharSequence)"\u3001", appNameList);
                String error = String.format(this.messageUtils.getMessage("error.message.system.sso.mobile.del"), dataNames);
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            this.mobileSsoInfoService.removeById((Serializable)id);
            return ResponseEntityWrapperUtil.wrapperOk((Object)true);
        }
        catch (Exception e) {
            log.error("MobileSsoInfoController del mobile info error. id:{}", (Object)id, (Object)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/mobile/sso/delMobileInfo, message:" + e.getMessage());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

