/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.sso;

import com.digiwin.athena.semc.proxy.iam.service.IamService;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant/saml"})
public class SamlController {
    @Resource
    private IamService iamService;

    @GetMapping(value={"/saml-check"})
    public ResponseEntity<?> samlAdd(@RequestParam(value="successCallbackUrl") String successCallbackUrl, @RequestParam(value="failCallbackUrl") String failCallbackUrl) {
        return this.iamService.checkExitAndAddSAMLCallbackUrl(successCallbackUrl, failCallbackUrl);
    }

    @GetMapping(value={"/saml-add"})
    public ResponseEntity<?> addSamlCallbackUrl(@RequestParam(value="successCallbackUrl") String successCallbackUrl, @RequestParam(value="failCallbackUrl") String failCallbackUrl) {
        return this.iamService.addSamlCallbackUrl(successCallbackUrl, failCallbackUrl);
    }

    @GetMapping(value={"/authCode-login"})
    public ResponseEntity<?> authCodeLogin(@RequestParam(value="authCode") String authCode, @RequestParam(value="ssoType", required=false) String ssoType) {
        return this.iamService.queryUserTokenByAuthCode(authCode, ssoType);
    }
}

