/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.sso;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.PreinstalledApplicationTypeEnum;
import com.digiwin.athena.semc.controller.BasicController;
import com.digiwin.athena.semc.dto.erpsso.RegisterDTO;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.message.ThirdSystemMessageService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7b2c\u4e09\u65b9web\u63a5\u5165sso\u914d\u7f6e")
@RestController
@RequestMapping(value={"/tenant/thirdSsoInfo"})
public class ThirdSsoInfoController
extends BasicController<IThirdSsoInfoService, ThirdSsoInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdSsoInfoController.class);
    private static final Logger logger = LoggerFactory.getLogger(ThirdSsoInfoController.class);
    public static final int SSO_INFO_EFFECTIVE = 1;
    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;
    @Autowired
    IErpSsoInfoService erpSsoInfoService;
    @Resource
    private IamService iamService;
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    LabelSystemDataService labelSystemDataService;
    @Resource
    private ThirdSystemMessageService thirdSystemMessageService;
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;

    @Operation(summary="\u6839\u636e\u79df\u6237id\u67e5\u8be2\u654f\u6001\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/listByTenantId"})
    public ResponseEntity<BaseResultDTO<List<ThirdSsoInfo>>> queryThirdSsoList(@RequestParam(required=false, value="protocolType") Integer protocolType) {
        try {
            List thirdSsoInfoList = Lists.newArrayList();
            QueryWrapper condition = new QueryWrapper();
            if (null != protocolType) {
                condition.eq((Object)"protocol_type", (Object)protocolType);
            }
            ((QueryWrapper)condition.orderByDesc((Object)"modify_time")).orderByDesc((Object)"id");
            thirdSsoInfoList = this.thirdSsoInfoService.list((Wrapper)condition);
            return ResponseEntityWrapperUtil.wrapperOk((Object)thirdSsoInfoList);
        }
        catch (Exception e) {
            log.error("ThirdSsoInfoController query third sso list error", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Operation(summary="\u4fdd\u5b58\u654f\u6001\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"/saveThirdInfo"})
    public ResponseEntity<BaseResultDTO<ThirdSsoInfo>> saveThirdInfo(@RequestBody @Valid ThirdSsoInfo thirdSsoInfo) throws Exception {
        ThirdSsoInfoController.logger.info("save or update third ssoInfo | param:" + JSON.toJSONString((Object)thirdSsoInfo) + "");
        isSamlType = thirdSsoInfo.getProtocolType() == 3;
        isCasType = thirdSsoInfo.getProtocolType() == 2;
        thirdSsoInfoList = this.thirdSsoInfoService.existThirdSso(thirdSsoInfo.getId(), thirdSsoInfo.getAppCode(), thirdSsoInfo.getAppName(), thirdSsoInfo.getAppToken());
        if (CollectionUtils.isNotEmpty((Collection)thirdSsoInfoList)) {
            if (thirdSsoInfo.getAppCode().equals(((ThirdSsoInfo)thirdSsoInfoList.get(0)).getAppCode())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.appcode.repeat"));
            }
            if (thirdSsoInfo.getAppName().equals(((ThirdSsoInfo)thirdSsoInfoList.get(0)).getAppName())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.appname.repeat"));
            }
            if (StringUtils.isNotBlank((CharSequence)thirdSsoInfo.getAppToken()) && thirdSsoInfo.getAppToken().equals(((ThirdSsoInfo)thirdSsoInfoList.get(0)).getAppToken())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.apptoken.repeat"));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(erpSsoInfoList = this.erpSsoInfoService.existByNameOrAppToken(null, thirdSsoInfo.getAppCode(), thirdSsoInfo.getAppName(), thirdSsoInfo.getAppToken())))) {
            if (thirdSsoInfo.getAppCode().equals(((ErpSsoInfo)erpSsoInfoList.get(0)).getCode())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.cs.appcode.repeat"));
            }
            if (thirdSsoInfo.getAppName().equals(((ErpSsoInfo)erpSsoInfoList.get(0)).getName())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.cs.appname.repeat"));
            }
            if (StringUtils.isNotBlank((CharSequence)thirdSsoInfo.getAppToken()) && thirdSsoInfo.getAppToken().equals(((ErpSsoInfo)erpSsoInfoList.get(0)).getAppToken())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.cs.apptoken.repeat"));
            }
        }
        applicationList = this.preinstalledApplicationService.queryPreinstalledAppList(AppAuthContextHolder.getContext().getAuthoredUser());
        for (PreinstalledApplication application : applicationList) {
            if (!application.getApplicationName().equals(thirdSsoInfo.getAppName())) continue;
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.pre.appname.repeat"));
        }
        ssoInfo = new ThirdSsoInfo();
        updateFlag = Boolean.FALSE;
        if (thirdSsoInfo.getId() != null) {
            ssoInfo = this.thirdSsoInfoService.queryThirdSsoInfo(thirdSsoInfo.getId());
            if (ssoInfo == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.app.query.not.found"));
            }
            if (!ssoInfo.getAppCode().equals(thirdSsoInfo.getAppCode())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.appCode.change"));
            }
            if (Constants.BindFlagEnum.AUTO.getFlag().equals(thirdSsoInfo.getUserBindFlag()) || Constants.BindFlagEnum.HAND.getFlag().equals(thirdSsoInfo.getUserBindFlag())) {
                registerReq = new RegisterDTO();
                try {
                    if (isSamlType || isCasType) ** GOTO lbl54
                    if (ssoInfo.getAppSid() == null) {
                        this.registerBsApp(thirdSsoInfo);
                    }
                    registerReq = this.buildRegisterReq(thirdSsoInfo, ssoInfo.getAppSid());
                    this.iamService.updateAppInfoForIAM(registerReq);
                    updateFlag = Boolean.TRUE;
                }
                catch (Exception e) {
                    ThirdSsoInfoController.logger.error("ThirdSsoInfoController saveThirdInfo invoke iam error error, registerReq:{}, thirdSsoInfo:{}", new Object[]{registerReq, thirdSsoInfo, e});
                    return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.ADAPT_SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
                }
            }
        } else if ((Constants.BindFlagEnum.AUTO.getFlag().equals(thirdSsoInfo.getUserBindFlag()) || Constants.BindFlagEnum.HAND.getFlag().equals(thirdSsoInfo.getUserBindFlag())) && !isSamlType && !isCasType) {
            try {
                this.registerBsApp(thirdSsoInfo);
            }
            catch (Exception e) {
                ThirdSsoInfoController.logger.error("ThirdSsoInfoController saveErpInfo invoke iam error error, addSsoInfoReq:{}", (Object)thirdSsoInfo, (Object)e);
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.ADAPT_SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.invoke.iam.error"));
            }
        }
lbl54:
        // 7 sources

        try {
            if (StringUtils.isBlank((CharSequence)thirdSsoInfo.getAppId()) || ObjectUtils.isEmpty((Object)thirdSsoInfo.getAppId())) {
                uuid = UUID.randomUUID().toString();
                uuid = uuid.replace("-", "");
                thirdSsoInfo.setAppId(uuid);
            }
            ssoInfoId = this.thirdSsoInfoService.saveOrUpdateThirdSso(thirdSsoInfo);
            thirdSsoInfoResp = this.thirdSsoInfoService.queryThirdSsoInfo(ssoInfoId);
            if (Constants.BindFlagEnum.NO.getFlag().equals(thirdSsoInfo.getUserBindFlag()) || Constants.BindFlagEnum.OUTSIDE.getFlag().equals(thirdSsoInfo.getUserBindFlag())) {
                thirdSsoInfoResp.setAppId("");
                thirdSsoInfoResp.setAppSecret("");
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)thirdSsoInfoResp);
        }
        catch (Exception e) {
            if (updateFlag) {
                registerReq = this.buildRegisterReq(ssoInfo, ssoInfo.getAppSid());
                this.iamService.updateAppInfoForIAM(registerReq);
            }
            ThirdSsoInfoController.logger.info("ThirdSsoInfoController save third app error, thirdSsoInfo:{}", (Object)thirdSsoInfo, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.ADAPT_SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.save.app.error"));
        }
    }

    private void registerBsApp(ThirdSsoInfo thirdSsoInfo) throws Exception {
        RegisterDTO registerReq = this.buildRegisterReq(thirdSsoInfo, null);
        RegisterDTO registerResp = this.thirdSsoInfoService.registerApp(registerReq);
        thirdSsoInfo.setAppSid(registerResp.getSid());
        thirdSsoInfo.setAppId(registerResp.getId());
        thirdSsoInfo.setAppSecret(registerResp.getSecret());
    }

    private RegisterDTO buildRegisterReq(ThirdSsoInfo thirdSsoInfo, Long appSid) {
        RegisterDTO registerReq = new RegisterDTO();
        registerReq.setSid(appSid);
        registerReq.setName(thirdSsoInfo.getAppCode());
        registerReq.setDescription(thirdSsoInfo.getAppDesc());
        registerReq.setCallbackUrl(thirdSsoInfo.getCallBackUrl());
        registerReq.setAppToken(thirdSsoInfo.getAppToken());
        return registerReq;
    }

    @Operation(summary="\u4fee\u6539\u751f\u6548\u72b6\u6001")
    @GetMapping(value={"/updateStatus"})
    public ResponseEntity<BaseResultDTO<Boolean>> editThirdSsoStatus(@RequestParam(value="ssoInfoId") Long ssoInfoId, @RequestParam(value="status") Integer status) throws Exception {
        try {
            List systemDataList;
            if (ssoInfoId == null || status == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
            }
            ThirdSsoInfo ssoInfo = this.thirdSsoInfoService.queryThirdSsoInfo(ssoInfoId);
            if (ssoInfo == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.app.query.not.found"));
            }
            if (status == 0 && CollectionUtils.isNotEmpty((Collection)(systemDataList = this.labelSystemDataService.getDataNameList(Integer.valueOf(Integer.parseInt(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue())), ssoInfoId + "")))) {
                String dataNames = systemDataList.stream().collect(Collectors.joining("\u3001"));
                String error = String.format(this.messageUtils.getMessage("error.message.system.sso.erp.fail"), dataNames);
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            int ssoId = this.thirdSsoInfoService.updateThirdSsoStatus(ssoInfoId, status);
            return ResponseEntityWrapperUtil.wrapperOk((Object)(ssoId > 0 ? Boolean.TRUE : Boolean.FALSE));
        }
        catch (Exception e) {
            logger.info("ThirdSsoInfoController update b/s app status error. ssoInfoId:{}, status:{}", new Object[]{ssoInfoId, status, e});
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u5220\u9664\u914d\u7f6e")
    @GetMapping(value={"/deleteById"})
    public ResponseEntity<BaseResultDTO<Boolean>> deleteInfo(@RequestParam(value="ssoInfoId") Long ssoInfoId) throws Exception {
        try {
            if (ssoInfoId == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
            }
            ThirdSsoInfo ssoInfo = this.thirdSsoInfoService.queryThirdSsoInfo(ssoInfoId);
            if (ssoInfo == null) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.app.query.not.found"));
            }
            if (1 == ssoInfo.getValidStatus()) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.config.in.effect"));
            }
            List systemDataList = this.labelSystemDataService.getDataNameList(Integer.valueOf(Integer.parseInt(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue())), ssoInfoId + "");
            if (CollectionUtils.isNotEmpty((Collection)systemDataList)) {
                String dataNames = systemDataList.stream().collect(Collectors.joining("\u3001"));
                String error = String.format(this.messageUtils.getMessage("error.message.system.sso.erp.delfail"), dataNames);
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            QueryThirdMessageConfigReq queryImportRecordReq = new QueryThirdMessageConfigReq();
            queryImportRecordReq.setAppPrimaryId(String.valueOf(ssoInfoId));
            queryImportRecordReq.setAppSource(ApplicationTypeEnum.BS_APPLICATION.getType());
            PageInfoResp thirdMessageConfigPageInfoResp = this.thirdSystemMessageService.queryMessageConfigPage(queryImportRecordReq);
            if (CollectionUtils.isNotEmpty((Collection)thirdMessageConfigPageInfoResp.getList())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.system.sso.del.fail"));
            }
            Boolean flag = this.thirdSsoInfoService.removeById((Serializable)ssoInfoId);
            return ResponseEntityWrapperUtil.wrapperOk((Object)flag);
        }
        catch (Exception e) {
            logger.info("ThirdSsoInfoController delete b/s app error. ssoInfoId:{}", (Object)ssoInfoId, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @Operation(summary="\u6ce8\u518c\u5e94\u7528")
    @PostMapping(value={"/register"})
    public ResponseEntity<BaseResultDTO<RegisterDTO>> registerApp(@RequestBody RegisterDTO registerDTO) {
        try {
            if (StringUtils.isBlank((CharSequence)registerDTO.getName()) || StringUtils.isBlank((CharSequence)registerDTO.getDescription())) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
            }
            RegisterDTO registerDTOResp = this.thirdSsoInfoService.registerApp(registerDTO);
            ResultBean resultBean = new ResultBean();
            resultBean.setResponse((Object)registerDTOResp);
            return ResponseEntityWrapperUtil.wrapperOk((Object)registerDTOResp);
        }
        catch (Exception e) {
            logger.info("ThirdSsoInfoController register app error. registerDTO:{}", (Object)registerDTO, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

