/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.temp;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemDataImport;
import com.digiwin.athena.semc.entity.temp.TemplateBench;
import com.digiwin.athena.semc.entity.temp.TemplateBenchImport;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;
import com.digiwin.athena.semc.service.temp.TemplateBenchService;
import com.digiwin.athena.semc.service.temp.TemplateInfoService;
import com.digiwin.athena.semc.service.temp.impl.TemplateBenchWriteHandler;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.bench.JobBenchExportVo;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.temp.TemplateBenchImportVo;
import com.digiwin.athena.semc.vo.temp.TemplateBenchVO;
import com.digiwin.athena.semc.vo.temp.TemplateSaveVO;
import io.swagger.v3.oas.annotations.Operation;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/job/bench/temp/"})
public class TemplateBenchController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateBenchController.class);
    @Autowired
    TemplateInfoService templateInfoService;
    @Autowired
    TemplateBenchService templateBenchService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(method="saveBenchTemp", description="\u4f5c\u4e1a\u5de5\u4f5c\u53f0\u6a21\u7248\u4fdd\u5b58\u63a5\u53e3")
    @PostMapping(value={"saveBenchTemp"})
    public ResponseEntity<?> saveBenchTemp(@RequestBody TemplateBenchVO req) {
        TemplateSaveVO respVo = new TemplateSaveVO();
        if (com.alibaba.excel.util.StringUtils.isEmpty((CharSequence)req.getTemplateName())) {
            String error = this.messageUtils.getMessage("error.message.job.bench.name.empty");
            respVo.setMsg(error);
            return ResponseEntityWrapper.wrapperOk((Object)respVo);
        }
        if (req.getTemplateName().trim().length() > 12) {
            String error = String.format(this.messageUtils.getMessage("error.message.job.bench.name.empty.length"), 12);
            respVo.setMsg(error);
            return ResponseEntityWrapper.wrapperOk((Object)respVo);
        }
        if (!com.alibaba.excel.util.StringUtils.isEmpty((CharSequence)req.getTemplateDesc()) && req.getTemplateDesc().trim().length() > 100) {
            String error = String.format(this.messageUtils.getMessage("error.message.template.desc.length.error"), 100);
            respVo.setMsg(error);
            return ResponseEntityWrapper.wrapperOk((Object)respVo);
        }
        TemplateInfo nameCheckReq = new TemplateInfo();
        nameCheckReq.setId(req.getTemplateId());
        nameCheckReq.setTemplateName(req.getTemplateName());
        nameCheckReq.setTemplateType(Constants.TemplateTypeEnum.JOB_BENCH.getVal());
        List nameInfoList = this.templateInfoService.queryByParam(nameCheckReq);
        if (CollectionUtils.isNotEmpty((Collection)nameInfoList)) {
            String error = this.messageUtils.getMessage("error.message.template.name.exist.error");
            respVo.setMsg(error);
            return ResponseEntityWrapper.wrapperOk((Object)respVo);
        }
        try {
            return ResponseEntityWrapper.wrapperOk((Object)this.templateBenchService.saveBenchTemp(req));
        }
        catch (Exception e) {
            log.error("saveBenchTemp exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/saveTemplate");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="queryBenchByTemp", description="\u67e5\u8be2\u6a21\u7248\u4e0b\u4f5c\u4e1a\u5de5\u4f5c\u53f0\u63a5\u53e3")
    @PostMapping(value={"queryBenchByTemp"})
    public ResponseEntity<BaseResultDTO<TemplateBenchVO>> queryBenchByTemp(@RequestBody TemplateBenchVO req) {
        if (null == req.getTemplateId()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"templateId is null");
        }
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.templateBenchService.queryBenchByTemp(req));
        }
        catch (Exception e) {
            log.error("saveBenchTemp exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/saveTemplate");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/queryTempBenchList"})
    public ResponseEntity<BaseResultDTO<List<TemplateBench>>> queryTempBenchList() {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.templateBenchService.queryTempBenchList());
        }
        catch (Exception e) {
            log.error("queryTempBenchList exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/job/bench/queryTempBenchList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/importReport"})
    public ResponseEntity<BaseResultDTO<ImportExcelResp>> importReport(@RequestBody LabelSystemDataImport req) {
        if (StringUtils.isEmpty((String)req.getFileId())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"file code cannot be empty");
        }
        ImportExcelResp excelResp = new ImportExcelResp();
        try {
            List excelVoList = this.templateBenchService.readExcel(req.getFileId());
            if (CollectionUtils.isEmpty((Collection)excelVoList)) {
                String error = this.messageUtils.getMessage("error.message.import.cannot.be.empty");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            excelVoList = this.trimDataList(excelVoList);
            excelResp = this.templateBenchService.importReport(excelVoList);
            return ResponseEntityWrapperUtil.wrapperOk((Object)excelResp);
        }
        catch (Exception e) {
            log.error("TemplateBenchController import excel exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    public List<TemplateBenchImportVo> trimDataList(List<TemplateBenchImportVo> excelVoList) {
        for (TemplateBenchImportVo excelVo : excelVoList) {
            if (StringUtils.isNotEmpty((String)excelVo.getBenchName())) {
                excelVo.setBenchName(excelVo.getBenchName().trim());
            }
            if (StringUtils.isNotEmpty((String)excelVo.getJobName())) {
                excelVo.setJobName(excelVo.getJobName().trim());
            }
            if (!StringUtils.isNotEmpty((String)excelVo.getLaneName())) continue;
            excelVo.setLaneName(excelVo.getLaneName().trim());
        }
        return excelVoList;
    }

    @PostMapping(value={"/queryImportRecord"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<TemplateBenchImport>>> queryImportRecord(@RequestBody @Valid QueryImportRecordReq queryImportRecordReq) {
        try {
            if (StringUtils.isNotBlank((String)queryImportRecordReq.getStartTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss") || StringUtils.isNotBlank((String)queryImportRecordReq.getEndTime()) && !DateUtils.validateDate((String)queryImportRecordReq.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
            }
            PageInfoResp pageInfoResp = this.templateBenchService.queryImportRecord(queryImportRecordReq);
            return ResponseEntityWrapperUtil.wrapperOk((Object)pageInfoResp);
        }
        catch (Exception e) {
            log.error("TemplateBenchController queryImportRecord exception", (Throwable)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }

    @GetMapping(value={"/exportReport"})
    public void exportReport(HttpServletResponse response) {
        try {
            List excelVoList = this.templateBenchService.exportReport();
            String filename = "\u4f5c\u4e1a\u5de5\u4f5c\u53f0_" + LocalDate.now().toString().replace("-", "") + ".xlsx";
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename=" + new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), JobBenchExportVo.class).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).sheet("\u4f5c\u4e1a\u5de5\u4f5c\u53f0").relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)new TemplateBenchWriteHandler())).doWrite((Collection)excelVoList);
        }
        catch (Exception e) {
            log.error("TemplateBenchController exportReport exception", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

