/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.temp;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.dto.portal.UsePortalInfoDto;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.service.temp.TemplateInfoService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.QueryTempAppListVo;
import com.digiwin.athena.semc.vo.temp.TemplateCheckResp;
import com.digiwin.athena.semc.vo.temp.TemplateSaveVO;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/template/info/"})
public class TemplateInfoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateInfoController.class);
    @Autowired
    TemplateInfoService templateInfoService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private EnvProperties envProperties;

    @Operation(method="/pageQuery", description="\u67e5\u8be2\u6a21\u7248\u914d\u7f6e\u5217\u8868")
    @PostMapping(value={"/pageQuery"})
    public ResultPageBean pageQuery(@RequestBody @Valid TemplateQueryReq req) {
        return this.templateInfoService.pageQuery(req);
    }

    @Operation(method="batDel", description="\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"batDel"})
    public ResponseEntity<?> batDel(@RequestBody PortalInfoQueryReq req) {
        if (CollectionUtils.isEmpty((Collection)req.getIdList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"idList is null");
        }
        try {
            return this.templateInfoService.batDel(req.getIdList());
        }
        catch (Exception e) {
            log.error("batDel exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/batDel");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="updateStatus", description="\u53d1\u5e03\u548c\u505c\u7528")
    @PostMapping(value={"updateStatus"})
    public ResponseEntity<?> updateStatus(@RequestBody PortalInfoQueryReq req) {
        if (CollectionUtils.isEmpty((Collection)req.getIdList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"idList is null");
        }
        if (null == req.getStatus()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"status is null");
        }
        try {
            return this.templateInfoService.updateStatus(req.getIdList(), req.getStatus());
        }
        catch (Exception e) {
            log.error("updateStatus exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/updateStatus");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="batTempToTenant", description="\u6279\u91cf\u53d1\u5e03\u6a21\u7248\u5230\u79df\u6237\u63a5\u53e3")
    @PostMapping(value={"batTempToTenant"})
    public ResponseEntity<BaseResultDTO<TemplateSaveVO>> batTempToTenant(@RequestBody TemplateInfo req) {
        TemplateSaveVO respVo = new TemplateSaveVO();
        if (CollectionUtils.isEmpty((Collection)req.getIdList())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"idList is null");
        }
        if (null == req.getSubType()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"subType is null");
        }
        List loginUserIdList = this.checkToTenant(req.getIdList());
        respVo.setIsExistOther(Boolean.valueOf(false));
        if (loginUserIdList.size() != req.getIdList().size()) {
            respVo.setIsExistOther(Boolean.valueOf(true));
        }
        req.setIdList(loginUserIdList);
        if (CollectionUtils.isEmpty((Collection)req.getIdList())) {
            return ResponseEntityWrapperUtil.wrapperOk((Object)respVo);
        }
        try {
            this.templateInfoService.batTempToTenant(req);
        }
        catch (Exception e) {
            log.error("batTempToTenant exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/batTempToTenant");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)respVo);
    }

    public List<Long> checkToTenant(List<Long> idList) {
        List templateInfoList = this.templateInfoService.listByIds(idList);
        List loginUserList = templateInfoList.stream().filter(item -> Utils.getUserId().equals(item.getCreateUserId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(loginUserList)) {
            return new ArrayList<Long>();
        }
        List<Long> loginUserIdList = loginUserList.stream().map(TemplateInfo::getId).collect(Collectors.toList());
        return loginUserIdList;
    }

    @Operation(method="getUserTemplate", description="\u83b7\u53d6\u7528\u6237\u662f\u5426\u6709ISV\u6743\u9650")
    @PostMapping(value={"getUserTemplate"})
    public ResponseEntity<BaseResultDTO<TemplateCheckResp>> getUserTemplate() {
        TemplateCheckResp templateCheckResp = new TemplateCheckResp();
        templateCheckResp.setIsHaveTemp(Boolean.valueOf(false));
        templateCheckResp.setIsHaveTenant(Boolean.valueOf(false));
        try {
            List userIdList = Utils.strToList((String)this.envProperties.getTemplateUserId());
            if (Utils.getTenantId().equals(this.envProperties.getTemplateTenantId())) {
                templateCheckResp.setIsHaveTenant(Boolean.valueOf(true));
            }
            if (CollectionUtils.isNotEmpty((Collection)userIdList) && userIdList.contains(Utils.getUserId()) && templateCheckResp.getIsHaveTenant().booleanValue()) {
                templateCheckResp.setIsHaveTemp(Boolean.valueOf(true));
            }
        }
        catch (Exception e) {
            log.error("getUserTemplate exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/getUserTemplate");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)templateCheckResp);
    }

    @PostMapping(value={"/queryTempAppList"})
    public ResponseEntity<BaseResultDTO<List<QueryTempAppListVo>>> queryTempAppList(@RequestBody TemplateInfo req) {
        if (req.getServiceSource() == 0 && null == req.getId()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id is not empty");
        }
        if (req.getServiceSource() == 1 && CollectionUtils.isEmpty((Collection)req.getBenchIdList())) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"BenchIdList is not empty");
        }
        try {
            List appLinkList = this.templateInfoService.queryTempAppList(req);
            return ResponseEntityWrapperUtil.wrapperOk((Object)appLinkList);
        }
        catch (Exception e) {
            log.error("queryTempAppList exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/queryTempAppList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="checkUserTemplate", description="\u6821\u9a8c\u79df\u6237\u8be5\u6a21\u7248\u4e2d\u6e90\u5e94\u7528\u6743\u9650")
    @PostMapping(value={"checkUserTemplate"})
    public ResponseEntity<?> checkUserTemplate(@RequestBody TemplateInfo req) {
        if (null == req.getId()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id is not empty");
        }
        try {
            return this.templateInfoService.checkUserTemplate(req.getId());
        }
        catch (Exception e) {
            log.error("checkUserTemplate exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/checkUserTemplate");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="confimTenTemplate", description="\u79df\u6237\u96c5\u5178\u5a1c\u6d89\u53ca\u7ec4\u4ef6\u6743\u9650\u540c\u6b65")
    @PostMapping(value={"confimTenTemplate"})
    public ResponseEntity<?> confimTenTemplate(@RequestBody TemplateInfo req) {
        if (null == req.getId()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id is not empty");
        }
        try {
            return this.templateInfoService.confimTenTemplate(req.getId());
        }
        catch (Exception e) {
            log.error("confimTenTemplate exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/confimTenTemplate");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="usePortalInfo", description="\u7acb\u5373\u4f7f\u7528ISV\u95e8\u6237\u6a21\u7248")
    @PostMapping(value={"/usePortalInfo"})
    public ResponseEntity<BaseResultDTO<PortalInfo>> usePortalInfo(@RequestBody @Valid UsePortalInfoDto req) {
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.templateInfoService.usePortalInfo(req));
        }
        catch (Exception e) {
            log.error("usePortalInfo exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/usePortalInfo");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"checkBenchTemplate"})
    public ResponseEntity<?> checkBenchTemplate(@RequestBody UsePortalInfoDto req) {
        if (CollectionUtils.isEmpty((Collection)req.getBenchIdList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"BenchIdList is not empty");
        }
        try {
            return this.templateInfoService.checkBenchTemplate(req.getBenchIdList());
        }
        catch (Exception e) {
            log.error("checkBenchTemplate exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/checkBenchTemplate");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"confimBenchTemplate"})
    public ResponseEntity<?> confimBenchTemplate(@RequestBody UsePortalInfoDto req) {
        if (CollectionUtils.isEmpty((Collection)req.getBenchIdList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"BenchIdList is not empty");
        }
        try {
            return this.templateInfoService.confimBenchTemplate(req.getBenchIdList());
        }
        catch (Exception e) {
            log.error("confimBenchTemplate exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/confimBenchTemplate");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/useBenchTemp"})
    public ResponseEntity<?> useBenchTemp(@RequestBody @Valid UsePortalInfoDto req) {
        if (CollectionUtils.isEmpty((Collection)req.getBenchIdList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"BenchIdList is not empty");
        }
        try {
            return this.templateInfoService.useBenchTemp(req);
        }
        catch (Exception e) {
            log.error("useBenchTemp exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/template/info/useBenchTemp");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

