/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.temp;

import com.alibaba.excel.util.StringUtils;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;
import com.digiwin.athena.semc.service.temp.TemplateInfoService;
import com.digiwin.athena.semc.service.temp.TemplatePortalInfoService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.temp.TemplatePortalVO;
import com.digiwin.athena.semc.vo.temp.TemplateSaveVO;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/portal/temp/"})
public class TemplatePortalController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplatePortalController.class);
    @Autowired
    TemplateInfoService templateInfoService;
    @Autowired
    TemplatePortalInfoService templatePortalInfoService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(method="savePortalTemp", description="\u4fdd\u5b58ISV\u95e8\u6237\u6a21\u7248\u5e03\u5c40\u4fe1\u606f")
    @PostMapping(value={"savePortalTemp"})
    public ResponseEntity<?> savePortalTemp(@RequestBody @Valid TemplatePortalVO req) {
        TemplateSaveVO respVo = new TemplateSaveVO();
        if (StringUtils.isEmpty((CharSequence)req.getName())) {
            String error = this.messageUtils.getMessage("error.message.job.bench.name.empty");
            respVo.setMsg(error);
            return ResponseEntityWrapper.wrapperOk((Object)respVo);
        }
        if (req.getName().trim().length() > 30) {
            String error = String.format(this.messageUtils.getMessage("error.message.job.bench.name.empty.length"), 30);
            respVo.setMsg(error);
            return ResponseEntityWrapper.wrapperOk((Object)respVo);
        }
        if (!StringUtils.isEmpty((CharSequence)req.getPortalDesc()) && req.getPortalDesc().trim().length() > 100) {
            String error = String.format(this.messageUtils.getMessage("error.message.template.desc.length.error"), 100);
            respVo.setMsg(error);
            return ResponseEntityWrapper.wrapperOk((Object)respVo);
        }
        TemplateInfo nameCheckReq = new TemplateInfo();
        nameCheckReq.setId(req.getTemplateId());
        nameCheckReq.setTemplateName(req.getName());
        nameCheckReq.setTemplateType(Constants.TemplateTypeEnum.CLASSIC_PORTAL.getVal());
        List nameInfoList = this.templateInfoService.queryByParam(nameCheckReq);
        if (CollectionUtils.isNotEmpty((Collection)nameInfoList)) {
            String error = this.messageUtils.getMessage("error.message.template.name.exist.error");
            respVo.setMsg(error);
            return ResponseEntityWrapper.wrapperOk((Object)respVo);
        }
        try {
            return ResponseEntityWrapper.wrapperOk((Object)this.templatePortalInfoService.savePortalTemp(req));
        }
        catch (Exception e) {
            log.error("savePortalTemp exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/portal/temp/savePortalTemp");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="getPortalTemp", description="\u83b7\u53d6ISV\u95e8\u6237\u6a21\u7248\u8be6\u60c5\u6570\u636e")
    @PostMapping(value={"getPortalTemp"})
    public ResponseEntity<BaseResultDTO<TemplatePortalVO>> getPortalTemp(@RequestBody TemplatePortalVO req) {
        if (null == req.getTemplateId()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"templateId is null");
        }
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.templatePortalInfoService.getPortalTemp(req));
        }
        catch (Exception e) {
            log.error("getPortalTemp exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/portal/temp/getPortalTemp");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/pageTemplateQuery"})
    public ResultPageBean pageTemplateQuery(@RequestBody @Valid PortalInfoQueryReq req) {
        try {
            return this.templatePortalInfoService.pageQueryTemp(req);
        }
        catch (Exception e) {
            log.error("pageTemplateQuery exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/portal/temp/pageTemplateQuery");
            return ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.LABEL_SYSTEM_CUSTOM, this.messageUtils.getMessage("error.message.system.custom.open-error")));
        }
    }
}

