/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.temp;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomSaveReq;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.service.temp.TemplateSystemCustomService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/custom/component/temp"})
public class TemplateSystemCustomController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateSystemCustomController.class);
    @Resource
    TemplateSystemCustomService templateSystemCustomService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(method="pageQuery", description="\u67e5\u8be2\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5217\u8868")
    @PostMapping(value={"/pageQuery"})
    public ResultPageBean pageQuery(@RequestBody @Valid LabelSystemCustomQueryReq labelSystemCustomQueryReq) {
        ResultPageBean resultPageBean;
        try {
            resultPageBean = this.templateSystemCustomService.pageQuery(labelSystemCustomQueryReq);
        }
        catch (Exception e) {
            log.error("Query System Custom temp Error", (Throwable)e);
            resultPageBean = ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.LABEL_SYSTEM_CUSTOM, this.messageUtils.getMessage("error.message.system.custom.open-error")));
        }
        return resultPageBean;
    }

    @Operation(method="save", description="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u7ec4\u4ef6")
    @PostMapping(value={"/save"})
    public ResponseEntity<?> save(@RequestBody @Valid LabelSystemCustomSaveReq labelSystemCustomSaveReq) {
        try {
            return this.templateSystemCustomService.save(labelSystemCustomSaveReq);
        }
        catch (Exception e) {
            log.error("save system.custom error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)this.messageUtils.getMessage("error.message.system.custom.save-error"));
        }
    }

    @Operation(method="delete", description="\u5220\u9664\u81ea\u5b9a\u4e49\u7ec4\u4ef6")
    @PostMapping(value={"/delete"})
    public ResponseEntity<?> delete(@RequestBody List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)"id cannot be empty");
        }
        try {
            return this.templateSystemCustomService.delete(idList);
        }
        catch (Exception e) {
            log.error("delete system.custom error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)this.messageUtils.getMessage("error.message.system.custom.delete-error"));
        }
    }

    @Operation(method="queryCustomSystem", description="\u67e5\u8be2\u9884\u8bbe\u7ec4\u4ef6\u548c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5217\u8868")
    @PostMapping(value={"/queryCustomSystem"})
    public ResponseEntity<BaseResultDTO<List<TemplateSystemCustom>>> queryCustomSystem(@RequestBody LabelSystemAllVo req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.templateSystemCustomService.queryCustomSystem(req));
    }
}

