/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.temp;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryLabelSystemReq;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;
import com.digiwin.athena.semc.service.temp.TemplateSystemDataService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.Collection;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/system/data/temp"})
public class TemplateSystemDataController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateSystemDataController.class);
    @Autowired
    TemplateSystemDataService templateSystemDataService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(summary="\u67e5\u8be2\u6570\u636e\u6e90")
    @PostMapping(value={"/queryDataList"})
    public ResponseEntity<BaseResultDTO<PageInfoResp<TemplateSystemData>>> queryDataList(@RequestBody QueryLabelSystemReq req) {
        try {
            if (null == req.getPageNum() || null == req.getPageSize()) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing paging parameter");
            }
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.templateSystemDataService.queryDataList(req));
        }
        catch (Exception e) {
            log.error("queryDataList exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/system/data/temp/queryDataList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u542f\u7528\u505c\u7528")
    @PostMapping(value={"/updateValidStatus"})
    public ResponseEntity<?> updateValidStatus(@RequestBody QueryLabelSystemReq req) {
        try {
            if (null == req.getId()) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"id cannot be empty");
            }
            if (null == req.getValidStatus()) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"the status cannot be empty");
            }
            return this.templateSystemDataService.updateValidStatus(req);
        }
        catch (Exception e) {
            log.error("updateValidStatus exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/system/data/temp/updateValidStatus");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u6570\u636e\u6e90")
    @PostMapping(value={"/delData"})
    public ResponseEntity<?> delData(@RequestBody QueryLabelSystemReq req) {
        try {
            if (CollectionUtils.isEmpty((Collection)req.getIds())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"id cannot be empty");
            }
            return this.templateSystemDataService.delData(req);
        }
        catch (Exception e) {
            log.error("delData exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/system/data/temp/delData");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(summary="\u4fdd\u5b58\u548c\u4fee\u6539\u6570\u636e\u6e90")
    @PostMapping(value={"/saveData"})
    public ResponseEntity<?> saveData(@RequestBody @Valid TemplateSystemData req) {
        try {
            return this.templateSystemDataService.saveData(req);
        }
        catch (Exception e) {
            log.error("saveData exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/system/data/temp/saveData");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

