/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.temp;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataSourceUpdateReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemUpdateValidReq;
import com.digiwin.athena.semc.service.temp.TemplateSystemPreService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreCustomVo;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Collection;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/preset/component/temp"})
public class TemplateSystemPreController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateSystemPreController.class);
    @Resource
    TemplateSystemPreService templateSystemPreService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(method="pageQuery", description="\u67e5\u8be2\u9884\u8bbe\u7ec4\u4ef6\u5217\u8868")
    @PostMapping(value={"/pageQuery"})
    public ResultPageBean pageQuery(@RequestBody @Valid LabelSystemPreQueryReq labelSystemPreQueryReq) {
        try {
            return this.templateSystemPreService.pageQuery(labelSystemPreQueryReq);
        }
        catch (Exception e) {
            return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.LABEL_SYSTEM_PRE, (String)this.messageUtils.getMessage("error.message.system.pre.open-error")));
        }
    }

    @Operation(method="updateDataSource", description="\u66f4\u65b0\u7ec4\u4ef6\u6570\u636e\u6e90")
    @PostMapping(value={"/updateDataSource"})
    public ResponseEntity<?> updateDataSource(@RequestBody @Valid LabelSystemDataSourceUpdateReq labelSystemUpdateReq) {
        if (CollectionUtils.isEmpty((Collection)labelSystemUpdateReq.getDataSourceInfo())) {
            String error = this.messageUtils.getMessage("error.message.system.data.source.empty");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        try {
            return this.templateSystemPreService.updateDataSource(labelSystemUpdateReq);
        }
        catch (Exception e) {
            log.error("temp update dataSource error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, (String)this.messageUtils.getMessage("error.message.data.source.update-error"));
        }
    }

    @Operation(method="updateValidStatus", description="\u66f4\u65b0\u542f\u7528\u505c\u7528\u72b6\u6001")
    @PostMapping(value={"/updateValidStatus"})
    public ResponseEntity<?> updateValidStatus(@RequestBody @Valid LabelSystemUpdateValidReq labelSystemUpdateValidReq) {
        try {
            return this.templateSystemPreService.updateValidStatus(labelSystemUpdateValidReq.getId(), labelSystemUpdateValidReq.getValidStatus(), labelSystemUpdateValidReq.getComponentSource());
        }
        catch (Exception e) {
            log.error("temp update validStatus error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)this.messageUtils.getMessage("error.message.valid.status.update-error"));
        }
    }

    @Operation(method="queryAllSystem", description="\u67e5\u8be2\u9884\u8bbe\u7ec4\u4ef6\u548c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5217\u8868")
    @PostMapping(value={"/queryAllSystem"})
    public ResponseEntity<BaseResultDTO<LabelSystemPreCustomVo>> queryAllSystem(@RequestBody LabelSystemAllVo req) {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.templateSystemPreService.queryAllSystem(req));
    }
}

