/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.temp;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateUserMapping;
import com.digiwin.athena.semc.entity.temp.TemplateUserTenant;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.AppTenantDTO;
import com.digiwin.athena.semc.service.temp.TemplateUserMappingService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/temp/user/mapping/"})
public class TemplateUserMappingController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateUserMappingController.class);
    @Autowired
    TemplateUserMappingService templateUserMappingService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private IamService iamService;

    @PostMapping(value={"/queryAppAllTenant"})
    public ResponseEntity<?> queryAppAllTenant(@RequestBody TemplateUserMapping req) {
        if (StringUtils.isEmpty((CharSequence)req.getAppCode())) {
            String error = this.messageUtils.getMessage("error.message.user.mapping.appcode.missing");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)error);
        }
        try {
            ArrayList<String> appIds = new ArrayList<String>();
            appIds.add(req.getAppCode());
            List tenantInfoDTOS = this.iamService.queryTenantByApp(appIds);
            if (CollectionUtils.isNotEmpty((Collection)tenantInfoDTOS)) {
                return ResponseEntityWrapper.wrapperOk((Object)((AppTenantDTO)tenantInfoDTOS.get(0)).getTenants());
            }
            return ResponseEntityWrapper.wrapperOk((Object)tenantInfoDTOS);
        }
        catch (Exception e) {
            log.error("queryAppAllTenant exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/mapping/selMappingUserList");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/selMappingUserList"})
    public ResponseEntity<BaseResultDTO<List<TemplateUserMapping>>> selMappingUserList(@RequestBody TemplateQueryReq req) {
        try {
            List userMappingList = this.templateUserMappingService.selAllMappingUser(req.getSubUserNameId());
            return ResponseEntityWrapperUtil.wrapperOk((Object)userMappingList);
        }
        catch (Exception e) {
            log.error("selMappingUserList exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/mapping/selMappingUserList");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="/pageQueryUserTenant", description="\u5206\u9875\u67e5\u8be2\u8d26\u53f7\u5173\u8054\u79df\u6237\u5217\u8868")
    @PostMapping(value={"/pageQueryUserTenant"})
    public ResultPageBean pageQueryUserTenant(@RequestBody TemplateQueryReq req) {
        if (null == req.getPageNum()) {
            req.setPageNum(Constants.pageNum);
        }
        if (null == req.getPageSize()) {
            req.setPageSize(Constants.DEF_PAGE_SIZE);
        }
        if (null == req.getId()) {
            return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing")));
        }
        return this.templateUserMappingService.pageQueryUserTenant(req);
    }

    @Operation(method="/pageLongUserTenant", description="\u5206\u9875\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u7528\u6237\u5173\u8054\u79df\u6237\u5217\u8868")
    @PostMapping(value={"/pageLongUserTenant"})
    public ResultPageBean pageLongUserTenant(@RequestBody TemplateQueryReq req) {
        if (null == req.getPageNum()) {
            req.setPageNum(Constants.pageNum);
        }
        if (null == req.getPageSize()) {
            req.setPageSize(Constants.DEF_PAGE_SIZE);
        }
        return this.templateUserMappingService.pageLongUserTenant(req);
    }

    @Operation(method="/getLongUserTenant", description="\u67e5\u8be2\u767b\u5f55\u8d26\u53f7\u5173\u8054\u7684\u5168\u91cf\u79df\u6237")
    @PostMapping(value={"/getLongUserTenant"})
    public ResponseEntity<BaseResultDTO<List<TemplateUserTenant>>> getLongUserTenant() {
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.templateUserMappingService.getLongUserTenant());
    }

    @Operation(method="/queryUserAllTenant", description="\u67e5\u8be2\u8d26\u53f7\u5173\u8054\u7684\u5168\u91cf\u79df\u6237")
    @PostMapping(value={"/queryUserAllTenant"})
    public ResponseEntity<BaseResultDTO<List<TemplateUserTenant>>> queryUserAllTenant(@RequestBody TemplateQueryReq req) {
        if (null == req.getId()) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id is null");
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)this.templateUserMappingService.queryUserAllTenant(req.getId()));
    }

    @Operation(method="saveUserTenant", description="\u6279\u91cf\u4fdd\u5b58\u8d26\u53f7\u5173\u8054\u79df\u6237\u4fe1\u606f")
    @PostMapping(value={"saveUserTenant"})
    public ResponseEntity<?> saveUserTenant(@RequestBody List<TemplateUserMapping> req) {
        ResponseEntity responseEntity = this.checkSaveUser(req);
        if (null != responseEntity) {
            return responseEntity;
        }
        try {
            this.templateUserMappingService.saveUserTenant(req);
        }
        catch (Exception e) {
            log.error("saveUserTenant exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/mapping/saveUserTenant");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public ResponseEntity<?> checkSaveUser(List<TemplateUserMapping> req) {
        if (CollectionUtils.isEmpty(req)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"req is null");
        }
        for (TemplateUserMapping mapping : req) {
            if (StringUtils.isEmpty((CharSequence)mapping.getSubUserId())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"subUserId is null");
            }
            mapping.setModifyUserId(Utils.getUserId());
            mapping.setModifyUserName(Utils.getUserName());
            mapping.setModifyTime(DateUtils.getNowTime((String)""));
            mapping.setAppCode(mapping.getAppCode());
            for (TemplateUserTenant tenant : mapping.getSubTenantList()) {
                if (StringUtils.isEmpty((CharSequence)tenant.getSubTenantId())) {
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"subTenantId is null");
                }
                tenant.setCreateUserName(Utils.getUserName());
                tenant.setTenantId(Utils.getTenantId());
                tenant.setCreateUserId(Utils.getUserId());
                tenant.setCreateTime(DateUtils.getNowTime((String)""));
                tenant.setModifyTime(DateUtils.getNowTime((String)""));
                tenant.setModifyUserId(Utils.getUserId());
                tenant.setModifyUserName(Utils.getUserName());
            }
        }
        return null;
    }

    @Operation(method="delUserMapping", description="\u5220\u9664\u7ed1\u5b9a\u5173\u7cfb\u8d26\u53f7")
    @PostMapping(value={"delUserMapping"})
    public ResponseEntity<?> delUserMapping(@RequestBody TemplateUserMapping req) {
        if (null == req.getId()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id is null");
        }
        try {
            this.templateUserMappingService.delUserMapping(req.getId());
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("delUserMapping exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/mapping/delUserMapping");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="delUserTenant", description="\u6279\u91cf\u5220\u9664\u7528\u6237\u5173\u8054\u4e0b\u7684\u79df\u6237")
    @PostMapping(value={"delUserTenant"})
    public ResponseEntity<?> delUserTenant(@RequestBody TemplateQueryReq req) {
        if (CollectionUtils.isEmpty((Collection)req.getIdList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"idList is null");
        }
        try {
            this.templateUserMappingService.delUserTenant(req.getIdList());
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("delUserTenant exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/mapping/delUserTenant");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

