/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.temp;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroup;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroupItem;
import com.digiwin.athena.semc.service.temp.TemplateTenantGroupService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.temp.TemplateSaveVO;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/temp/user/tenant/group/"})
public class TemplatetTenantGroupController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplatetTenantGroupController.class);
    @Autowired
    TemplateTenantGroupService templateTenantGroupService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(method="saveGroup", description="\u4fdd\u5b58\u5206\u7ec4")
    @PostMapping(value={"saveGroup"})
    public ResponseEntity<BaseResultDTO<TemplateSaveVO>> saveGroup(@RequestBody TemplateTenantGroup req) {
        TemplateSaveVO respVo = new TemplateSaveVO();
        respVo.setId(req.getId());
        if (StringUtils.isEmpty((CharSequence)req.getName()) || StringUtils.isEmpty((CharSequence)req.getName().trim())) {
            String error = String.format(this.messageUtils.getMessage("error.message.job.bench.name.empty"), 20);
            respVo.setMsg(error);
            return ResponseEntityWrapperUtil.wrapperOk((Object)respVo);
        }
        if (req.getName().length() > 20) {
            String error = String.format(this.messageUtils.getMessage("error.message.name.length.max"), 20);
            respVo.setMsg(error);
            return ResponseEntityWrapperUtil.wrapperOk((Object)respVo);
        }
        List tenantGroupList = this.templateTenantGroupService.selGroupBy(req);
        if (CollectionUtils.isNotEmpty((Collection)tenantGroupList)) {
            String error = this.messageUtils.getMessage("error.message.template.group.exist.msg");
            respVo.setMsg(error);
            return ResponseEntityWrapperUtil.wrapperOk((Object)respVo);
        }
        Long id = req.getId();
        try {
            id = this.templateTenantGroupService.saveTenantGroup(req);
            respVo.setId(id);
        }
        catch (Exception e) {
            log.error("saveGroup exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/tenant/group/saveGroup");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)respVo);
    }

    @Operation(method="saveGroupTenant", description="\u4fdd\u5b58\u5206\u7ec4\u4e0b\u79df\u6237")
    @PostMapping(value={"saveGroupTenant"})
    public ResponseEntity<?> saveGroupTenant(@RequestBody TemplateTenantGroup req) {
        ResponseEntity responseEntity = this.checkSaveGroup(req);
        if (null != responseEntity) {
            return responseEntity;
        }
        try {
            this.templateTenantGroupService.saveGroupTenant(req);
        }
        catch (Exception e) {
            log.error("saveGroupTenant exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/tenant/group/saveGroupTenant");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public ResponseEntity<?> checkSaveGroup(TemplateTenantGroup req) {
        if (null == req.getId()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id is null");
        }
        TemplateTenantGroup tenantGroup = (TemplateTenantGroup)this.templateTenantGroupService.getById((Serializable)req.getId());
        if (null == tenantGroup) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"group is not exist");
        }
        if (CollectionUtils.isEmpty((Collection)req.getSubTenantList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"subTenantList is null");
        }
        for (TemplateTenantGroupItem tenant : req.getSubTenantList()) {
            if (StringUtils.isEmpty((CharSequence)tenant.getSubTenantId())) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"subTenantId is null");
            }
            if (!StringUtils.isEmpty((CharSequence)tenant.getSubTenantName())) continue;
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"subTenantName is null");
        }
        return null;
    }

    @PostMapping(value={"/queryGroupTenant"})
    public ResponseEntity<BaseResultDTO<List<TemplateTenantGroupItem>>> queryGroupTenant(@RequestBody TemplateTenantGroupItem req) {
        if (null == req.getGroupId()) {
            String error = this.messageUtils.getMessage("error.message.user.mapping.appcode.missing");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)error);
        }
        try {
            List groupItemList = this.templateTenantGroupService.queryGroupTenant(req.getGroupId());
            return ResponseEntityWrapperUtil.wrapperOk((Object)groupItemList);
        }
        catch (Exception e) {
            log.error("queryGroupTenant exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/tenant/group/queryGroupTenant");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @PostMapping(value={"/selTenantGroup"})
    public ResponseEntity<BaseResultDTO<List<TemplateTenantGroup>>> selTenantGroup(@RequestBody TemplateTenantGroup req) {
        try {
            List groupList = this.templateTenantGroupService.selTenantGroup(req);
            return ResponseEntityWrapperUtil.wrapperOk((Object)groupList);
        }
        catch (Exception e) {
            log.error("selTenantGroup exceptiona", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/tenant/group/selTenantGroup");
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="/pageQueryGroupTenant", description="\u5206\u9875\u67e5\u8be2\u5206\u7ec4\u4e0b\u79df\u6237\u5217\u8868")
    @PostMapping(value={"/pageQueryGroupTenant"})
    public ResultPageBean pageQueryGroupTenant(@RequestBody TemplateQueryReq req) {
        if (null == req.getPageNum()) {
            req.setPageNum(Constants.pageNum);
        }
        if (null == req.getPageSize()) {
            req.setPageSize(Constants.DEF_PAGE_SIZE);
        }
        if (null == req.getGroupId()) {
            return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing")));
        }
        return this.templateTenantGroupService.pageQueryGroupTenant(req);
    }

    @Operation(method="/updateStatus", description="\u542f\u7528\u505c\u7528\u5206\u7ec4")
    @PostMapping(value={"/updateStatus"})
    public ResponseEntity<?> updateStatus(@RequestBody TemplateQueryReq req) {
        if (null == req.getValidStatus()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"validStatus is null");
        }
        if (CollectionUtils.isEmpty((Collection)req.getIdList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"IdList is null");
        }
        try {
            this.templateTenantGroupService.updateStatus(req);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("updateStatus exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/tenant/group/updateStatus");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="delGroup", description="\u5220\u9664\u5206\u7ec4")
    @PostMapping(value={"delGroup"})
    public ResponseEntity<?> delGroup(@RequestBody TemplateQueryReq req) {
        if (null == req.getId()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"id is null");
        }
        try {
            this.templateTenantGroupService.delGroup(req);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("delGroup exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/tenant/group/delGroup");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }

    @Operation(method="delGroupTenant", description="\u6279\u91cf\u5220\u9664\u5206\u7ec4\u4e0b\u79df\u6237")
    @PostMapping(value={"delGroupTenant"})
    public ResponseEntity<?> delGroupTenant(@RequestBody TemplateQueryReq req) {
        if (CollectionUtils.isEmpty((Collection)req.getIdList())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"idList is null");
        }
        try {
            this.templateTenantGroupService.delGroupTenant(req.getIdList());
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("delGroupTenant exception", (Throwable)e);
            String error = String.format(this.messageUtils.getMessage("system.exception.api.fail"), LocalDateTime.now(), "/semc/temp/user/tenant/group/delGroupTenant");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
    }
}

