/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.tenant;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.service.tenant.TenantAppService;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.vo.tenant.TenantSalesPlanVO;
import io.swagger.v3.oas.annotations.Operation;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/semc/tenant/app"})
public class TenantAppController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAppController.class);
    @Resource
    private TenantAppService tenantAppService;
    @Resource
    private MessageUtils messageUtils;

    @Operation(method="\u83b7\u53d6\u79df\u6237\u6388\u6743\u7684\u9500\u552e\u65b9\u6848", description="\u83b7\u53d6\u79df\u6237\u6388\u6743\u5e94\u7528\u503c\u63a5\u53e3")
    @GetMapping(value={""})
    public ResponseEntity<BaseResultDTO<TenantSalesPlanVO>> queryTenantSalesPlan() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        try {
            return ResponseEntityWrapperUtil.wrapperOk((Object)this.tenantAppService.queryTenantSalesPlan(tenantId));
        }
        catch (Exception e) {
            log.error("TenantAppController.queryTenantSalesPlan is error, tenantId:{}", (Object)tenantId, (Object)e);
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.common.system-error"));
        }
    }
}

