/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.controller.workbench;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.dto.workbench.req.AppCustomSettingReqDto;
import com.digiwin.athena.semc.dto.workbench.req.WorkBenchDeleteAppReqDto;
import com.digiwin.athena.semc.dto.workbench.req.WorkbenchDeletePortalReqDto;
import com.digiwin.athena.semc.dto.workbench.req.WorkbenchDeployAppReqDto;
import com.digiwin.athena.semc.dto.workbench.req.WorkbenchSwitchAppReqDto;
import com.digiwin.athena.semc.service.workbench.WorkbenchAppService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/semc/work-bench/app"})
public class WorkBenchAppController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkBenchAppController.class);
    @Autowired
    private WorkbenchAppService workbenchAppService;

    @Operation(description="\u5220\u9664\u5de5\u4f5c\u53f0\u5e94\u7528")
    @PostMapping(value={"/delete"})
    public ResponseEntity<?> getCustomConfig(@RequestBody WorkBenchDeleteAppReqDto deleteAppReqDto) {
        this.workbenchAppService.deleteApp(deleteAppReqDto.getAppCode());
        return ResponseEntityWrapper.wrapperOk();
    }

    @Operation(description="\u5220\u9664\u5de5\u4f5c\u53f0\u5e94\u7528\u95e8\u6237")
    @PostMapping(value={"/deletePortal"})
    public ResponseEntity<?> deletePortal(@RequestBody WorkbenchDeletePortalReqDto deletePortalReqDto) {
        this.workbenchAppService.deletePortal(deletePortalReqDto.getApplication(), deletePortalReqDto.getPortalId());
        return ResponseEntityWrapper.wrapperOk();
    }

    @Operation(description="\u53d1\u7248\u5de5\u4f5c\u53f0\u5e94\u7528")
    @PostMapping(value={"/deploy"})
    @ResponseBody
    public ResponseEntity<?> deployApp(@RequestParam(value="deployAppReq") String deployAppReq, MultipartFile file) {
        this.workbenchAppService.deployApp((WorkbenchDeployAppReqDto)JSONObject.parseObject((String)deployAppReq, WorkbenchDeployAppReqDto.class), file);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Operation(description="\u90e8\u7f72\u5de5\u4f5c\u53f0\u5e94\u7528\u95e8\u6237")
    @PostMapping(value={"/deployPortal"})
    @ResponseBody
    public ResponseEntity<?> deployPortal(@RequestParam(value="deployAppReq") String deployAppReq, MultipartFile file) {
        this.workbenchAppService.deployApp((WorkbenchDeployAppReqDto)JSONObject.parseObject((String)deployAppReq, WorkbenchDeployAppReqDto.class), file);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Operation(description="\u5207\u7248\u5de5\u4f5c\u53f0\u5e94\u7528")
    @PostMapping(value={"/switch"})
    @ResponseBody
    public ResponseEntity<?> switchApp(@RequestBody WorkbenchSwitchAppReqDto switchAppReq) {
        this.workbenchAppService.switchApp(switchAppReq);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Operation(description="\u83b7\u53d6\u5de5\u4f5c\u53f0\u5e94\u7528\u5ba2\u5236\u914d\u7f6e")
    @PostMapping(value={"/custom-setting"})
    @ResponseBody
    public ResponseEntity<?> getAppCustomSetting(@RequestBody @Valid AppCustomSettingReqDto appCustomSettingReq) {
        List customSettings = this.workbenchAppService.getAppCustomSetting(appCustomSettingReq.getApplication());
        return ResponseEntityWrapper.wrapperOk((Object)customSettings);
    }

    @Operation(description="\u8fd0\u884c\u6001\u90e8\u7f72\u95e8\u6237\u7684\u6d88\u606f\u5df2\u8bfb\u64cd\u4f5c")
    @PostMapping(value={"/readMessage"})
    @ResponseBody
    public ResponseEntity<?> readMessage(@RequestBody @Valid AppCustomSettingReqDto appCustomSettingReq) {
        List customSettings = this.workbenchAppService.getAppCustomSetting(appCustomSettingReq.getApplication());
        return ResponseEntityWrapper.wrapperOk((Object)customSettings);
    }

    @GetMapping(value={"/getPortalsPublished"})
    public ResponseEntity<?> getPortalsPublished(@RequestParam List<Long> portalIdList, @RequestParam String tenantId) {
        return ResponseEntityWrapper.wrapperOk((Object)this.workbenchAppService.getPortalInfos(portalIdList));
    }
}

