/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.converter.event;

import com.digiwin.athena.semc.common.enums.EventTypeEnum;
import com.digiwin.athena.semc.converter.event.EventTrackingConverter;
import com.digiwin.athena.semc.entity.event.EventTracking;
import com.digiwin.athena.semc.service.event.impl.EventTrackingServiceImpl;
import com.digiwin.athena.semc.vo.event.PageQueryEventTrackingVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class EventTrackingConverterImpl
implements EventTrackingConverter {
    public PageQueryEventTrackingVO toPageQueryEventTrackingVO(EventTracking source) {
        if (source == null) {
            return null;
        }
        PageQueryEventTrackingVO pageQueryEventTrackingVO = new PageQueryEventTrackingVO();
        pageQueryEventTrackingVO.setEventType(this.eventIdToEventType(source.getEventId()));
        pageQueryEventTrackingVO.setCreateTime(source.getCreateTime());
        pageQueryEventTrackingVO.setUserNameAndId(source.getUserName() + '(' + source.getUserId() + ')');
        pageQueryEventTrackingVO.setEventDesc(EventTypeEnum.getDescByEventId((String)source.getEventId()));
        pageQueryEventTrackingVO.setEventName(EventTrackingServiceImpl.splitEventName((EventTracking)source));
        return pageQueryEventTrackingVO;
    }

    public List<PageQueryEventTrackingVO> toPageQueryEventTrackingVOList(List<EventTracking> source) {
        if (source == null) {
            return null;
        }
        ArrayList<PageQueryEventTrackingVO> list = new ArrayList<PageQueryEventTrackingVO>(source.size());
        for (EventTracking eventTracking : source) {
            list.add(this.toPageQueryEventTrackingVO(eventTracking));
        }
        return list;
    }
}

