/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.dto;

import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;

public class PageInfo
implements Serializable {
    private static final long serialVersionUID = 3949923069483970612L;
    private boolean hasNext;
    private Integer pageNo;
    private Integer pageSize;
    private Integer pageCount;
    private Integer totalResults;

    private PageInfo(Integer pageNo, Integer pageSize, Integer totalResults) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        if (Objects.nonNull(totalResults)) {
            this.totalResults = totalResults;
            this.pageCount = totalResults % pageSize == 0 ? totalResults / pageSize : totalResults / pageSize + 1;
            this.hasNext = !Objects.equals(pageNo, this.pageCount);
        }
    }

    public static PageInfo getDefaultPageInfo(Integer totalResults) {
        return new PageInfo(Integer.valueOf(1), Integer.valueOf(50), totalResults);
    }

    public static PageInfo getPageInfo(Integer pageNo, Integer pageSize, Integer totalResults) {
        return new PageInfo(pageNo, pageSize, totalResults);
    }

    public static PageInfo getPageInfo(Integer pageNo, Integer pageSize) {
        return new PageInfo(pageNo, pageSize, null);
    }

    @Generated
    public boolean isHasNext() {
        return this.hasNext;
    }

    @Generated
    public Integer getPageNo() {
        return this.pageNo;
    }

    @Generated
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Generated
    public Integer getPageCount() {
        return this.pageCount;
    }

    @Generated
    public Integer getTotalResults() {
        return this.totalResults;
    }

    @Generated
    public void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    @Generated
    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    @Generated
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    @Generated
    public void setTotalResults(Integer totalResults) {
        this.totalResults = totalResults;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageInfo)) {
            return false;
        }
        PageInfo other = (PageInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isHasNext() != other.isHasNext()) {
            return false;
        }
        Integer this$pageNo = this.getPageNo();
        Integer other$pageNo = other.getPageNo();
        if (this$pageNo == null ? other$pageNo != null : !((Object)this$pageNo).equals(other$pageNo)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$pageCount = this.getPageCount();
        Integer other$pageCount = other.getPageCount();
        if (this$pageCount == null ? other$pageCount != null : !((Object)this$pageCount).equals(other$pageCount)) {
            return false;
        }
        Integer this$totalResults = this.getTotalResults();
        Integer other$totalResults = other.getTotalResults();
        return !(this$totalResults == null ? other$totalResults != null : !((Object)this$totalResults).equals(other$totalResults));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasNext() ? 79 : 97);
        Integer $pageNo = this.getPageNo();
        result = result * 59 + ($pageNo == null ? 43 : ((Object)$pageNo).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $pageCount = this.getPageCount();
        result = result * 59 + ($pageCount == null ? 43 : ((Object)$pageCount).hashCode());
        Integer $totalResults = this.getTotalResults();
        result = result * 59 + ($totalResults == null ? 43 : ((Object)$totalResults).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageInfo(hasNext=" + this.isHasNext() + ", pageNo=" + this.getPageNo() + ", pageSize=" + this.getPageSize() + ", pageCount=" + this.getPageCount() + ", totalResults=" + this.getTotalResults() + ")";
    }
}

