/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.dto.device;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.device.DeviceBindImportTemplateVo;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Generated;

public class DeviceBindImportTemplateVo {
    @ColumnWidth(value=20)
    @ExcelProperty(index=0, value={"\u96c5\u5178\u5a1c\u8d26\u53f7"})
    @NotBlank(message="{Athena.Account}{Not.exist}")
    @Size(max=100, message="{Athena.Account}{LengthMax}")
    private @NotBlank(message="{Athena.Account}{Not.exist}") @Size(max=100, message="{Athena.Account}{LengthMax}") String userId;
    @ColumnWidth(value=20)
    @ExcelProperty(index=1, value={"\u8bbe\u5907\u7ec8\u7aef\u7c7b\u578b"})
    @NotNull(message="{Device.terminal.Type}{Required}")
    private @NotNull(message="{Device.terminal.Type}{Required}") String terminalType;
    @ColumnWidth(value=20)
    @ExcelProperty(index=2, value={"\u8bbe\u5907\u5730\u5740"})
    @NotBlank(message="{Device.Id}{Required}")
    @Size(max=100, message="{Device.Id}{LengthMax}")
    @NumberFormat(value="0")
    private @NotBlank(message="{Device.Id}{Required}") @Size(max=100, message="{Device.Id}{LengthMax}") String deviceId;
    @ColumnWidth(value=100)
    @ExcelProperty(index=3, value={"\u5931\u8d25\u539f\u56e0"})
    private String failMsg;
    @ExcelIgnore
    private String userName;

    @AssertTrue(message="{Device.TerminalType.Not.Match}")
    public @AssertTrue(message="{Device.TerminalType.Not.Match}") boolean isTerminalTypeValid() {
        return Constants.TerminalTypeEnum.getCodes().contains(this.terminalType);
    }

    public DeviceBindImportTemplateVo trim() {
        if (StrUtil.isNotBlank((CharSequence)this.userId)) {
            this.userId = this.userId.trim();
        }
        if (StrUtil.isNotBlank((CharSequence)this.terminalType)) {
            this.terminalType = this.terminalType.trim();
        }
        if (StrUtil.isNotBlank((CharSequence)this.deviceId)) {
            this.deviceId = this.deviceId.trim();
        }
        return this;
    }

    @Generated
    public static DeviceBindImportTemplateVoBuilder builder() {
        return new DeviceBindImportTemplateVoBuilder();
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @NotNull(message="{Device.terminal.Type}{Required}")
    @Generated
    public @NotNull(message="{Device.terminal.Type}{Required}") String getTerminalType() {
        return this.terminalType;
    }

    @Generated
    public String getDeviceId() {
        return this.deviceId;
    }

    @Generated
    public String getFailMsg() {
        return this.failMsg;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setTerminalType(@NotNull(message="{Device.terminal.Type}{Required}") @NotNull(message="{Device.terminal.Type}{Required}") String terminalType) {
        this.terminalType = terminalType;
    }

    @Generated
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @Generated
    public void setFailMsg(String failMsg) {
        this.failMsg = failMsg;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceBindImportTemplateVo)) {
            return false;
        }
        DeviceBindImportTemplateVo other = (DeviceBindImportTemplateVo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$terminalType = this.getTerminalType();
        String other$terminalType = other.getTerminalType();
        if (this$terminalType == null ? other$terminalType != null : !this$terminalType.equals(other$terminalType)) {
            return false;
        }
        String this$deviceId = this.getDeviceId();
        String other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        String this$failMsg = this.getFailMsg();
        String other$failMsg = other.getFailMsg();
        if (this$failMsg == null ? other$failMsg != null : !this$failMsg.equals(other$failMsg)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceBindImportTemplateVo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $terminalType = this.getTerminalType();
        result = result * 59 + ($terminalType == null ? 43 : $terminalType.hashCode());
        String $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        String $failMsg = this.getFailMsg();
        result = result * 59 + ($failMsg == null ? 43 : $failMsg.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        return result;
    }

    @Generated
    public DeviceBindImportTemplateVo(String userId, @NotNull(message="{Device.terminal.Type}{Required}") @NotNull(message="{Device.terminal.Type}{Required}") String terminalType, String deviceId, String failMsg, String userName) {
        this.userId = userId;
        this.terminalType = terminalType;
        this.deviceId = deviceId;
        this.failMsg = failMsg;
        this.userName = userName;
    }

    @Generated
    public DeviceBindImportTemplateVo() {
    }

    @Generated
    public String toString() {
        return "DeviceBindImportTemplateVo(userId=" + this.getUserId() + ", terminalType=" + this.getTerminalType() + ", deviceId=" + this.getDeviceId() + ", failMsg=" + this.getFailMsg() + ", userName=" + this.getUserName() + ")";
    }
}

