/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.mapper.mongo;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.entity.applink.AppLinkAccessDO;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Repository;

@Repository
public class AppLinkMongoMapper {
    @Resource
    private MongoTemplate appLinkMongoTemplate;
    private static final String COLLECTION_NAME = "app_link_access";

    public void access(String appId) {
        AppLinkAccessDO accessDO = new AppLinkAccessDO();
        accessDO.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        accessDO.setUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        accessDO.setAccessDate(LocalDateTime.now());
        accessDO.setAppId(appId);
        BulkOperations operations = this.appLinkMongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, COLLECTION_NAME);
        operations.insert((Object)accessDO);
        operations.execute();
    }

    public List<Map> getLatestAccesses() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"tenantId").is((Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId()).and("userId").is((Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId())), Aggregation.group((String[])new String[]{"appId"}).max("accessDate").as("accessDate"), Aggregation.project((String[])new String[]{"appId", "accessDate"}), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"accessDate"}), Aggregation.limit((long)3L)});
        return this.appLinkMongoTemplate.aggregate(agg, COLLECTION_NAME, Map.class).getMappedResults();
    }
}

