/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.mq.listener;

import cn.hutool.core.thread.ThreadUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.mq.dto.MQMessageDTO;
import com.digiwin.athena.semc.mq.strategy.WorkCommonMessageStrategyRunner;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.util.FormatUtil;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class RabbitMessageListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RabbitMessageListener.class);
    private final WorkCommonMessageStrategyRunner workCommonMessageStrategyRunner;
    private final ICacheService cacheService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitListener(queues={"semc.work.common.queue"})
    public void onWorkCommonMessage(Message message, Channel channel) throws IOException {
        MQMessageDTO messageDTO = null;
        long deliveryTag = message.getMessageProperties().getDeliveryTag();
        boolean hasMdcContext = false;
        try {
            Map mdcContext = (Map)message.getMessageProperties().getHeaders().get("mdc_context");
            if (MapUtils.isNotEmpty((Map)mdcContext)) {
                MDC.setContextMap((Map)mdcContext);
                hasMdcContext = true;
            }
            String msg = new String(message.getBody(), StandardCharsets.UTF_8);
            log.info("onWorkCommonMessage\uff1a{}", (Object)msg);
            messageDTO = (MQMessageDTO)JSON.parseObject((String)msg, MQMessageDTO.class);
            this.workCommonMessageStrategyRunner.doHandler(messageDTO);
            channel.basicAck(deliveryTag, false);
        }
        catch (Exception e) {
            log.error("onWorkCommonMessageError\uff1a", (Throwable)e);
            if (messageDTO == null) {
                channel.basicNack(deliveryTag, false, false);
            } else if (messageDTO.getRetryMaxCount() == null || messageDTO.getRetryMaxCount() <= 0) {
                channel.basicNack(deliveryTag, false, false);
            } else {
                String retryCountKey = FormatUtil.format((String)"retryCount:{}:{}", (Object[])new Object[]{messageDTO.getMessageType(), messageDTO.getMessageId()});
                String retryCountStr = this.cacheService.getValue(retryCountKey);
                int retryCount = 0;
                if (StringUtils.isNotBlank((CharSequence)retryCountStr)) {
                    retryCount = Integer.parseInt(retryCountStr);
                }
                if (retryCount <= messageDTO.getRetryMaxCount()) {
                    this.cacheService.cache(retryCountKey, String.valueOf(retryCount + 1), Duration.ofDays(1L));
                    ThreadUtil.sleep((long)2000L);
                    channel.basicNack(deliveryTag, false, true);
                } else {
                    this.cacheService.delete(retryCountKey);
                    channel.basicNack(deliveryTag, false, false);
                }
            }
        }
        finally {
            if (hasMdcContext) {
                MDC.clear();
            }
        }
    }

    @Generated
    public RabbitMessageListener(WorkCommonMessageStrategyRunner workCommonMessageStrategyRunner, ICacheService cacheService) {
        this.workCommonMessageStrategyRunner = workCommonMessageStrategyRunner;
        this.cacheService = cacheService;
    }
}

