/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.mq.sender;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.mq.dto.MQMessageDTO;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.ReturnedMessage;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

@Component
public class RabbitMessageSender
implements RabbitTemplate.ConfirmCallback,
RabbitTemplate.ReturnsCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RabbitMessageSender.class);
    @Resource
    private RabbitTemplate rabbitTemplate;

    @PostConstruct
    public void init() {
        this.rabbitTemplate.setConfirmCallback((RabbitTemplate.ConfirmCallback)this);
        this.rabbitTemplate.setReturnsCallback((RabbitTemplate.ReturnsCallback)this);
    }

    public void sendWorkCommonMsg(MQMessageDTO messageDTO) {
        if (StringUtils.isBlank((CharSequence)messageDTO.getMessageId())) {
            messageDTO.setMessageId(IdUtil.randomUUID());
        }
        log.info("sendWorkCommonMsg\uff1a{}", (Object)JSON.toJSONString((Object)messageDTO));
        Message message = (Message)MessageBuilder.withBody((byte[])JSON.toJSONString((Object)messageDTO).getBytes(StandardCharsets.UTF_8)).setDeliveryMode(MessageDeliveryMode.PERSISTENT).setHeader("mdc_context", (Object)MDC.getCopyOfContextMap()).build();
        CorrelationData correlationData = new CorrelationData(messageDTO.getMessageId());
        this.rabbitTemplate.convertAndSend("", "semc.work.common.queue", (Object)message, correlationData);
    }

    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        if (ack) {
            log.info("MQ\u6d88\u606f\u53d1\u9001\u6210\u529f\uff1a{}", (Object)correlationData.getId());
        } else {
            log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a{}", (Object)cause);
        }
    }

    public void returnedMessage(ReturnedMessage returned) {
        log.error("returnedMessage\uff1a{}", (Object)returned);
    }
}

