/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.aim.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.aim.dto.MessageBatchUserDTO;
import com.digiwin.athena.semc.proxy.aim.dto.TenantRouteTypeEnum;
import com.digiwin.athena.semc.proxy.aim.service.AimService;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AimServiceImpl
implements AimService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AimServiceImpl.class);
    private final EnvProperties envProperties;
    private final RestTemplate restTemplate;

    public TenantRouteTypeEnum getTenantRouteType(String app) {
        TenantRouteTypeEnum tenantRouteTypeEnum = null;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getAimUrl()).append("/api/aim/v1/tenant/route/getType?app=").append(app);
        try {
            log.info("getTenantRouteTypeReq\uff1a{}", (Object)app);
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && MapUtils.isNotEmpty((Map)((Map)respEntity.getBody()))) {
                log.info("getTenantRouteTypeResp\uff1a{}", respEntity.getBody());
                tenantRouteTypeEnum = TenantRouteTypeEnum.valueOf((String)((JSONObject)respEntity.getBody()).getString("response"));
            } else {
                log.info("getTenantRouteTypeEmptyResp\uff1a{}", (Object)JSON.toJSONString((Object)respEntity));
            }
        }
        catch (Exception ex) {
            log.error("getTenantRouteTypeEx", (Throwable)ex);
        }
        return tenantRouteTypeEnum;
    }

    public void removeMessageChannel(String tenantId) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getAimUrl()).append("/api/aim/v2/message/removeMessageChannel?tenantId=").append(tenantId);
        try {
            this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
        }
        catch (Exception ex) {
            log.error("removeMessageChannelEx", (Throwable)ex);
        }
    }

    public TenantRouteTypeEnum getTenantRouteTypeBySemcWeb() {
        return this.getTenantRouteType("semcweb");
    }

    public void sendNoticeMessage(List<MessageBatchUserDTO> messageBatchUserList) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = String.valueOf(MDC.get((String)"userToken"));
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HttpEntity requestEntity = new HttpEntity(messageBatchUserList, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getAimUrl()).append("/api/aim/v2/batch/user/message");
        try {
            log.info("start send notice message. url:{}, request:{}", (Object)url, (Object)JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && ObjectUtils.isNotEmpty((Object)respEntity.getBody())) {
                log.info("send notice message success. url:{}, request:{}, resp:{}", new Object[]{url, requestEntity, JSONObject.toJSONString((Object)respEntity.getBody())});
            } else {
                log.warn("send notice message return empty. url:{}, request:{}, resp:{}", new Object[]{url, requestEntity, JSONObject.toJSONString((Object)respEntity.getBody())});
            }
        }
        catch (Exception ex) {
            log.error("send notice message error. url:{}, request:{}, errorMessage:{}", new Object[]{url, requestEntity, ex.getMessage()});
            throw BusinessException.create((String)ex.getMessage());
        }
    }

    @Generated
    public AimServiceImpl(EnvProperties envProperties, RestTemplate restTemplate) {
        this.envProperties = envProperties;
        this.restTemplate = restTemplate;
    }
}

