/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.ania.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.dto.BaseResultDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.ania.service.AniaService;
import com.digiwin.athena.semc.proxy.ania.service.model.KnowledgeAssistantDTO;
import com.digiwin.athena.semc.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AniaServiceImpl
implements AniaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AniaServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    private static final String QUERY_KNOWLEDGE_URL = "/ania/api/assistant/getKnowledgeAssistants?code=DWCK0130NavAsst";

    public List<KnowledgeAssistantDTO> getKnowledgeAssistants(String tenantId) {
        List<Object> knowledgeAssistantDTOArrayList = new ArrayList<KnowledgeAssistantDTO>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", Utils.getUserToken());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getAniaUrl()).append(QUERY_KNOWLEDGE_URL);
        try {
            log.info("getKnowledgeAssistants. url:{}", (Object)url);
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("getKnowledgeAssistants. url:{}, resp:{}", (Object)url, (Object)JSON.toJSONString((Object)respEntity.getBody()));
            if (200 != respEntity.getStatusCodeValue() || respEntity.getBody() == null) {
                return knowledgeAssistantDTOArrayList;
            }
            BaseResultDTO baseResultDTO = (BaseResultDTO)JSON.parseObject((String)JSON.toJSONString((Object)respEntity.getBody()), BaseResultDTO.class);
            knowledgeAssistantDTOArrayList = JSON.parseArray((String)JSON.toJSONString((Object)baseResultDTO.getResponse()), KnowledgeAssistantDTO.class);
            if (CollectionUtils.isNotEmpty(knowledgeAssistantDTOArrayList)) {
                knowledgeAssistantDTOArrayList = knowledgeAssistantDTOArrayList.stream().filter(d -> {
                    boolean x = false;
                    if (Objects.nonNull(d.getAssistantCode()) && (d.getAssistantCode().contains("public") || d.getAssistantCode().contains(tenantId))) {
                        x = true;
                    }
                    return x;
                }).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            return knowledgeAssistantDTOArrayList;
        }
        return knowledgeAssistantDTOArrayList;
    }
}

