/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.athena.service.atmc.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.dto.BaseResultDTO;
import com.digiwin.athena.semc.dto.homepage.HomeSearchDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.athena.service.atmc.AtmcService;
import com.digiwin.athena.semc.proxy.athena.service.atmc.model.GroupRuleDTO;
import com.digiwin.athena.semc.proxy.athena.service.atmc.model.GroupValueDTO;
import com.digiwin.athena.semc.util.Utils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AtmcServiceImpl
implements AtmcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtmcServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    private static final String QUERY_GROUP_URL = "/api/atmc/v1/semc/groupRule";
    private static final String QUERY_GROUP_CONDITION_URL = "/api/atmc/v1/semc/groupRuleOptions?groupCode=";
    private static final String QUERY_GROUP_VALUE_URL = "/api/atmc/v1/semc/backlogQuantity";
    private static final String SEARCH_RESULT = "/api/atmc/v1/search/result";

    public List<HomeSearchDTO> searchResult(String name, String userToken, Integer type) {
        List<Object> athenaSearchResult = new ArrayList<HomeSearchDTO>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("token", userToken);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("name", name);
        requestMap.put("type", type);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getTaskmapUrl()).append(SEARCH_RESULT);
        try {
            log.info("\u8bf7\u6c42\u5c0fAI\u83b7\u53d6\u641c\u7d20\u7ed3\u679cstart url:{},userToken:{},req:{}", new Object[]{url, userToken, requestMap});
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                BaseResultDTO baseResultDTO = (BaseResultDTO)JSON.parseObject((String)JSON.toJSONString((Object)respEntity.getBody()), BaseResultDTO.class);
                athenaSearchResult = JSON.parseArray((String)JSON.toJSONString((Object)baseResultDTO.getResponse()), HomeSearchDTO.class);
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5c0fAI\u83b7\u53d6\u641c\u7d20\u7ed3\u679c\u5f02\u5e38, \u7528\u6237token:{},   request:{}, url:{}, errorMsg:{}", new Object[]{userToken, requestMap, url, e});
            return athenaSearchResult;
        }
        return athenaSearchResult;
    }

    public List<GroupRuleDTO> queryGroupRule() {
        List<Object> groupRuleList = new ArrayList<GroupRuleDTO>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", Utils.getUserToken());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getTaskmapUrl()).append(QUERY_GROUP_URL);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("query group rule end. url:{}, param:{}, resp:{}", new Object[]{url, requestEntity, JSON.toJSONString((Object)respEntity.getBody())});
            if (200 != respEntity.getStatusCodeValue() || respEntity.getBody() == null) {
                log.error("query group rule fail. url:{}, param:{}, resp:{}", new Object[]{url, requestEntity, respEntity.getBody()});
                return groupRuleList;
            }
            BaseResultDTO baseResultDTO = (BaseResultDTO)JSON.parseObject((String)JSON.toJSONString((Object)respEntity.getBody()), BaseResultDTO.class);
            groupRuleList = JSON.parseArray((String)JSON.toJSONString((Object)baseResultDTO.getResponse()), GroupRuleDTO.class);
        }
        catch (Exception e) {
            log.error("query group rule error. url:{}, param:{}", new Object[]{url, requestEntity, e});
            return groupRuleList;
        }
        return groupRuleList;
    }

    public List<GroupRuleDTO> queryGroupConditionRule(String groupCode) {
        List<Object> groupRuleList = new ArrayList<GroupRuleDTO>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", Utils.getUserToken());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getTaskmapUrl()).append(QUERY_GROUP_CONDITION_URL).append(groupCode);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("query group condition rule end. url:{}, param:{}, resp:{}", new Object[]{url, requestEntity, JSON.toJSONString((Object)respEntity.getBody())});
            if (200 != respEntity.getStatusCodeValue() || respEntity.getBody() == null) {
                log.error("query group condition rule fail. url:{}, param:{}, resp:{}", new Object[]{url, requestEntity, respEntity.getBody()});
                return groupRuleList;
            }
            BaseResultDTO baseResultDTO = (BaseResultDTO)JSON.parseObject((String)JSON.toJSONString((Object)respEntity.getBody()), BaseResultDTO.class);
            groupRuleList = JSON.parseArray((String)JSON.toJSONString((Object)baseResultDTO.getResponse()), GroupRuleDTO.class);
        }
        catch (Exception e) {
            log.error("query group condition rule error. url:{}, param:{}", new Object[]{url, requestEntity, e});
            return groupRuleList;
        }
        return groupRuleList;
    }

    public List<GroupValueDTO> queryGroupTodoValue(String clientId, List<JSONObject> groupList) {
        List<Object> groupValueList = new ArrayList<GroupValueDTO>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", Utils.getUserToken());
        HashMap map = Maps.newHashMap();
        map.put("clientId", clientId);
        map.put("groups", groupList);
        HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getTaskmapUrl()).append(QUERY_GROUP_VALUE_URL);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("query group Todo value end. url:{}, param:{}, resp:{}", new Object[]{url, requestEntity, JSON.toJSONString((Object)respEntity.getBody())});
            if (200 != respEntity.getStatusCodeValue() || respEntity.getBody() == null) {
                log.error("query group Todo value fail. url:{}, param:{}, resp:{}", new Object[]{url, requestEntity, respEntity.getBody()});
                return groupValueList;
            }
            BaseResultDTO baseResultDTO = (BaseResultDTO)JSON.parseObject((String)JSON.toJSONString((Object)respEntity.getBody()), BaseResultDTO.class);
            groupValueList = JSON.parseArray((String)JSON.toJSONString((Object)baseResultDTO.getResponse()), GroupValueDTO.class);
        }
        catch (Exception e) {
            log.warn("query group Todo value error{}", (Object)e.getMessage(), (Object)e);
            return groupValueList;
        }
        return groupValueList;
    }
}

