/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.athena.service.audc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.athena.service.audc.AudcService;
import com.digiwin.athena.semc.proxy.athena.service.audc.model.AuthorityMenuDTO;
import com.digiwin.athena.semc.proxy.athena.service.audc.model.SystemMenuDTO;
import com.digiwin.athena.semc.proxy.athena.service.audc.model.UserTrackExtendDTO;
import com.digiwin.athena.semc.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AudcServiceImpl
implements AudcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AudcServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    private static final String QUERY_SYSTEM_MENU_URL = "/api/amtc/v1/commonUsed/getSystemMenu";
    private static final String QUERY_AUTHORITY_MENU_URL = "/api/amtc/v1/commonUsed/getAuthorityMenu";
    private static final String USER_TRACK_REPORT = "/api/v1/user/track/report";

    public List<SystemMenuDTO> querySystemMenu() {
        List<Object> systemMenuDTOList = new ArrayList<SystemMenuDTO>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", Utils.getUserToken());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getBaseUrl()).append(QUERY_SYSTEM_MENU_URL);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("query system menu end. url:{}, resp:{}", (Object)url, (Object)JSON.toJSONString((Object)respEntity.getBody()));
            if (200 != respEntity.getStatusCodeValue() || respEntity.getBody() == null) {
                log.error("query system menu fail, url:{}, statusCode:{}, resp:{}", new Object[]{url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
                return systemMenuDTOList;
            }
            com.digiwin.athena.semc.dto.BaseResultDTO baseResultDTO = (com.digiwin.athena.semc.dto.BaseResultDTO)JSON.parseObject((String)JSON.toJSONString((Object)respEntity.getBody()), com.digiwin.athena.semc.dto.BaseResultDTO.class);
            systemMenuDTOList = JSON.parseArray((String)JSON.toJSONString((Object)baseResultDTO.getResponse()), SystemMenuDTO.class);
        }
        catch (Exception e) {
            log.error("query system menu error, url:{}", (Object)url, (Object)e);
            return systemMenuDTOList;
        }
        return systemMenuDTOList;
    }

    public List<AuthorityMenuDTO> queryAuthorityMenu(JSONArray reqBody) {
        List<Object> authorityList = new ArrayList<AuthorityMenuDTO>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", Utils.getUserToken());
        HttpEntity requestEntity = new HttpEntity((Object)reqBody, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getBaseUrl()).append(QUERY_AUTHORITY_MENU_URL);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("query system authority end. url:{}, param:{}, resp:{}", new Object[]{url, requestEntity, JSON.toJSONString((Object)respEntity.getBody())});
            if (200 != respEntity.getStatusCodeValue() || respEntity.getBody() == null) {
                log.error("query authority menu fail, url:{}, param:{}, statusCode:{}, resp:{}", new Object[]{url, requestEntity, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
                return authorityList;
            }
            com.digiwin.athena.semc.dto.BaseResultDTO baseResultDTO = (com.digiwin.athena.semc.dto.BaseResultDTO)JSON.parseObject((String)JSON.toJSONString((Object)respEntity.getBody()), com.digiwin.athena.semc.dto.BaseResultDTO.class);
            authorityList = JSON.parseArray((String)JSON.toJSONString((Object)baseResultDTO.getResponse()), AuthorityMenuDTO.class);
        }
        catch (Exception e) {
            log.error("query authority menu error, url:{}, param:{}", new Object[]{url, requestEntity, e});
            return authorityList;
        }
        return authorityList;
    }

    public void reportUserTrack(AuthoredUser authoredUser, List<UserTrackExtendDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String uri = this.envProperties.getBaseUrl() + USER_TRACK_REPORT;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());
        try {
            HttpEntity httpEntity = new HttpEntity((Object)JsonUtils.objectToString(list), (MultiValueMap)headers);
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (respEntity.getStatusCode() == HttpStatus.OK) {
                ((BaseResultDTO)Objects.requireNonNull(respEntity.getBody())).getResponse();
            } else {
                log.error("exception.audc.report.userTrack.fail", (Object)httpEntity);
            }
        }
        catch (Exception e) {
            log.error("exception.audc.report.userTrack.fail", (Object)e.getMessage());
        }
    }
}

