/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.cac.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.cac.service.CacService;
import com.digiwin.athena.semc.proxy.cac.service.dto.CacBaseResultDTO;
import com.digiwin.athena.semc.proxy.cac.service.dto.TenantAuthAppDTO;
import com.digiwin.athena.semc.proxy.cac.service.dto.UserAppDTO;
import io.vavr.Tuple2;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CacServiceImpl
implements CacService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;

    public boolean verifyAppAuthorized(String tenantId, String code) {
        return (Boolean)this.verifyAppAuthorizedResult((String)tenantId, (String)code)._2;
    }

    public Tuple2<String, Boolean> verifyAppAuthorizedResult(String tenantId, String code) {
        String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenants/" + tenantId + "/goods/" + code;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, Map.class, new Object[0]);
            log.debug("verify if the app is authorized, tenantId:{}, code:{}, result:{}", new Object[]{tenantId, code, JsonUtils.objectToString((Object)response)});
            if (response.getBody() != null && ((Map)response.getBody()).containsKey("purchaseId")) {
                String expiredTime = String.valueOf(((Map)response.getBody()).get("expiredTime"));
                boolean result = LocalDateTime.now().compareTo(LocalDateTime.parse(expiredTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))) < 0;
                return new Tuple2((Object)code, (Object)result);
            }
        }
        catch (Exception ex) {
            log.error("verify if the app is authorized occur error, tenantId:{}, code:{}", new Object[]{tenantId, code, ex});
        }
        return new Tuple2((Object)code, (Object)false);
    }

    public JSONArray queryCurrentUserAppList() {
        String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/current/user/apps";
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
            headers.add("digi-middleware-auth-user", userToken);
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return ((JSONObject)respEntity.getBody()).getJSONArray("data");
            }
            log.info("query current user app list return empty. url:{}, token:{}, statusCode:{}, response:{}", new Object[]{url, userToken, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return null;
        }
        catch (Exception ex) {
            log.error("query current user app list occur error, userToken:{}, code:{}", (Object)userToken, (Object)ex);
            return null;
        }
    }

    public List<UserAppDTO> queryUserApp(String userId) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/current/user/apps?userId={userId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            if (null != responseEntity.getBody() && String.valueOf(HttpStatus.OK.value()).equals(((CacBaseResultDTO)responseEntity.getBody()).getCode())) {
                return (List)((CacBaseResultDTO)responseEntity.getBody()).getData();
            }
        }
        catch (Exception ex) {
            log.error("execute cac [/authorizations/current/user/apps] fail, message = {}", (Object)ex.getMessage());
        }
        return null;
    }

    public List<UserAppDTO> queryUserApp() {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/current/user/apps";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (null != responseEntity.getBody() && String.valueOf(HttpStatus.OK.value()).equals(((CacBaseResultDTO)responseEntity.getBody()).getCode())) {
                return (List)((CacBaseResultDTO)responseEntity.getBody()).getData();
            }
        }
        catch (Exception ex) {
            log.error("execute cac [/authorizations/current/user/apps] fail, message = {}", (Object)ex.getMessage());
        }
        return null;
    }

    public TenantAuthAppDTO queryTenantApp(int expireType) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/current/simple";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, Integer> body = new HashMap<String, Integer>();
        body.put("queryExpire", expireType);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, new HttpEntity(body, (MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (null != responseEntity.getBody() && String.valueOf(HttpStatus.OK.value()).equals(((CacBaseResultDTO)responseEntity.getBody()).getCode())) {
                return (TenantAuthAppDTO)((CacBaseResultDTO)responseEntity.getBody()).getData();
            }
        }
        catch (Exception ex) {
            log.error("execute cac [/authorizations/current/user/apps] fail, message = {}", (Object)ex.getMessage());
        }
        return null;
    }
}

