/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.proxy.dmc.service.impl;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.dmc.service.DMCTokenBean;
import com.digiwin.athena.semc.proxy.dmc.service.DmcConfig;
import com.digiwin.athena.semc.proxy.dmc.service.DmcService;
import com.digiwin.athena.semc.proxy.dmc.service.FileInfo;
import com.digiwin.athena.semc.proxy.dmc.service.MidWareResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class DmcServiceImpl
implements DmcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmcServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    @Autowired
    private DMCTokenBean dmcTokenBean;
    @Autowired
    private DmcConfig dmcConfig;
    private static final String DMC_LOGIN_PATH = "/api/dmc/v1/auth/login";
    private static final String DMC_FILE_INFO_PATH = "/api/dmc/v2/fileinfo/intelligententry/ids";

    public String loginDmc() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("username", "entrance");
        requestMap.put("pwdhash", "1OOWFo386jQGUNKoYQ/XL2doLTXfEpHKQJpNQK5Sxf4=");
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getDmcUri()).append(DMC_LOGIN_PATH);
        try {
            log.info("loginDmc param:" + JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return ((JSONObject)respEntity.getBody()).getString("userToken");
            }
            log.error("loginDmc return fail, url:{}, status:{}, response:{}", new Object[]{url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            throw BusinessException.create((String)"loginDmc return fail");
        }
        catch (Exception ex) {
            log.error("loginDmc error, url:{}, errorMessage:{}", (Object)url, (Object)ex.getMessage());
            throw BusinessException.create((String)ex.getMessage());
        }
    }

    public JSONArray queryFileInfoList(List<String> fileIdList, String dmcUserToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", dmcUserToken);
        HttpEntity requestEntity = new HttpEntity(fileIdList, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getDmcUri()).append(DMC_FILE_INFO_PATH);
        try {
            log.info("query file info list, param:" + JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return ((JSONObject)respEntity.getBody()).getJSONArray("data");
            }
            log.info("query file info list return empty, url:{}, status:{}, response:{}", new Object[]{url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return new JSONArray();
        }
        catch (Exception ex) {
            log.error("query file info list error, url:{}, errorMessage:{}", (Object)url, (Object)ex.getMessage());
            return new JSONArray();
        }
    }

    public String upload(File file, String contentType, FileInfo fileInfo) {
        return this.upload(file.getName(), FileUtil.readBytes((File)file), contentType, fileInfo);
    }

    public String upload(String fileName, byte[] bytes, String contentType, FileInfo fileInfo) {
        this.dmcTokenBean.setToken(this.loginDmc());
        String dmcUrl = this.dmcConfig.getUrl();
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        HttpHeaders header = new HttpHeaders();
        header.add("digi-middleware-auth-user", this.dmcTokenBean.getToken());
        ArrayList<String> fileIdList = new ArrayList<String>();
        fileIdList.add(fileInfo.getId());
        JSONArray jsonArray = this.queryFileInfoList(fileIdList, this.dmcTokenBean.getToken());
        if (jsonArray != null && jsonArray.size() == 1) {
            log.info("\u6587\u4ef6\u5b58\u5728\uff0c\u6587\u4ef6id:{}", (Object)fileInfo.getId());
            return null;
        }
        HttpHeaders fileHeader = new HttpHeaders();
        fileHeader.setContentType(MediaType.parseMediaType((String)contentType));
        fileHeader.setContentDispositionFormData("file", fileName);
        HttpHeaders fileInfoHeader = new HttpHeaders();
        fileInfoHeader.setContentType(MediaType.APPLICATION_JSON);
        try {
            HttpEntity fileEntity = new HttpEntity((Object)new ByteArrayResource(bytes), (MultiValueMap)fileHeader);
            JSONObject jsonObject = new JSONObject();
            jsonObject.fluentPut("id", (Object)fileInfo.getId());
            HttpEntity fileInfoEntity = new HttpEntity((Object)jsonObject, (MultiValueMap)fileInfoHeader);
            multiValueMap.add((Object)"file", (Object)fileEntity);
            multiValueMap.add((Object)"fileInfo", (Object)fileInfoEntity);
            String url = dmcUrl + "/api/dmc/v2/file" + "/intelligententry" + "/upload";
            HttpEntity httpEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)header);
            log.info("\u8c03\u7528DMC\u7684url\u662f: {}", (Object)url);
            log.info("\u8c03\u7528DMC\u7684header\u662f: {}", (Object)JSONObject.toJSONString((Object)header));
            ResponseEntity postForEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, MidWareResponse.class, new Object[0]);
            MidWareResponse midWareResponse = (MidWareResponse)postForEntity.getBody();
            if (midWareResponse.getSuccess().booleanValue()) {
                return (String)((Map)midWareResponse.getData()).get("id");
            }
            log.error("\u8c03\u7528\u4e0a\u4f20api\u5931\u8d25,\u8fd4\u56de\u6570\u636e:" + midWareResponse);
            throw BusinessException.create((String)"Failed to call the upload API");
        }
        catch (Exception ex) {
            if (ex instanceof HttpClientErrorException) {
                HttpClientErrorException httpClientErrorException = (HttpClientErrorException)ex;
                int statusCode = httpClientErrorException.getStatusCode().value();
                if (statusCode == 401) {
                    this.dmcTokenBean.setToken(this.loginDmc());
                }
                log.error("dmc\u7528\u6237token\u5931\u6548\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + ex.getMessage(), (Throwable)ex);
                throw BusinessException.create((String)"dmc\u7528\u6237token\u5931\u6548\uff01\u7528\u6237token\u73b0\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u7f16\u8bd1");
            }
            log.error("\u8c03\u7528DMC\u4e0a\u4f20\u6587\u4ef6api\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + ex.getMessage(), (Throwable)ex);
            throw BusinessException.create((String)("\u8c03\u7528DMC\u4e0a\u4f20\u6587\u4ef6api\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + ex.getMessage()), (Throwable)ex);
        }
    }
}

